/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.logic.instructions;

import arc.Core;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Objects;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.logic.LExecutor;
import mindustry.logic.LVar;
import mindustry.ui.Styles;
import newhorizon.content.NHBullets;
import newhorizon.content.NHContent;
import newhorizon.content.NHSounds;
import newhorizon.content.bullets.RaidBullets;
import newhorizon.expand.game.MapObjectives.TriggerObjective;
import newhorizon.util.ui.NHUIFunc;

public class RaidControlI
implements LExecutor.LInstruction {
    public LVar flag;
    public LVar timer;
    public LVar alertTime;
    public LVar raidTime;
    public LVar team;
    public LVar type;
    public LVar count;
    public LVar sourceX;
    public LVar sourceY;
    public LVar targetX;
    public LVar targetY;
    public LVar inaccuracy;
    public int raidCounter = 0;
    public float curTime;
    public boolean iconShown = false;

    public RaidControlI(LVar flag, LVar timer, LVar alertTime, LVar raidTime, LVar team, LVar type, LVar count, LVar sourceX, LVar sourceY, LVar targetX, LVar targetY, LVar inaccuracy) {
        this.flag = flag;
        this.timer = timer;
        this.alertTime = alertTime;
        this.raidTime = raidTime;
        this.team = team;
        this.type = type;
        this.count = count;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.targetX = targetX;
        this.targetY = targetY;
        this.inaccuracy = inaccuracy;
    }

    public RaidControlI() {
    }

    public void run(LExecutor exec) {
        if (!Vars.state.rules.objectiveFlags.contains((Object)this.flag.name)) {
            exec.counter.numval -= 1.0;
            exec.yield = true;
            return;
        }
        float totalTime = this.alertTime.numf() + this.raidTime.numf();
        if (this.curTime >= totalTime) {
            this.reset();
        } else {
            exec.counter.numval -= 1.0;
            exec.yield = true;
            this.curTime += Time.delta / 60.0f;
            if (!this.iconShown) {
                this.showAlert();
            }
            if (this.curTime > this.alertTime.numf()) {
                float raidTimer = this.curTime - this.alertTime.numf();
                int raidCount = Mathf.round((float)(raidTimer / this.raidTime.numf() * (float)this.count.numi()));
                int raid = raidCount - this.raidCounter;
                this.raidCounter = raidCount;
                for (int i = 0; i < raid; ++i) {
                    this.createBullet();
                }
            }
        }
    }

    public void reset() {
        this.curTime = 0.0f;
        this.iconShown = false;
        Vars.state.rules.objectiveFlags.remove((Object)this.flag.name);
    }

    public void createBullet() {
        Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)(this.inaccuracy.numf() * 8.0f)));
        float sx = this.sourceX.numf() * 8.0f;
        float sy = this.sourceY.numf() * 8.0f;
        float tx = this.targetX.numf() * 8.0f;
        float ty = this.targetY.numf() * 8.0f;
        float dst = Mathf.dst((float)sx, (float)sy, (float)tx, (float)ty);
        float ang = Angles.angle((float)sx, (float)sy, (float)tx, (float)ty);
        float lifetimeScl = dst / (this.bulletType().speed * this.bulletType().lifetime);
        Call.createBullet((BulletType)this.bulletType(), (Team)this.team.team(), (float)(sx + Tmp.v1.x), (float)(sy + Tmp.v1.y), (float)ang, (float)-1.0f, (float)1.0f, (float)lifetimeScl);
    }

    public void showAlert() {
        NHUIFunc.showLabel(2.5f, (Cons<Table>)((Cons)t -> {
            t.background(Styles.black5);
            t.table(t2 -> {
                t2.image().growX().height(6.0f).pad(4.0f).padRight(-9.0f).color(this.team.team().color);
                t2.image(NHContent.raid).fill().color(this.team.team().color);
                t2.image().growX().height(6.0f).pad(4.0f).padLeft(-9.0f).color(this.team.team().color);
            }).growX().pad(6.0f).fillY().row();
            t.table(l -> l.add((Element)new FLabel((CharSequence)("<< " + Core.bundle.get("nh.cutscene.event.raid-alert") + " >>"))).color(this.team.team().color).padBottom(4.0f).row()).growX().fillY();
        }));
        NHSounds.alert2.play();
        Vars.state.rules.objectives.each(mapObjective -> {
            if (mapObjective instanceof TriggerObjective) {
                TriggerObjective obj = (TriggerObjective)((Object)mapObjective);
                if (Objects.equals(obj.timer, this.timer.name)) {
                    obj.trigger(this.alertTime.numf() * 60.0f);
                }
            }
        });
        this.iconShown = true;
        this.raidCounter = 0;
    }

    public BulletType bulletType() {
        if (this.type.numi() < 10000) {
            BulletType bulletType;
            switch (this.type.numi()) {
                case 1: {
                    bulletType = RaidBullets.raidBullet_1;
                    break;
                }
                case 2: {
                    bulletType = RaidBullets.raidBullet_2;
                    break;
                }
                case 3: {
                    bulletType = RaidBullets.raidBullet_3;
                    break;
                }
                case 4: {
                    bulletType = RaidBullets.raidBullet_4;
                    break;
                }
                case 5: {
                    bulletType = RaidBullets.raidBullet_5;
                    break;
                }
                case 6: {
                    bulletType = RaidBullets.raidBullet_6;
                    break;
                }
                case 7: {
                    bulletType = RaidBullets.raidBullet_7;
                    break;
                }
                case 8: {
                    bulletType = RaidBullets.raidBullet_8;
                    break;
                }
                default: {
                    bulletType = NHBullets.railGun1;
                }
            }
            return bulletType;
        }
        if (Vars.content.bullet(this.type.numi() - 10000) != null) {
            return Vars.content.bullet(this.type.numi() - 10000);
        }
        return Vars.content.bullet(0);
    }
}

