/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.logic.instructions;

import arc.math.geom.Bresenham2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.logic.LExecutor;
import mindustry.logic.LVar;
import mindustry.world.Tile;

public class LineTargetI
implements LExecutor.LInstruction {
    public LVar team;
    public LVar sourceX;
    public LVar sourceY;
    public LVar targetX;
    public LVar targetY;
    public LVar outX;
    public LVar outY;

    public LineTargetI(LVar team, LVar sourceX, LVar sourceY, LVar targetX, LVar targetY, LVar outX, LVar outY) {
        this.team = team;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.targetX = targetX;
        this.targetY = targetY;
        this.outX = outX;
        this.outY = outY;
    }

    public void run(LExecutor exec) {
        Team t = this.team.team();
        if (t == null) {
            return;
        }
        int sx = this.sourceX.numi();
        int sy = this.sourceY.numi();
        int tx = this.targetX.numi();
        int ty = this.targetY.numi();
        Seq tiles = new Seq();
        Bresenham2.line((int)sx, (int)sy, (int)tx, (int)ty, (x, y) -> {
            if (Vars.world.tile(x, y) != null) {
                tiles.add((Object)Vars.world.tile(x, y));
            }
        });
        int ox = -1;
        int oy = -1;
        for (Tile tile : tiles) {
            if (tile.team() != t) continue;
            ox = tile.x;
            oy = tile.y;
            break;
        }
        this.outX.setnum((double)(ox * 8));
        this.outY.setnum((double)(oy * 8));
    }
}

