/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Puddles;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Fire;
import mindustry.gen.Groups;
import mindustry.gen.Puddle;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.graphics.Drawf;
import mindustry.world.Tile;
import mindustry.world.meta.Attribute;
import newhorizon.NewHorizon;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.entities.EntityRegister;

public class UltFire
extends Fire {
    public static final float baseLifetime = 1200.0f;
    public static TextureRegion[] ultRegion = new TextureRegion[40];
    public static final Effect remove = new Effect(70.0f, e -> {
        Draw.alpha((float)e.fout());
        Draw.rect((TextureRegion)ultRegion[(int)(e.rotation + e.fin() * 40.0f) % 40], (float)(e.x + Mathf.randomSeedRange((long)((int)e.y), (float)2.0f)), (float)(e.y + Mathf.randomSeedRange((long)((int)e.x), (float)2.0f)));
        Drawf.light((float)e.x, (float)e.y, (float)(50.0f + Mathf.absin((float)5.0f, (float)5.0f)), (Color)NHColor.lightSkyBack, (float)(0.6f * e.fout()));
    });

    public static void create(float x, float y, Team team) {
        Tile tile = Vars.world.tile(World.toTile((float)x), World.toTile((float)y));
        if (tile != null && tile.build != null && tile.build.team != team) {
            UltFire.create(tile);
        }
    }

    public static void createChance(Position pos, double chance) {
        if (Mathf.chanceDelta((double)chance)) {
            UltFire.create(pos);
        }
    }

    public static void createChance(float x, float y, float range, float chance, Team team) {
        Vars.indexer.eachBlock(null, x, y, range, other -> other.team != team && Mathf.chanceDelta((double)chance), other -> UltFire.create(other.tile));
    }

    public static void createChance(Teamc teamc, float range, float chance) {
        Vars.indexer.eachBlock(null, teamc.x(), teamc.y(), range, other -> other.team != teamc.team() && Mathf.chanceDelta((double)chance), other -> UltFire.create(other.tile));
    }

    public static void create(float x, float y, float range, Team team) {
        Vars.indexer.eachBlock(null, x, y, range, other -> other.team != team, other -> UltFire.create(other.tile));
    }

    public static void create(float x, float y, float range) {
        Vars.indexer.eachBlock(null, x, y, range, other -> true, other -> UltFire.create(other.tile));
    }

    public static void create(Teamc teamc, float range) {
        Vars.indexer.eachBlock(null, teamc.x(), teamc.y(), range, other -> other.team != teamc.team(), other -> UltFire.create(other.tile));
    }

    public static void create(Position position) {
        UltFire.create(World.toTile((float)position.getX()), World.toTile((float)position.getY()));
    }

    public static void create(int x, int y) {
        UltFire.create(Vars.world.tile(x, y));
    }

    public static void create(Tile tile) {
        if (Vars.net.client() || tile == null || !Vars.state.rules.fire) {
            return;
        }
        Fire fire = Fires.get((int)tile.x, (int)tile.y);
        if (!(fire instanceof UltFire)) {
            fire = UltFire.create();
            fire.tile = tile;
            fire.lifetime = 1200.0f;
            fire.set(tile.worldx(), tile.worldy());
            fire.add();
            Fires.register((Fire)fire);
        } else {
            fire.lifetime = 1200.0f;
            fire.time = 0.0f;
        }
    }

    public static void load() {
        for (int i = 0; i < 40; ++i) {
            UltFire.ultRegion[i] = Core.atlas.find(NewHorizon.name("ult-fire-") + i);
        }
    }

    public static UltFire create() {
        return (UltFire)((Object)Pools.obtain(UltFire.class, UltFire::new));
    }

    public void draw() {
        Draw.alpha((float)0.35f);
        Draw.alpha((float)Mathf.clamp((float)(this.warmup / 20.0f)));
        Draw.z((float)110.0f);
        Draw.rect((TextureRegion)ultRegion[Math.min((int)this.animation, ultRegion.length - 1)], (float)(this.x + Mathf.randomSeedRange((long)((int)this.y), (float)2.0f)), (float)(this.y + Mathf.randomSeedRange((long)((int)this.x), (float)2.0f)));
        Draw.reset();
        Drawf.light((float)this.x, (float)this.y, (float)(50.0f + Mathf.absin((float)5.0f, (float)5.0f)), (Color)NHColor.lightSkyBack, (float)(0.6f * Mathf.clamp((float)(this.warmup / 20.0f))));
    }

    public void update() {
        this.animation += Time.delta / 2.25f;
        this.warmup += Time.delta;
        this.animation %= 40.0f;
        if (!Vars.headless) {
            Vars.control.sound.loop(Sounds.loopFire, (Position)this, 0.07f);
        }
        float speedMultiplier = 1.0f + Math.max(Vars.state.envAttrs.get(Attribute.water) * 10.0f, 0.0f);
        this.time = Mathf.clamp((float)(this.time + Time.delta * speedMultiplier), (float)0.0f, (float)this.lifetime);
        if (!Vars.net.client()) {
            if (!(this.time >= this.lifetime) && this.tile != null && !Float.isNaN(this.lifetime)) {
                float f;
                Puddle p;
                Building entity = this.tile.build;
                boolean damage = entity != null;
                float flammability = this.puddleFlammability;
                if (!damage && flammability <= 0.0f) {
                    this.time += Time.delta * 8.0f;
                }
                if (damage) {
                    this.lifetime += Mathf.clamp((float)(flammability / 16.0f), (float)0.1f, (float)0.5f) * Time.delta;
                }
                if (flammability > 1.0f) {
                    float f2;
                    this.spreadTimer += Time.delta * Mathf.clamp((float)(flammability / 5.0f), (float)0.5f, (float)1.0f);
                    if (f2 >= 22.0f) {
                        this.spreadTimer = 0.0f;
                        p = Geometry.d4[Mathf.random((int)3)];
                        Tile other = Vars.world.tile(this.tile.x + p.x, this.tile.y + p.y);
                        UltFire.create(other);
                    }
                }
                if (flammability > 0.0f) {
                    float f3;
                    this.fireballTimer += Time.delta * Mathf.clamp((float)(flammability / 10.0f), (float)0.0f, (float)1.5f);
                    if (f3 >= 40.0f) {
                        this.fireballTimer = 0.0f;
                        NHBullets.ultFireball.createNet(Team.derelict, this.x, this.y, Mathf.random((float)360.0f), 1.0f, 1.0f, 1.0f);
                    }
                }
                this.damageTimer += Time.delta;
                if (f >= 40.0f) {
                    this.damageTimer = 0.0f;
                    p = Puddles.get((Tile)this.tile);
                    if (damage) {
                        entity.damage(10.0f);
                    }
                    Damage.damageUnits(null, (float)this.tile.worldx(), (float)this.tile.worldy(), (float)8.0f, (float)10.0f, unit -> !unit.isFlying() && !unit.isImmune(NHStatusEffects.ultFireBurn), unit -> unit.apply(NHStatusEffects.ultFireBurn, 300.0f));
                }
            } else {
                this.remove();
            }
        }
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public int classId() {
        return EntityRegister.getID(((Object)((Object)this)).getClass());
    }

    public void remove() {
        if (this.added) {
            Groups.all.remove((Entityc)this);
            Groups.sync.remove((Entityc)this);
            Groups.draw.remove((Entityc)this);
            Groups.fire.remove((Entityc)this);
            this.removeEffect();
            if (Vars.net.client()) {
                Vars.netClient.addRemovedEntity(this.id());
            }
            this.added = false;
            Groups.queueFree((Pool.Poolable)this);
            Fires.remove((Tile)this.tile);
        }
    }

    public void removeEffect() {
        remove.at(this.x, this.y, this.animation);
    }
}

