/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.func.Prov;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import mindustry.Vars;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import newhorizon.NewHorizon;
import newhorizon.expand.entities.Carrier;
import newhorizon.expand.entities.Spawner;
import newhorizon.expand.entities.UltFire;
import newhorizon.expand.entities.WarpRift;
import newhorizon.expand.units.AdaptedTimedKillUnit;
import newhorizon.expand.units.EnergyUnit;
import newhorizon.expand.units.EnergyUnitII;
import newhorizon.expand.units.unitEntity.NucleoidEntity;
import newhorizon.expand.units.unitEntity.PesterEntity;
import newhorizon.expand.units.unitEntity.ProbeEntity;

public class EntityRegister {
    private static final ObjectMap<Class<?>, ProvSet> needIdClasses = new ObjectMap();
    private static final ObjectMap<Class<?>, Integer> classIdMap = new ObjectMap();

    private static void registerEntities() {
        EntityRegister.put(EnergyUnit.class, EnergyUnit::new);
        EntityRegister.put(EnergyUnitII.class, EnergyUnitII::new);
        EntityRegister.put(PesterEntity.class, PesterEntity::new);
        EntityRegister.put(AdaptedTimedKillUnit.class, AdaptedTimedKillUnit::new);
        EntityRegister.put(NucleoidEntity.class, NucleoidEntity::new);
        EntityRegister.put(ProbeEntity.class, ProbeEntity::new);
        EntityRegister.put(Spawner.class, Spawner::new);
        EntityRegister.put(Carrier.class, Carrier::new);
        EntityRegister.put(UltFire.class, UltFire::new);
        EntityRegister.put(WarpRift.class, WarpRift::new);
    }

    public static <T extends Entityc> void put(Class<T> c, Prov<T> prov) {
        needIdClasses.put(c, (Object)new ProvSet(prov));
    }

    public static <T extends Entityc> int getID(Class<T> c) {
        return (Integer)classIdMap.get(c, (Object)-1);
    }

    public static void load() {
        Seq sortedKeys = needIdClasses.keys().toSeq().sortComparing(Class::getName);
        for (Class c : sortedKeys) {
            int id = EntityMapping.register((String)c.getName(), ((ProvSet)EntityRegister.needIdClasses.get((Object)c)).prov);
            classIdMap.put((Object)c, (Object)id);
        }
        if (NewHorizon.DEBUGGING || Vars.headless) {
            EntityRegister.logDebugInfo();
        }
    }

    private static void logDebugInfo() {
        Log.info((Object)"||=============================================||");
        classIdMap.each((c, id) -> NewHorizon.debugLog(id + " | " + c.getSimpleName()));
        Log.info((Object)"||=============================================||");
    }

    static {
        EntityRegister.registerEntities();
    }

    public static class ProvSet {
        public final String name;
        public final Prov<?> prov;

        public ProvSet(Prov<?> prov) {
            this.name = prov.get().getClass().toString();
            this.prov = prov;
        }
    }
}

