/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.draw;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.draw.DrawLiquidTile;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.expand.type.Recipe;

public class DrawLiquidAnimatedOffset
extends DrawLiquidTile {
    public float bubbleChance = 0.05f;
    public float bubbleLifetime = 40.0f;
    public float bubbleRadius = 1.5f;
    public float bubbleRise = 6.0f;
    public Color bubbleColor = Color.white;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public boolean glow = false;
    public float glowRadius = 20.0f;
    public float glowAlpha = 0.4f;
    public static final Effect liquidBubble = new Effect(40.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)e.fin());
        Fill.circle((float)e.x, (float)(e.y + e.fin() * 6.0f), (float)(1.5f - e.fin() * 1.2f));
        Draw.color();
    });

    public void draw(Building build) {
        RecipeGenericCrafter.RecipeGenericCrafterBuild crafterBuild;
        Recipe current;
        Liquid liquidToDraw = null;
        float fullness = 0.0f;
        if (build instanceof RecipeGenericCrafter.RecipeGenericCrafterBuild && (current = (crafterBuild = (RecipeGenericCrafter.RecipeGenericCrafterBuild)build).getRecipe()) != null) {
            if (current.inputLiquid != null && current.inputLiquid.size > 0) {
                liquidToDraw = ((LiquidStack)current.inputLiquid.first()).liquid;
            } else if (current.outputLiquid != null && current.outputLiquid.size > 0) {
                liquidToDraw = ((LiquidStack)current.outputLiquid.first()).liquid;
            }
        }
        if (liquidToDraw == null) {
            Liquid liquid = liquidToDraw = this.drawLiquid != null ? this.drawLiquid : build.liquids.current();
        }
        if (liquidToDraw != null && build.block.liquidCapacity > 0.0f) {
            fullness = build.liquids.get(liquidToDraw) / build.block.liquidCapacity;
            if (fullness < 0.0f) {
                fullness = 0.0f;
            }
            if (fullness > 1.0f) {
                fullness = 1.0f;
            }
        } else {
            fullness = 0.001f;
        }
        if (liquidToDraw == null) {
            return;
        }
        Vec2 offset = Tmp.v1.set(this.offsetX, this.offsetY).rotate((float)build.rotation * 90.0f);
        Draw.z((float)29.9f);
        LiquidBlock.drawTiledFrames((int)build.block.size, (float)(build.x + offset.x), (float)(build.y + offset.y), (float)this.padLeft, (float)this.padRight, (float)this.padTop, (float)this.padBottom, (Liquid)liquidToDraw, (float)(fullness * this.alpha));
        if (this.glow) {
            Drawf.light((float)(build.x + offset.x), (float)(build.y + offset.y), (float)this.glowRadius, (Color)liquidToDraw.lightColor, (float)(this.glowAlpha * Mathf.clamp((float)fullness, (float)0.2f, (float)1.0f)));
        }
        if (Mathf.chanceDelta((double)(this.bubbleChance * (0.5f + fullness * 0.5f)))) {
            Color c = this.bubbleColor == Color.white ? liquidToDraw.color : this.bubbleColor;
            float bx = build.x + Mathf.range((float)((float)build.block.size * 2.0f));
            float by = build.y + Mathf.range((float)((float)build.block.size * 2.0f));
            liquidBubble.at(bx, by, 0.0f, c);
        }
    }

    public void load(Block block) {
        super.load(block);
        if (this.padLeft < 0.0f) {
            this.padLeft = 0.0f;
        }
        if (this.padRight < 0.0f) {
            this.padRight = 0.0f;
        }
        if (this.padTop < 0.0f) {
            this.padTop = 0.0f;
        }
        if (this.padBottom < 0.0f) {
            this.padBottom = 0.0f;
        }
    }
}

