/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.components.ui;

import arc.Core;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.Vars;
import newhorizon.NHVars;
import newhorizon.expand.cutscene.components.ui.MarkStyle;
import newhorizon.util.func.MathUtil;
import newhorizon.util.func.NHInterp;

public class MarkBox
extends Table {
    protected static final Vec2 tmpVec = new Vec2();
    protected static final Color tmpColor = new Color();
    protected static int lastID = 0;
    public float radius = 24.0f;
    public Color markColor = Color.white;
    public Interp popUpInterp = NHInterp.bounce5Out;
    public Position markPoint;
    public MarkStyle style = MarkStyle.defaultStyle;
    public int id = lastID++;
    public float lifetime = -1.0f;
    protected float totalProgress = 0.0f;

    public MarkBox() {
        this.actions(new Action[]{Actions.alpha((float)1.0f, (float)0.45f, (Interp)this.popUpInterp)});
        this.touchable = Touchable.childrenOnly;
        this.fillParent = true;
        this.update(() -> {
            if (!Vars.state.isPaused()) {
                this.totalProgress += Time.delta;
            }
            if (Vars.state.isMenu()) {
                this.remove();
            }
        });
        this.color.a = 0.0f;
    }

    public void addSelf() {
        NHVars.cutsceneUI.root.addChild((Element)this);
        this.setZIndex(0);
    }

    public MarkBox init(float radius, Color markColor, Position markPoint, MarkStyle style) {
        this.radius = radius;
        this.markColor = markColor;
        this.markPoint = markPoint;
        this.style = style;
        return this;
    }

    public void setLife(float lifetime) {
        this.lifetime = lifetime;
    }

    public void act(float delta) {
        super.act(delta);
        if (this.totalProgress > this.lifetime) {
            this.removeFromHUD();
        }
    }

    public void removeFromHUD() {
        this.actions(new Action[]{Actions.fadeOut((float)0.5f), Actions.remove()});
    }

    public void draw() {
        boolean outer;
        super.draw();
        if (Vars.headless) {
            return;
        }
        Vec2 screenVec = tmpVec.set(Core.camera.project(this.markPoint.getX(), this.markPoint.getY()));
        Vec2 originVec = screenVec.cpy();
        boolean bl = outer = screenVec.x < this.width * 0.05f || screenVec.y < this.height * 0.05f || screenVec.x > this.width * 0.95f || screenVec.y > this.height * 0.95f;
        if (outer) {
            screenVec.x = Mathf.clamp((float)screenVec.x, (float)(this.width * 0.05f), (float)(this.width * 0.95f));
            screenVec.y = Mathf.clamp((float)screenVec.y, (float)(this.height * 0.05f), (float)(this.height * 0.95f));
        }
        tmpColor.set(this.markColor).lerp(Color.white, MathUtil.timeValue(0.0f, 0.2f, 1.0f)).a(this.color.a);
        this.style.drawer.draw(this.id, this.totalProgress / this.lifetime, this.radius, screenVec, originVec, tmpColor, outer);
    }
}

