/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.components;

import arc.struct.Seq;
import arc.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.UnitType;
import mindustry.world.blocks.logic.MemoryBlock;
import newhorizon.expand.cutscene.action.CameraControlAction;
import newhorizon.expand.cutscene.action.CameraResetAction;
import newhorizon.expand.cutscene.action.CameraZoomAction;
import newhorizon.expand.cutscene.action.CurtainDrawAction;
import newhorizon.expand.cutscene.action.CurtainFadeInAction;
import newhorizon.expand.cutscene.action.CurtainFadeOutAction;
import newhorizon.expand.cutscene.action.CurtainRaiseAction;
import newhorizon.expand.cutscene.action.InfoFadeInAction;
import newhorizon.expand.cutscene.action.InfoFadeOutAction;
import newhorizon.expand.cutscene.action.InfoTextAction;
import newhorizon.expand.cutscene.action.InputLockAction;
import newhorizon.expand.cutscene.action.InputUnlockAction;
import newhorizon.expand.cutscene.action.JumpInAction;
import newhorizon.expand.cutscene.action.MarkWorldAction;
import newhorizon.expand.cutscene.action.NullAction;
import newhorizon.expand.cutscene.action.RaidAction;
import newhorizon.expand.cutscene.action.SignalCutInAction;
import newhorizon.expand.cutscene.action.SignalCutOutAction;
import newhorizon.expand.cutscene.action.SignalTextAction;
import newhorizon.expand.cutscene.action.UIHideAction;
import newhorizon.expand.cutscene.action.UIShowAction;
import newhorizon.expand.cutscene.action.WaitAction;
import newhorizon.expand.cutscene.action.WarningIconAction;
import newhorizon.expand.cutscene.action.WarningSoundAction;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionBus;

public class ActionControl {
    public static ActionBus parseCode(String code, Building source) {
        ActionBus bus = new ActionBus();
        ActionControl.parseLine(code, source).each(line -> bus.add(ActionControl.parseAction(line, source)));
        return bus;
    }

    public static Seq<String> parseLine(String code, Building source) {
        Object[] lines = code.split("\\R");
        return Seq.with((Object[])lines);
    }

    public static Seq<String> parseToken(String line, Building source) {
        Seq result = new Seq();
        Matcher matcher = Pattern.compile("<([^>]*)>|\\S+").matcher(line);
        while (matcher.find()) {
            result.add((Object)(matcher.group(1) != null ? matcher.group(1) : matcher.group()));
        }
        return result;
    }

    public static String parseString(String token, Building source) {
        return ActionControl.parseString(token);
    }

    public static String parseString(String token) {
        return token.replace("[n]", "\n");
    }

    public static float parseFloat(String token, Building source) {
        if (token.startsWith("@") && source != null && Vars.world.build((int)source.tileX(), (int)(source.tileY() - 1)).block instanceof MemoryBlock) {
            MemoryBlock.MemoryBuild memory = (MemoryBlock.MemoryBuild)Vars.world.build(source.tileX(), source.tileY() - 1);
            return (float)memory.memory[Integer.parseInt(token.replace("@", ""))];
        }
        return Float.parseFloat(token);
    }

    public static Team parseTeam(String token) {
        switch (token) {
            case "derelict": {
                return Team.derelict;
            }
            case "sharded": {
                return Team.sharded;
            }
            case "crux": {
                return Team.crux;
            }
            case "malis": {
                return Team.malis;
            }
            case "green": {
                return Team.green;
            }
            case "blue": {
                return Team.blue;
            }
            case "neoplastic": {
                return Team.neoplastic;
            }
        }
        try {
            int teamID = Integer.parseInt(token);
            return Team.get((int)teamID);
        }
        catch (NumberFormatException e) {
            Log.err((Throwable)e);
            return Team.derelict;
        }
    }

    public static UnitType parseUnitType(String token) {
        if (Vars.content.unit(token) != null) {
            return Vars.content.unit(token);
        }
        try {
            int id = Integer.parseInt(token);
            if (Vars.content.unit(id) != null) {
                return Vars.content.unit(id);
            }
        }
        catch (NumberFormatException e) {
            Log.err((Throwable)e);
        }
        return UnitTypes.alpha;
    }

    public static Action parseAction(String tokens, Building source) {
        Seq<String> tokensArray = ActionControl.parseToken(tokens, source);
        String actionName = (String)tokensArray.remove(0);
        String[] args = (String[])tokensArray.toArray(String.class);
        try {
            Action action;
            switch (actionName) {
                case "camera_control": {
                    action = new CameraControlAction(args);
                    break;
                }
                case "camera_reset": {
                    action = new CameraResetAction(args);
                    break;
                }
                case "camera_zoom": {
                    action = new CameraZoomAction(args);
                    break;
                }
                case "curtain_draw": {
                    action = new CurtainDrawAction();
                    break;
                }
                case "curtain_raise": {
                    action = new CurtainRaiseAction();
                    break;
                }
                case "curtain_fade_in": {
                    action = new CurtainFadeInAction();
                    break;
                }
                case "curtain_fade_out": {
                    action = new CurtainFadeOutAction();
                    break;
                }
                case "info_fade_in": {
                    action = new InfoFadeInAction();
                    break;
                }
                case "info_fade_out": {
                    action = new InfoFadeOutAction();
                    break;
                }
                case "info_text": {
                    action = new InfoTextAction(args);
                    break;
                }
                case "input_lock": {
                    action = new InputLockAction();
                    break;
                }
                case "input_unlock": {
                    action = new InputUnlockAction();
                    break;
                }
                case "jump_in": {
                    action = new JumpInAction(args, source);
                    break;
                }
                case "mark_world": {
                    action = new MarkWorldAction(args, source);
                    break;
                }
                case "raid": {
                    action = new RaidAction(args, source);
                    break;
                }
                case "signal_cut_in": {
                    action = new SignalCutInAction();
                    break;
                }
                case "signal_cut_out": {
                    action = new SignalCutOutAction();
                    break;
                }
                case "signal_text": {
                    action = new SignalTextAction(args);
                    break;
                }
                case "ui_hide": {
                    action = new UIHideAction();
                    break;
                }
                case "ui_show": {
                    action = new UIShowAction();
                    break;
                }
                case "wait": {
                    action = new WaitAction(args);
                    break;
                }
                case "warning_icon": {
                    action = new WarningIconAction(args);
                    break;
                }
                case "warning_sound": {
                    action = new WarningSoundAction(args);
                    break;
                }
                default: {
                    action = new NullAction();
                }
            }
            return action;
        }
        catch (Exception e) {
            Log.err((Throwable)e);
            Vars.ui.announce("Failed to parse action: " + tokens);
            return new NullAction();
        }
    }
}

