/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.action;

import arc.audio.Sound;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import newhorizon.content.NHSounds;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionControl;

public class WarningSoundAction
extends Action {
    public int allySound;
    public int enemySound;
    public Team team;

    public WarningSoundAction(int allySound, int enemySound, Team team) {
        super(0.0f);
        this.allySound = allySound;
        this.enemySound = enemySound;
        this.team = team;
    }

    public WarningSoundAction(String[] args) {
        super(0.0f);
        this.allySound = Integer.parseInt(args[0]);
        this.enemySound = Integer.parseInt(args[1]);
        this.team = ActionControl.parseTeam(args[2]);
    }

    public Sound warningSound(int soundID) {
        Sound sound;
        switch (soundID) {
            case 0: {
                sound = NHSounds.alert2;
                break;
            }
            case 1: {
                sound = NHSounds.alarm;
                break;
            }
            case 2: {
                sound = Sounds.uiUnlock;
                break;
            }
            case 3: {
                sound = Sounds.wind3;
                break;
            }
            default: {
                sound = Sounds.none;
            }
        }
        return sound;
    }

    @Override
    public void begin() {
        if (Vars.headless) {
            return;
        }
        if (Vars.player.team() == this.team) {
            this.warningSound(this.allySound).play();
        } else {
            this.warningSound(this.enemySound).play();
        }
    }
}

