/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.action;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.UnitType;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionControl;
import newhorizon.expand.entities.Spawner;

public class JumpInAction
extends Action {
    public UnitType unitType;
    public Team team;
    public float worldX = 0.0f;
    public float worldY = 0.0f;
    public float angle = 0.0f;
    public float delay = 5.0f;
    public float inaccuracyRadius = 0.0f;

    public JumpInAction(float duration) {
        super(0.0f);
    }

    public JumpInAction(String[] tokens) {
        super(0.0f);
        this.unitType = ActionControl.parseUnitType(tokens[0]);
        this.team = ActionControl.parseTeam(tokens[1]);
        this.worldX = Float.parseFloat(tokens[2]);
        this.worldY = Float.parseFloat(tokens[3]);
        this.angle = Float.parseFloat(tokens[4]);
        this.delay = Float.parseFloat(tokens[5]) * 60.0f;
        this.inaccuracyRadius = Float.parseFloat(tokens[6]);
    }

    public JumpInAction(String[] tokens, Building source) {
        super(0.0f);
        this.unitType = ActionControl.parseUnitType(tokens[0]);
        this.team = ActionControl.parseTeam(tokens[1]);
        this.worldX = ActionControl.parseFloat(tokens[2], source);
        this.worldY = ActionControl.parseFloat(tokens[3], source);
        this.angle = ActionControl.parseFloat(tokens[4], source);
        this.delay = ActionControl.parseFloat(tokens[5], source) * 60.0f;
        this.inaccuracyRadius = ActionControl.parseFloat(tokens[6], source);
    }

    @Override
    public void end() {
        Spawner spawner = new Spawner();
        Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)this.inaccuracyRadius));
        spawner.init(this.unitType, this.team, (Position)new Vec2(this.worldX + Tmp.v1.x, this.worldY + Tmp.v1.y), this.angle, this.delay);
        spawner.add();
    }
}

