/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.adapt;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vector;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.gen.Bullet;
import newhorizon.content.NHColor;
import newhorizon.expand.bullets.adapt.AdaptBulletType;

public class TrajectoryBulletType
extends AdaptBulletType {
    public static final Rand rand = new Rand();
    public Interp expIn = new Interp.ExpIn(2.0f, 2.0f);
    public float pointEffectSpace = 20.0f;
    public float length = 300.0f;
    public Effect trajectoryEffect = new Effect(15.0f, e -> {
        Object patt804$temp = e.data;
        if (patt804$temp instanceof Float) {
            Float len = (Float)patt804$temp;
            rand.setSeed((long)e.id);
            Tmp.v3.setZero().trns(e.rotation, len.floatValue()).add(e.x, e.y);
            Tmp.v1.setZero().trns(e.rotation + (float)rand.random(-25, 25), len.floatValue() * rand.random(0.15f, 0.25f)).add(e.x, e.y);
            Draw.color((Color)e.color);
            Lines.stroke((float)1.5f);
            Tmp.v2.set(Tmp.v3).sub(e.x, e.y).nor().rotate90(1).scl(Mathf.randomSeedRange((long)e.id, (float)1.0f) * 50.0f);
            Tmp.bz2.set((Vector)Tmp.v3, (Vector)Tmp.v2.add(e.x, e.y), (Vector)Tmp.v1.set(e.x, e.y));
            Tmp.bz2.valueAt((Vector)Tmp.v4, e.fout(this.expIn));
            Tmp.bz2.valueAt((Vector)Tmp.v5, e.fout());
            Lines.line((float)Tmp.v4.x, (float)Tmp.v4.y, (float)Tmp.v5.x, (float)Tmp.v5.y);
        }
    });

    public TrajectoryBulletType() {
        this.lifetime = 1.0f;
        this.delayFrags = true;
        this.keepVelocity = false;
        this.hitEffect = Fx.none;
        this.despawnEffect = Fx.none;
    }

    @Override
    protected float calculateRange() {
        return this.length;
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        float hitLength = Math.min(this.length, Mathf.dst((float)b.x, (float)b.y, (float)b.aimX, (float)b.aimY));
        float maxLength = Damage.findPierceLength((Bullet)b, (int)1, (boolean)true, (float)hitLength);
        for (int i = 0; i < 2; ++i) {
            this.trajectoryEffect.at(b.x, b.y, b.rotation(), NHColor.lightSky, (Object)Float.valueOf(maxLength));
        }
        b.remove();
        b.vel.setZero();
    }
}

