/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Trail;
import mindustry.type.StatusEffect;
import newhorizon.expand.bullets.AccelBulletType;
import newhorizon.expand.entities.UltFire;

public class TextureMissileType
extends AccelBulletType {
    public TextureMissileType(float damage, String bulletSprite) {
        super(damage, bulletSprite);
        this.absorbable = false;
    }

    public void load() {
        this.backRegion = this.frontRegion = Core.atlas.find(this.sprite + "-processed");
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            b.trail.draw(this.trailColor, this.trailWidth);
            b.trail.drawCap(this.trailColor, this.trailWidth);
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0 && b.time > 5.0f) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            b.trail.update(b.x, b.y, this.trailInterp.apply(b.fin()));
        }
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        float z = Draw.z();
        Draw.z((float)89.8f);
        Tmp.v1.trns(b.rotation(), this.height / 1.75f).add((Position)b);
        Drawf.shadow((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(this.height / 1.25f));
        Draw.rect((TextureRegion)this.backRegion, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)(b.rotation() - 90.0f));
        Draw.z((float)z);
    }

    public void hit(Bullet b, float x, float y) {
        this.hitEffect.at(x, y, b.rotation(), this.hitColor);
        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
            Damage.damage((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (float)(this.splashDamage * b.damageMultiplier()), (boolean)this.collidesAir, (boolean)this.collidesGround);
            if (this.status != StatusEffects.none) {
                Damage.status((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (StatusEffect)this.status, (float)this.statusDuration, (boolean)this.collidesAir, (boolean)this.collidesGround);
            }
            if (this.makeFire) {
                UltFire.createChance(x, y, this.splashDamageRadius, 0.35f, b.team);
            }
        }
        for (int i = 0; i < this.lightning; ++i) {
            Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
        }
    }

    public void hitTile(Bullet b, Building build, float initialHealth, boolean direct) {
        UltFire.create(build.tile);
        if (build.team != b.team && direct) {
            this.hit(b);
        }
    }
}

