/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class StrafeLaser
extends BulletType {
    public float strafeAngle = 70.0f;
    public float width = 18.0f;
    public float computeTick = 5.0f;
    public float fallScl = 0.125f;
    public boolean dataRot = true;
    public float lerpWhiteSine = 0.3f;
    public float sideTriRootLength = 20.0f;
    public float sideTriLength = 50.0f;
    public float sideTriWidth = 6.0f;
    public float sideLengthDifference = 10.0f;

    public StrafeLaser(float damage) {
        this.damage = damage;
        this.lifetime = 160.0f;
        this.speed = 0.0f;
        this.hitEffect = new Effect(20.0f, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.6f + 0.1f));
            Lines.stroke((float)(e.fout() * 2.0f));
            Angles.randLenVectors((long)e.id, (int)3, (float)(e.finpow() * 48.0f), (float)e.rotation, (float)35.0f, (x, y) -> {
                float ang = Mathf.angle((float)x, (float)y);
                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 8.0f + 2.0f));
            });
        });
        this.shootEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.maxRange = 600.0f;
        this.hitShake = 4.0f;
        this.reflectable = false;
        this.despawnEffect = Fx.none;
        this.impact = true;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
        this.hitColor = null;
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.maxRange * 2.0f);
    }

    public void init(Bullet b) {
        super.init(b);
        if (this.dataRot && b.owner instanceof Unit) {
            Unit u = (Unit)b.owner;
            b.fdata = b.angleTo(u.aimX, u.aimY());
        }
    }

    public float getRotation(Bullet b) {
        return -this.strafeAngle / 2.0f + this.strafeAngle * b.fin((Interp)Interp.pow3);
    }

    public float estimateDPS() {
        return this.continuousDamage();
    }

    public Color getColor(Bullet b) {
        return this.hitColor == null ? b.team.color : this.hitColor;
    }

    public void draw(Bullet b) {
        float rotation = this.dataRot ? b.fdata : b.rotation() + this.getRotation(b);
        float fout = b.fout(this.fallScl) * Mathf.curve((float)b.fin(), (float)0.0f, (float)this.fallScl);
        float maxRange = this.maxRange * fout;
        float realLength = NHFunc.findLaserLength(b, rotation, maxRange);
        Tmp.v1.trns(rotation, realLength);
        Tmp.v2.trns(rotation, 0.0f, this.width / 2.0f * fout);
        Tmp.v3.setZero();
        if (realLength < maxRange) {
            Tmp.v3.set(Tmp.v2).scl((maxRange - realLength) / maxRange);
        }
        if (this.lerpWhiteSine != 0.0f) {
            Tmp.c1.set(this.getColor(b)).lerp(Color.white, Mathf.absin((float)4.0f, (float)this.lerpWhiteSine));
        } else {
            Tmp.c1.set(this.getColor(b));
        }
        Draw.z((float)100.01f);
        Draw.color((Color)Tmp.c1);
        Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.225f * fout));
        for (int i : Mathf.signs) {
            DrawFunc.tri(b.x, b.y, this.sideTriWidth * fout, this.sideTriRootLength - this.sideLengthDifference + (this.sideTriLength - this.sideLengthDifference) * fout, Time.time * 1.5f + (float)(90 * i));
            DrawFunc.tri(b.x, b.y, this.sideTriWidth * fout, this.sideTriRootLength + this.sideTriLength * fout, Time.time * -1.0f + (float)(90 * i));
        }
        Draw.color((Color)Tmp.c1, (Color)Color.white, (float)0.55f);
        Fill.circle((float)b.x, (float)b.y, (float)(this.width / 1.85f * fout));
        Draw.color((Color)Color.white);
        Fill.circle((float)b.x, (float)b.y, (float)(this.width / 2.125f * fout));
        Draw.z((float)100.0f);
        Draw.reset();
        Tmp.v2.scl(1.1f);
        Tmp.v3.scl(1.1f);
        Draw.alpha((float)0.5f);
        Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + Tmp.v1.x + Tmp.v3.x), (float)(b.y + Tmp.v1.y + Tmp.v3.y), (float)(b.x + Tmp.v1.x - Tmp.v3.x), (float)(b.y + Tmp.v1.y - Tmp.v3.y));
        if (realLength < maxRange) {
            Fill.circle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Tmp.v3.len());
        }
        Draw.color((Color)Tmp.c1);
        Tmp.v2.scl(0.85f);
        Tmp.v3.scl(0.85f);
        Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + Tmp.v1.x + Tmp.v3.x), (float)(b.y + Tmp.v1.y + Tmp.v3.y), (float)(b.x + Tmp.v1.x - Tmp.v3.x), (float)(b.y + Tmp.v1.y - Tmp.v3.y));
        if (realLength < maxRange) {
            Fill.circle((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Tmp.v3.len());
        }
        Draw.alpha((float)1.0f);
        Draw.color((Color)Tmp.c2.set(Tmp.c1).lerp(Color.white, 0.3f));
        Tmp.v2.scl(0.5f);
        Fill.quad((float)(b.x - Tmp.v2.x), (float)(b.y - Tmp.v2.y), (float)(b.x + Tmp.v2.x), (float)(b.y + Tmp.v2.y), (float)(b.x + (Tmp.v1.x + Tmp.v3.x) / 3.0f), (float)(b.y + (Tmp.v1.y + Tmp.v3.y) / 3.0f), (float)(b.x + (Tmp.v1.x - Tmp.v3.x) / 3.0f), (float)(b.y + (Tmp.v1.y - Tmp.v3.y) / 3.0f));
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)(this.width * 1.5f), (Color)this.getColor(b), (float)0.7f);
        Draw.reset();
    }

    public float continuousDamage() {
        return this.damage / this.computeTick * 60.0f;
    }

    public void update(Bullet b) {
        if (b.timer.get(1, this.computeTick)) {
            float maxRange = this.maxRange * b.fout(this.fallScl) * Mathf.curve((float)b.fin(), (float)0.0f, (float)this.fallScl);
            NHFunc.collideLine(b, b.team, Fx.none, b.x, b.y, this.dataRot ? b.fdata : b.rotation() + this.getRotation(b), maxRange, true, true);
        }
        if (this.dataRot && b.owner instanceof Unit) {
            Unit u = (Unit)b.owner;
            if (Vars.net.active()) {
                if (u.isPlayer()) {
                    Player player = (Player)u.controller();
                    b.fdata = Angles.moveToward((float)b.fdata, (float)b.angleTo(player.mouseX, player.mouseY), (float)1.0f);
                } else {
                    Teamc target = Units.bestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.range, un -> un.type.canAttack, Building::isValid, (Units.Sortf)UnitSorts.strongest);
                    if (target != null) {
                        b.fdata = Angles.moveToward((float)b.fdata, (float)b.angleTo((Position)target), (float)1.0f);
                    }
                }
            } else {
                b.fdata = Angles.moveToward((float)b.fdata, (float)b.angleTo(u.aimX, u.aimY), (float)1.0f);
            }
        }
        if (this.hitShake > 0.0f) {
            Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        }
    }

    public void hit(Bullet b, float x, float y) {
        this.hitEffect.at(x, y, b.rotation() + this.getRotation(b), this.getColor(b));
    }
}

