/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import newhorizon.content.NHFx;
import newhorizon.expand.bullets.EffectBulletType;

public class ShieldBreakerType
extends BasicBulletType {
    protected static BulletType breakType = new EffectBulletType(3.0f){
        {
            this.absorbable = true;
            this.collides = false;
            this.lifetime = 8.0f;
            this.drawSize = 0.0f;
            this.damage = 1.0f;
        }

        public void despawned(Bullet b) {
            if (b.absorbed && b.data instanceof Color) {
                NHFx.shuttle.at(b.x, b.y, Mathf.random((float)360.0f), (Color)b.data, (Object)Float.valueOf(b.damage / 8.0f / 2.0f));
                Effect.shake((float)(b.damage / 100.0f), (float)(b.damage / 100.0f), (Position)b);
                Sounds.beamPlasma.at((Position)b);
            }
        }
    };
    public float fragSpawnSpacing = 5.0f;
    public float maxShieldDamage;

    public ShieldBreakerType(float speed, float damage, String bulletSprite, float shieldDamage) {
        super(speed, damage, bulletSprite);
        this.splashDamageRadius = -1.0f;
        this.splashDamage = -1.0f;
        this.maxShieldDamage = shieldDamage;
        this.absorbable = false;
    }

    public ShieldBreakerType(float speed, float damage, float shieldDamage) {
        this(speed, damage, "bullet", shieldDamage);
    }

    public ShieldBreakerType() {
        this(1.0f, 1.0f, "bullet", 500.0f);
    }

    public void init() {
        super.init();
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.timer(5, this.fragSpawnSpacing)) {
            breakType.create((Entityc)b, b.team, b.x, b.y, 0.0f, this.maxShieldDamage, 0.0f, 1.0f, (Object)this.backColor);
        }
    }
}

