/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import newhorizon.NHSetting;
import newhorizon.content.NHFx;
import newhorizon.util.feature.PosLightning;

public class LightningLinkerBulletType
extends BasicBulletType {
    public static final Vec2 randVec = new Vec2();
    public float hitSpacing = 10.0f;
    public float size = 30.0f;
    public float linkRange = 240.0f;
    public float boltWidth = 2.5f;
    public float randomGenerateRange = -1.0f;
    public float randomGenerateChance = 0.03f;
    public float randomLightningChance = 0.1f;
    public int randomLightningNum = 4;
    public Sound randomGenerateSound = Sounds.beamPlasma;
    public Cons<Position> hitModifier = p -> {};
    public float range = -1.0f;
    public int maxHit = 20;
    public int boltNum = 1;
    public int effectLingtning = 2;
    public float effectLightningChance = 0.35f;
    public float effectLightningLength = -1.0f;
    public float effectLightningLengthRand = -1.0f;
    public float trueHitChance = 0.66f;
    public boolean drawCircle = true;
    public Effect slopeEffect;
    public Effect liHitEffect;
    public Effect spreadEffect;

    public LightningLinkerBulletType(float speed, float damage) {
        super(speed, damage);
        this.collidesAir = true;
        this.collidesGround = true;
        this.collides = false;
        this.despawnHit = true;
        this.scaleLife = true;
        this.hitShake = 3.0f;
        this.hitSound = Sounds.explosion;
        this.shootEffect = Fx.shootBig;
        this.lightning = 4;
        this.lightningLength = 3;
        this.lightningLengthRand = 12;
        this.lightningCone = 360.0f;
        this.trailWidth = -1.0f;
        this.liHitEffect = NHFx.lightningHitSmall;
    }

    public LightningLinkerBulletType() {
        this(1.0f, 1.0f);
    }

    public boolean testCollision(Bullet bullet, Building tile) {
        return super.testCollision(bullet, tile);
    }

    public float estimateDPS() {
        return this.lightningDamage * (float)this.maxHit * 0.75f * 60.0f / this.hitSpacing;
    }

    public void init() {
        super.init();
        if (this.slopeEffect == null) {
            this.slopeEffect = new Effect(25.0f, e -> {
                if (!(e.data instanceof Integer)) {
                    return;
                }
                int i = (Integer)e.data();
                Draw.color((Color)this.backColor);
                Angles.randLenVectors((long)e.id, (int)((int)(this.size / 8.0f)), (float)(this.size / 4.0f + this.size * 2.0f * e.fin()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * this.size / 1.65f)));
                Lines.stroke((float)((i < 0 ? e.fin() : e.fout()) * 3.0f));
                Lines.circle((float)e.x, (float)e.y, (float)((i > 0 ? e.fin() : e.fout()) * this.size * 1.1f));
            });
        }
        if (this.spreadEffect == null) {
            this.spreadEffect = new Effect(32.0f, e -> Angles.randLenVectors((long)e.id, (int)2, (float)(6.0f + 45.0f * e.fin()), (x, y) -> {
                Draw.color((Color)this.backColor);
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * this.size / 2.0f));
                Draw.color((Color)this.frontColor);
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * (this.size / 3.0f - 1.0f)));
            })).layer(110.00001f);
        }
        if (this.trailWidth < 0.0f) {
            this.trailWidth = this.size * 0.75f;
        }
        if (this.trailLength < 0) {
            this.trailLength = 12;
        }
        this.drawSize = Math.max(this.drawSize, this.size * 2.0f);
        if (this.effectLightningLength < 0.0f) {
            this.effectLightningLength = this.size * 1.5f;
        }
        if (this.effectLightningLengthRand < 0.0f) {
            this.effectLightningLengthRand = this.size * 2.0f;
        }
    }

    public void update(Bullet b) {
        super.update(b);
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (b.timer(4, this.hitSpacing)) {
            for (int i : Mathf.signs) {
                this.slopeEffect.at(b.x + Mathf.range((float)(this.size / 4.0f)), b.y + Mathf.range((float)(this.size / 4.0f)), b.rotation(), (Object)i);
            }
            this.spreadEffect.at((Position)b);
            PosLightning.setHitChance(this.trueHitChance);
            PosLightning.createRange(b, this.collidesAir, this.collidesGround, (Position)b, b.team, this.linkRange, this.maxHit, this.backColor, Mathf.chanceDelta((double)this.randomLightningChance), this.lightningDamage, this.lightningLength, 2.5f, this.boltNum, (Cons<Position>)((Cons)p -> this.liHitEffect.at(p.getX(), p.getY(), this.hitColor)));
            PosLightning.setHitChanceDef();
        }
        if (this.randomGenerateRange > 0.0f && Mathf.chance((double)(Time.delta * this.randomGenerateChance)) && b.lifetime - b.time > PosLightning.lifetime) {
            PosLightning.createRandomRange(b, b.team, (Position)b, this.randomGenerateRange, this.backColor, Mathf.chanceDelta((double)this.randomLightningChance), 0.0f, 0, this.boltWidth, this.boltNum, this.randomLightningNum, (Cons<Position>)((Cons)hitPos -> {
                this.randomGenerateSound.at(hitPos, Mathf.random((float)0.9f, (float)1.1f));
                Damage.damage((Team)b.team, (float)hitPos.getX(), (float)hitPos.getY(), (float)(this.splashDamageRadius / 8.0f), (float)(this.splashDamage * b.damageMultiplier() / 8.0f), (boolean)this.collidesAir, (boolean)this.collidesGround);
                NHFx.lightningHitLarge.at(hitPos.getX(), hitPos.getY(), this.lightningColor);
                this.hitModifier.get(hitPos);
            }));
        }
        if (Mathf.chanceDelta((double)this.effectLightningChance) && b.lifetime - b.time > Fx.chainLightning.lifetime && NHSetting.enableDetails()) {
            for (int i = 0; i < this.effectLingtning; ++i) {
                Vec2 v = randVec.rnd(this.effectLightningLength + Mathf.random((float)this.effectLightningLengthRand)).add((Position)b).add(Tmp.v1.set(b.vel).scl(Fx.chainLightning.lifetime / 2.0f));
                Fx.chainLightning.at(b.x, b.y, 12.0f, this.backColor, (Object)v.cpy());
                NHFx.lightningHitSmall.at(v.x, v.y, 20.0f, this.backColor);
            }
        }
    }

    public void init(Bullet b) {
        super.init(b);
        b.vel.scl(1.0f + b.lifetime * this.drag * 28.0f / this.lifetime);
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        if (this.drawCircle) {
            Draw.color((Color)this.backColor);
            Fill.circle((float)b.x, (float)b.y, (float)this.size);
            Draw.color((Color)this.frontColor);
            Fill.circle((float)b.x, (float)b.y, (float)(this.size / 7.0f + this.size / 3.0f * Mathf.curve((float)b.fout(), (float)0.1f, (float)0.35f)));
        } else {
            super.draw(b);
        }
        Drawf.light((float)b.x, (float)b.y, (float)(this.size * 1.85f), (Color)this.backColor, (float)0.7f);
    }

    public void despawned(Bullet b) {
        PosLightning.createRandomRange(b, b.team, (Position)b, this.randomGenerateRange, this.backColor, Mathf.chanceDelta((double)this.randomLightningChance), 0.0f, 0, this.boltWidth, this.boltNum, this.randomLightningNum, (Cons<Position>)((Cons)hitPos -> {
            Damage.damage((Team)b.team, (float)hitPos.getX(), (float)hitPos.getY(), (float)this.splashDamageRadius, (float)(this.splashDamage * b.damageMultiplier()), (boolean)this.collidesAir, (boolean)this.collidesGround);
            NHFx.lightningHitLarge.at(hitPos.getX(), hitPos.getY(), this.lightningColor);
            this.liHitEffect.at(hitPos);
            for (int j = 0; j < this.lightning; ++j) {
                Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
            }
            this.hitSound.at(hitPos, Mathf.random((float)0.9f, (float)1.1f));
            this.hitModifier.get(hitPos);
        }));
        super.despawned(b);
    }
}

