/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;

public class HelixTrailBulletType
extends BasicBulletType {
    public int sideTrailNum = 3;
    public int sideTrailLength = 30;
    public float sideTrailWidth = 3.0f;
    public float sideTrailSpace = 15.0f;
    public float sideTrailTime = 4.0f;

    public HelixTrailBulletType(float speed, float damage) {
        super(4.0f, damage);
        this.trailEffect = Fx.none;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.none;
        this.lifetime = 240.0f;
        this.trailColor = Pal.techBlue;
    }

    public HelixTrailBulletType() {
        super(6.0f, 1.0f);
        this.trailEffect = Fx.none;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.none;
        this.lifetime = 120.0f;
        this.trailColor = Pal.techBlue;
    }

    public void init(Bullet b) {
        Trail[] sideTrails = new Trail[this.sideTrailNum];
        for (int i = 0; i < this.sideTrailNum; ++i) {
            sideTrails[i] = new Trail(this.sideTrailLength);
        }
        b.data = sideTrails;
    }

    public void removed(Bullet b) {
        super.removed(b);
        if (!(b.data() instanceof Trail[])) {
            return;
        }
        Trail[] sideTrails = (Trail[])b.data;
        if (this.sideTrailLength > 0) {
            for (Trail trail : sideTrails) {
                if (trail == null || trail.size() <= 0) continue;
                Fx.trailFade.at(b.x, b.y, this.sideTrailWidth, this.trailColor, (Object)trail.copy());
            }
        }
    }

    public void draw(Bullet b) {
        Draw.color((Color)Pal.techBlue);
        Fill.circle((float)b.x, (float)b.y, (float)(this.sideTrailSpace + 2.0f));
        Draw.color((Color)Color.black);
        Fill.circle((float)b.x, (float)b.y, (float)(this.sideTrailSpace - 4.0f));
        Draw.color((Color)Pal.techBlue);
        Fill.circle((float)b.x, (float)b.y, (float)(this.sideTrailSpace - 8.0f));
        this.drawSideTrail(b);
    }

    public void update(Bullet b) {
        super.update(b);
        this.updateSideTrail(b);
    }

    public void drawSideTrail(Bullet b) {
        if (!(b.data() instanceof Trail[])) {
            return;
        }
        Trail[] sideTrails = (Trail[])b.data;
        float z = Draw.z();
        Draw.z((float)(z - 1.0E-4f));
        for (Trail trail : sideTrails) {
            if (this.sideTrailLength <= 0 || trail == null) continue;
            trail.draw(this.trailColor, this.sideTrailWidth);
        }
        Draw.z((float)z);
    }

    public void updateSideTrail(Bullet b) {
        if (!(b.data() instanceof Trail[])) {
            return;
        }
        Trail[] sideTrails = (Trail[])b.data;
        if (!Vars.headless && this.sideTrailLength > 0) {
            for (int i = 0; i < this.sideTrailNum; ++i) {
                if (sideTrails[i] == null) {
                    sideTrails[i] = new Trail(this.sideTrailLength);
                }
                sideTrails[i].length = this.sideTrailLength;
                sideTrails[i].update(b.x + Mathf.sinDeg((float)(Time.time * this.sideTrailTime + (float)i * (360.0f / (float)this.sideTrailNum))) * this.sideTrailSpace, b.y + Mathf.cosDeg((float)(Time.time * this.sideTrailTime + (float)i * (360.0f / (float)this.sideTrailNum))) * this.sideTrailSpace, this.trailInterp.apply(b.fin()));
            }
        }
    }
}

