/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.ContinuousBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.type.StatusEffect;
import newhorizon.content.NHStatusEffects;
import newhorizon.util.feature.PosLightning;

public class DOTBulletType
extends ContinuousBulletType {
    public float DOTRadius = 12.0f;
    public float DOTDamage = 100.0f;
    public float radIncrease = 0.25f;
    public StatusEffect effect = NHStatusEffects.emp2;
    public Effect fx = Fx.none;

    public DOTBulletType() {
        this.speed = 0.0f;
        this.lifetime = 120.0f;
        this.collides = false;
        this.hittable = false;
        this.absorbable = false;
        this.damage = this.DOTDamage;
        this.buildingDamageMultiplier = 0.0f;
        this.despawnEffect = this.hitEffect = Fx.none;
    }

    public void draw(Bullet b) {
        float rad = ((Float)b.data).floatValue();
        for (int i = 0; i < 2; ++i) {
            float chance = Mathf.lerp((float)0.5f, (float)0.2f, (float)(b.time / b.lifetime));
            if (!Mathf.chance((double)chance) || !Vars.state.isPlaying() || !b.timer(1, 1.0f)) continue;
            float a0 = (float)Mathf.random((int)360) + b.rotation();
            float r0 = Mathf.random((float)(-rad / 5.0f), (float)(rad / 2.0f)) + rad;
            float a1 = (float)Mathf.random((int)360) + b.rotation();
            float r1 = Mathf.random((float)(-rad / 5.0f), (float)(rad / 2.0f)) + rad;
            Vec2 pos0 = new Vec2(b.x + r0 * Mathf.sinDeg((float)a0), b.y + r0 * Mathf.cosDeg((float)a0));
            Vec2 pos1 = new Vec2(b.x + r1 * Mathf.sinDeg((float)a1), b.y + r1 * Mathf.cosDeg((float)a1));
            PosLightning.createEffect((Position)pos0, (Position)pos1, this.lightningColor, 1, 2.5f);
            this.fx.at((Position)pos0);
            this.fx.at((Position)pos1);
        }
    }

    public void init(Bullet b) {
        super.init(b);
        b.data = Float.valueOf(this.DOTRadius);
    }

    public void update(Bullet b) {
        super.update(b);
        float rad = ((Float)b.data).floatValue();
        b.data = Float.valueOf(rad += this.radIncrease);
        if (b.timer(2, this.damageInterval)) {
            Damage.damage((Team)b.team, (float)b.x, (float)b.y, (float)(rad * 1.2f), (float)(this.DOTDamage * b.damageMultiplier()));
            Units.nearby(null, (float)b.x, (float)b.y, (float)rad, unit -> {
                if (unit.team != b.team) {
                    unit.apply(this.effect, 30.0f);
                }
            });
        }
    }
}

