/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.func.Cons2;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Healthc;
import mindustry.gen.Unit;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;

public class ChainBulletType
extends BulletType {
    protected static final Seq<ChainBulletType> all = new Seq();
    protected static final Bullet bu = Bullet.create();
    protected static final Seq<Position> points = new Seq();
    protected static final Vec2 tmpVec = new Vec2();
    public int maxHit = 12;
    public float chainRange = 200.0f;
    public float length = 200.0f;
    public float thick = 2.0f;
    public int boltNum = 2;
    public boolean quietShoot = false;
    public Cons2<Position, Position> effectController = (f, t) -> PosLightning.createEffect(f, t, this.hitColor, this.boltNum, this.thick);

    public ChainBulletType(float damage) {
        super(0.01f, damage);
        this.despawnEffect = Fx.none;
        this.instantDisappear = true;
        all.add((Object)this);
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, (this.length + this.chainRange) * 2.0f);
    }

    protected float calculateRange() {
        if (this.rangeOverride > 0.0f) {
            return this.rangeOverride;
        }
        return this.chainRange + this.length;
    }

    public void init(Bullet b) {
        Healthc target = Damage.linecast((Bullet)b, (float)b.x, (float)b.y, (float)b.rotation(), (float)this.length);
        if (target == null) {
            target = tmpVec.trns(b.rotation(), this.length).add((Position)b);
        }
        Healthc confirm = target;
        Units.nearbyEnemies((Team)b.team, (Rect)Tmp.r1.setSize(this.chainRange).setCenter(confirm.getX(), confirm.getY()), u -> {
            if (u.checkTarget(this.collidesAir, this.collidesGround) && u.targetable(b.team)) {
                points.add(u);
            }
        });
        if (this.collidesGround) {
            Vars.indexer.eachBlock(null, confirm.getX(), confirm.getY(), this.chainRange, t -> t.team != b.team, arg_0 -> points.add(arg_0));
        }
        if (!this.quietShoot || !points.isEmpty()) {
            NHFunc.shuffle(points, NHFunc.rand((long)Mathf.round((float)confirm.getX(), (int)16) + 8L << Mathf.round((float)confirm.getY(), (int)16)));
            points.truncate(this.maxHit);
            points.insert(0, (Object)b);
            points.insert(1, (Object)target);
            for (int i = 1; i < ChainBulletType.points.size; ++i) {
                Position from = (Position)points.get(i - 1);
                Position to = (Position)points.get(i);
                Position sureTarget = PosLightning.findInterceptedPoint(from, to, b.team);
                this.effectController.get((Object)from, (Object)sureTarget);
                this.lightningType.create(b, sureTarget.getX(), sureTarget.getY(), 0.0f).damage(this.damage);
                this.hitEffect.at(sureTarget.getX(), sureTarget.getY(), this.hitColor);
                if (sureTarget instanceof Unit) {
                    ((Unit)sureTarget).apply(this.status, this.statusDuration);
                }
                if (sureTarget != to) break;
            }
        }
        points.clear();
        b.remove();
        b.vel.setZero();
    }

    public void hit(Bullet b, float x, float y) {
    }

    public void hit(Bullet b) {
    }

    public void despawned(Bullet b) {
    }

    public void drawLight(Bullet b) {
    }

    public void handlePierce(Bullet b, float initialHealth, float x, float y) {
    }
}

