/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.math.Interp;
import arc.math.Mathf;
import arc.struct.FloatSeq;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;

public class AccelBulletType
extends BasicBulletType {
    public float velocityBegin = 0.1f;
    public float velocityIncrease = 0.0f;
    public float accelerateBegin = 0.1f;
    public float accelerateEnd = 0.6f;
    public Interp accelInterp = Interp.linear;

    public AccelBulletType() {
    }

    public AccelBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
    }

    public AccelBulletType(float speed, float damage) {
        this(speed, damage, "bullet");
    }

    public AccelBulletType(float damage, String bulletSprite) {
        super(1.0f, damage, bulletSprite);
    }

    public void disableAccel() {
        this.accelerateBegin = 10.0f;
    }

    protected float calculateRange() {
        if (this.velocityBegin < 0.0f) {
            this.velocityBegin = this.speed;
        }
        boolean computeRange = this.rangeOverride < 0.0f;
        float cal = 0.0f;
        FloatSeq speeds = new FloatSeq();
        for (float i = 0.0f; i <= 1.0f; i += 0.05f) {
            float s = this.velocityBegin + this.accelInterp.apply(Mathf.curve((float)i, (float)this.accelerateBegin, (float)this.accelerateEnd)) * this.velocityIncrease;
            speeds.add(s);
            if (!computeRange) continue;
            cal += s * this.lifetime * 0.05f;
        }
        this.speed = speeds.sum() / (float)speeds.size;
        if (computeRange) {
            cal += 1.0f;
        }
        return cal;
    }

    public void init() {
        super.init();
    }

    public void update(Bullet b) {
        if (this.accelerateBegin < 1.0f) {
            b.vel.setLength(this.velocityBegin + this.accelInterp.apply(Mathf.curve((float)b.fin(), (float)this.accelerateBegin, (float)this.accelerateEnd)) * this.velocityIncrease);
        }
        super.update(b);
    }
}

