/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.Core;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Strings;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHColor;
import newhorizon.content.NHStatValues;
import newhorizon.content.NHStats;

public class SpeedupTurret
extends PowerTurret {
    public float overheatTime = 360.0f;
    public float overheatCoolAmount = 1.25f;
    public float maxSpeedupScl = 0.5f;
    public float speedupPerShoot = 0.075f;
    public float slowDownReloadTime = 150.0f;
    public float inaccuracyUp = 0.0f;
    public float maxHeatEffectChance = 0.3f;
    public Effect heatEffect = Fx.reactorsmoke;

    public SpeedupTurret(String name) {
        super(name);
    }

    public void setBars() {
        super.setBars();
        this.addBar("speedboost", entity -> new Bar(() -> Core.bundle.format("nh.bar.speed-up", new Object[]{Strings.autoFixed((float)(entity.speedupScl * 100.0f), (int)0)}), () -> NHColor.lightSkyBack, () -> entity.speedupScl / this.maxSpeedupScl));
        this.addBar("overheat", entity -> new Bar(() -> Core.bundle.format("nh.bar.overheat", new Object[]{Strings.autoFixed((float)(Mathf.clamp((float)(entity.overheat / this.overheatTime), (float)0.0f, (float)this.overheatTime) * 100.0f), (int)0)}), () -> entity.requireCompleteCooling ? Pal.redderDust : Pal.powerLight, () -> entity.overheat / this.overheatTime));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.fireRateMax, Strings.autoFixed((float)((1.0f + this.maxSpeedupScl) * 100.0f), (int)0) + "%", new Object[0]);
        this.stats.add(NHStats.overheatCooldown, this.overheatTime / this.overheatCoolAmount / 60.0f, StatUnit.seconds);
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, NHStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType}), 0, false));
        if (this.coolant != null) {
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, NHStatValues.boosters(this.reload, this.coolant.amount, this.coolantMultiplier, true, (Boolf<Liquid>)((Boolf)l -> l.coolant && this.consumesLiquid((Liquid)l)), false));
        }
    }

    public class SpeedupTurretBuild
    extends PowerTurret.PowerTurretBuild {
        public float speedupScl;
        public float slowDownReload;
        public float overheat;
        public boolean requireCompleteCooling;

        public SpeedupTurretBuild() {
            super((PowerTurret)SpeedupTurret.this);
            this.speedupScl = 0.0f;
            this.slowDownReload = 0.0f;
            this.overheat = 0.0f;
            this.requireCompleteCooling = false;
        }

        public void updateTile() {
            this.updateCooldown();
            if (this.overheat < SpeedupTurret.this.overheatTime && !this.requireCompleteCooling) {
                super.updateTile();
            } else {
                this.forceCoolDown();
            }
        }

        public void updateCooldown() {
            if (this.slowDownReload > 0.0f) {
                this.slowDownReload -= Time.delta;
            } else {
                this.speedupScl = Mathf.lerpDelta((float)this.speedupScl, (float)0.0f, (float)0.05f);
                if (!this.requireCompleteCooling) {
                    this.coolDown();
                }
            }
            if (this.overheat > SpeedupTurret.this.overheatTime * 0.3f && Mathf.chanceDelta((double)(SpeedupTurret.this.maxHeatEffectChance * (this.requireCompleteCooling ? 1.0f : this.overheat / SpeedupTurret.this.overheatTime)))) {
                SpeedupTurret.this.heatEffect.at(this.x + (float)Mathf.range((int)(8 * SpeedupTurret.this.size / 2)), this.y + (float)Mathf.range((int)(8 * SpeedupTurret.this.size / 2)), this.rotation, SpeedupTurret.this.heatColor);
            }
        }

        public void forceCoolDown() {
            this.slowDownReload = 0.0f;
            this.coolDown();
            this.shootWarmup = SpeedupTurret.this.linearWarmup ? Mathf.approachDelta((float)this.shootWarmup, (float)0.0f, (float)SpeedupTurret.this.shootWarmupSpeed) : Mathf.lerpDelta((float)this.shootWarmup, (float)0.0f, (float)SpeedupTurret.this.shootWarmupSpeed);
            this.unit.tile((Building)this);
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            this.curRecoil = Mathf.approachDelta((float)this.curRecoil, (float)0.0f, (float)(1.0f / SpeedupTurret.this.recoilTime));
            this.recoilOffset.trns(this.rotation, -Mathf.pow((float)this.curRecoil, (float)SpeedupTurret.this.recoilPow) * SpeedupTurret.this.recoil);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            if (this.overheat <= 0.0f) {
                this.overheat = 0.0f;
                this.requireCompleteCooling = false;
            }
        }

        public void coolDown() {
            if (this.overheat > 0.0f) {
                this.overheat -= SpeedupTurret.this.overheatCoolAmount * (1.0f + this.coolantEfficiency()) * Time.delta;
            }
        }

        public float coolantEfficiency() {
            return this.liquids.current() == null ? 0.0f : this.liquids.current().heatCapacity;
        }

        protected void updateShooting() {
            if (this.reloadCounter >= SpeedupTurret.this.reload) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter = 0.0f;
            } else {
                this.reloadCounter += (1.0f + this.speedupScl) * this.delta() * this.peekAmmo().reloadMultiplier * this.baseReloadSpeed();
                this.overheat = Mathf.approachDelta((float)this.overheat, (float)(SpeedupTurret.this.overheatTime + 0.05f), (float)(this.efficiency * this.timeScale * (this.speedupScl / SpeedupTurret.this.maxSpeedupScl * 1.0f) / (1.0f + (this.liquids.current() == null ? 0.0f : this.liquids.current().heatCapacity))));
                if (this.overheat > SpeedupTurret.this.overheatTime) {
                    this.requireCompleteCooling = true;
                }
            }
        }

        protected void shoot(BulletType type) {
            super.shoot(type);
            this.slowDownReload = SpeedupTurret.this.slowDownReloadTime;
            this.speedupScl = this.speedupScl < SpeedupTurret.this.maxSpeedupScl ? (this.speedupScl += SpeedupTurret.this.speedupPerShoot) : SpeedupTurret.this.maxSpeedupScl;
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            super.bullet(type, xOffset, yOffset, angleOffset + Mathf.range((float)(this.speedupScl * SpeedupTurret.this.inaccuracyUp)), mover);
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.overheat);
            write.f(this.slowDownReload);
            write.f(this.speedupScl);
            write.bool(this.requireCompleteCooling);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 2) {
                this.overheat = read.f();
                this.slowDownReload = read.f();
                this.speedupScl = read.f();
                this.requireCompleteCooling = read.bool();
            }
        }
    }
}

