/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.IntMap;
import arc.struct.ObjectMap;
import arc.util.Time;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.gen.Entityc;
import mindustry.type.Item;
import mindustry.world.blocks.defense.turrets.ItemTurret;

public class ShootMatchTurret
extends ItemTurret {
    public float lifeRnd = 0.0f;
    public IntMap<ShootPattern> shooterMap = new IntMap();

    public ShootMatchTurret(String name) {
        super(name);
    }

    public void shooter(Object ... objects) {
        ObjectMap mapper = ObjectMap.of((Object[])objects);
        for (ObjectMap.Entry entry : this.ammoTypes.entries()) {
            this.shooterMap.put((int)((BulletType)entry.value).id, (Object)((ShootPattern)mapper.get((Object)((Item)entry.key), (Object)this.shoot)));
        }
    }

    public class ShootMatchTurretBuild
    extends ItemTurret.ItemTurretBuild {
        public ShootMatchTurretBuild() {
            super((ItemTurret)ShootMatchTurret.this);
        }

        public ShootPattern getShooter(BulletType type) {
            ShootPattern s = (ShootPattern)ShootMatchTurret.this.shooterMap.get((int)type.id);
            return s == null ? ShootMatchTurret.this.shoot : s;
        }

        protected void shoot(BulletType type) {
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)ShootMatchTurret.this.shootX, (float)ShootMatchTurret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)ShootMatchTurret.this.shootX, (float)ShootMatchTurret.this.shootY);
            ShootPattern shoot = this.getShooter(type);
            if (shoot.firstShotDelay > 0.0f) {
                ShootMatchTurret.this.chargeSound.at(bulletX, bulletY, Mathf.random((float)ShootMatchTurret.this.soundPitchMin, (float)ShootMatchTurret.this.soundPitchMax));
                type.chargeEffect.at(bulletX, bulletY, this.rotation);
            }
            shoot.shoot(this.barrelCounter, (xOffset, yOffset, angle, delay, mover) -> {
                ++this.queuedBullets;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> this.bullet(type, xOffset, yOffset, angle, mover));
                } else {
                    this.bullet(type, xOffset, yOffset, angle, mover);
                }
            }, () -> ++this.barrelCounter);
            if (ShootMatchTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            float lifeScl;
            --this.queuedBullets;
            if (this.dead || !ShootMatchTurret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)ShootMatchTurret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(ShootMatchTurret.this.shootX + xOffset + xSpread), (float)(ShootMatchTurret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(ShootMatchTurret.this.shootX + xOffset + xSpread), (float)(ShootMatchTurret.this.shootY + yOffset));
            float shootAngle = this.rotation + angleOffset + Mathf.range((float)(ShootMatchTurret.this.inaccuracy + type.inaccuracy));
            float f = lifeScl = type.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y) / type.range), (float)(ShootMatchTurret.this.minRange / type.range), (float)(this.range() / type.range)) : 1.0f;
            if (ShootMatchTurret.this.lifeRnd > 0.0f) {
                lifeScl += Mathf.range((float)ShootMatchTurret.this.lifeRnd);
            }
            this.handleBullet(type.create((Entityc)this, this.team, bulletX, bulletY, shootAngle, -1.0f, 1.0f - ShootMatchTurret.this.velocityRnd + Mathf.random((float)ShootMatchTurret.this.velocityRnd), lifeScl, null, mover, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            (ShootMatchTurret.this.shootEffect == null ? type.shootEffect : ShootMatchTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (ShootMatchTurret.this.smokeEffect == null ? type.smokeEffect : ShootMatchTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            ShootMatchTurret.this.shootSound.at(bulletX, bulletY, Mathf.random((float)ShootMatchTurret.this.soundPitchMin, (float)ShootMatchTurret.this.soundPitchMax));
            ShootMatchTurret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)ShootMatchTurret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)ShootMatchTurret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (ShootMatchTurret.this.shake > 0.0f) {
                Effect.shake((float)ShootMatchTurret.this.shake, (float)ShootMatchTurret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (ShootMatchTurret.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % ShootMatchTurret.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!ShootMatchTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }
    }
}

