/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec3;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.ObjectMap;
import arc.util.Scaling;
import arc.util.Tmp;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.ContentInfoDialog;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.meta.Stat;

public class MultTractorBeamTurret
extends TractorBeamTurret {
    public int maxAttract = 5;
    public StatusEffect status = StatusEffects.slow;
    public float statusDuration = 10.0f;

    public MultTractorBeamTurret(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shots, (float)this.maxAttract);
        if (this.status != null && this.status != StatusEffects.none && !this.status.isHidden()) {
            this.stats.add(Stat.abilities, table -> table.row().table().padLeft(24.0f).getTable().table(t -> {
                t.align(10);
                t.table(info -> {
                    info.left();
                    info.add((CharSequence)("[lightgray]" + Core.bundle.get("content.status.name") + ": ")).padRight(12.0f);
                    info.button((Drawable)new TextureRegionDrawable(this.status.uiIcon), Styles.cleari, () -> new ContentInfoDialog().show((UnlockableContent)this.status)).scaling(Scaling.fit);
                }).fill().row();
                t.add((CharSequence)("Duration: " + this.statusDuration / 60.0f + ".sec")).growX().fillY();
            }).fill().padBottom(12.0f).left().row());
        }
    }

    public void load() {
        super.load();
        this.laser = Core.atlas.find("parallax-laser");
        this.laserEnd = Core.atlas.find("parallax-laser-end");
    }

    public class MultTractorBeamBuild
    extends TractorBeamTurret.TractorBeamBuild {
        public final ObjectMap<Unit, Vec3> targets;

        public MultTractorBeamBuild() {
            super((TractorBeamTurret)MultTractorBeamTurret.this);
            this.targets = new ObjectMap(MultTractorBeamTurret.this.maxAttract);
        }

        public void updateTile() {
            super.updateTile();
            for (Unit unit2 : this.targets.keys()) {
                if (unit2 != null && Angles.within((float)this.rotation, (float)this.angleTo((Position)unit2), (float)MultTractorBeamTurret.this.shootCone) && this.within((Position)unit2, MultTractorBeamTurret.this.range + unit2.hitSize / 2.0f) && unit2.team() != this.team && unit2.isValid() && unit2.checkTarget(MultTractorBeamTurret.this.targetAir, MultTractorBeamTurret.this.targetGround)) {
                    ((Vec3)this.targets.get((Object)unit2)).x = unit2.x;
                    ((Vec3)this.targets.get((Object)unit2)).y = unit2.y;
                    ((Vec3)this.targets.get((Object)unit2)).z = Mathf.lerpDelta((float)((Vec3)this.targets.get((Object)unit2)).z, (float)1.0f, (float)0.1f);
                    if (unit2 == this.target) continue;
                    if (MultTractorBeamTurret.this.damage > 0.0f) {
                        unit2.damageContinuous(MultTractorBeamTurret.this.damage * this.efficiency);
                    }
                    if (MultTractorBeamTurret.this.status != StatusEffects.none) {
                        unit2.apply(MultTractorBeamTurret.this.status, MultTractorBeamTurret.this.statusDuration);
                    }
                    unit2.impulseNet(Tmp.v1.set((Position)this).sub((Position)unit2).limit((MultTractorBeamTurret.this.force + (1.0f - unit2.dst((Position)this) / MultTractorBeamTurret.this.range) * MultTractorBeamTurret.this.scaledForce) * this.edelta() * this.timeScale));
                    continue;
                }
                Vec3 v = (Vec3)this.targets.get((Object)unit2);
                if (v == null) continue;
                v.z = Mathf.lerpDelta((float)v.z, (float)0.0f, (float)0.1f);
                if (!Mathf.equal((float)((Vec3)this.targets.get((Object)unit2)).z, (float)0.0f, (float)0.001f)) continue;
                this.targets.remove((Object)unit2);
            }
            if (this.target != null && this.target.within((Position)this, MultTractorBeamTurret.this.range + this.target.hitSize / 2.0f) && this.target.team() != this.team && this.target.checkTarget(MultTractorBeamTurret.this.targetAir, MultTractorBeamTurret.this.targetGround) && this.efficiency > 0.02f) {
                Units.nearbyEnemies((Team)this.team, (Rect)Tmp.r1.setSize((MultTractorBeamTurret.this.range + this.target.hitSize / 2.0f) * 2.0f).setCenter(this.x, this.y), unit -> {
                    if (this.targets.size < MultTractorBeamTurret.this.maxAttract && !this.targets.keys().toSeq().contains(unit) && Angles.within((float)this.rotation, (float)this.angleTo((Position)unit), (float)MultTractorBeamTurret.this.shootCone)) {
                        this.targets.put(unit, (Object)new Vec3(unit.x, unit.y, 0.0f));
                    }
                });
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)MultTractorBeamTurret.this.baseRegion, (float)this.x, (float)this.y);
            Drawf.shadow((TextureRegion)MultTractorBeamTurret.this.region, (float)(this.x - (float)MultTractorBeamTurret.this.size / 2.0f), (float)(this.y - (float)MultTractorBeamTurret.this.size / 2.0f), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)MultTractorBeamTurret.this.region, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
            Draw.z((float)100.0f);
            for (Unit unit : this.targets.keys()) {
                if (unit == null) continue;
                float ang = this.angleTo(((Vec3)this.targets.get((Object)unit)).x, ((Vec3)this.targets.get((Object)unit)).y);
                Draw.mixcol();
                Draw.mixcol((Color)MultTractorBeamTurret.this.laserColor, (float)Mathf.absin((float)4.0f, (float)0.6f));
                Tmp.v1.trns(this.rotation, MultTractorBeamTurret.this.shootLength).add(this.x, this.y);
                Drawf.laser((TextureRegion)MultTractorBeamTurret.this.laser, (TextureRegion)MultTractorBeamTurret.this.laserEnd, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)((Vec3)this.targets.get((Object)unit)).x, (float)((Vec3)this.targets.get((Object)unit)).y, (float)(((Vec3)this.targets.get((Object)unit)).z * this.efficiency * MultTractorBeamTurret.this.laserWidth));
            }
        }
    }
}

