/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import newhorizon.expand.block.special.DeviceBase;
import newhorizon.expand.block.turrets.AdaptTurret;

public class AdaptItemTurret
extends ItemTurret {
    public AdaptItemTurret(String name) {
        super(name);
    }

    public class AdaptItemTurretBuild
    extends ItemTurret.ItemTurretBuild
    implements AdaptTurret {
        public ShootPattern pattern;
        public float reloadModifier;
        public float kineticModifier;
        public float energyModifier;
        public float rangeModifier;
        public int lastDeviceBasePos;

        public AdaptItemTurretBuild() {
            super((ItemTurret)AdaptItemTurret.this);
            this.pattern = new ShootPattern();
            this.reloadModifier = 1.0f;
            this.kineticModifier = 1.0f;
            this.energyModifier = 1.0f;
            this.rangeModifier = 1.0f;
        }

        public void created() {
            super.created();
            this.resetModifier();
        }

        public void resetModifier() {
            this.pattern = AdaptItemTurret.this.shoot;
            this.reloadModifier = 1.0f;
            this.kineticModifier = 1.0f;
            this.energyModifier = 1.0f;
            this.rangeModifier = 1.0f;
        }

        public void updatePattern(ShootPattern pattern) {
            if (pattern == this.pattern) {
                return;
            }
            this.pattern = pattern;
            this.barrelCounter = 0;
        }

        public void updateReloadModifier(float reloadModifier) {
            this.reloadModifier = reloadModifier;
        }

        public void updateKineticModifier(float kineticModifier) {
            this.kineticModifier = kineticModifier;
        }

        public void updateEnergyModifier(float energyModifier) {
            this.energyModifier = energyModifier;
        }

        protected void updateReload() {
            this.reloadCounter += this.delta() * this.ammoReloadMultiplier() * this.baseReloadSpeed() * this.reloadModifier;
            this.reloadCounter = Math.min(this.reloadCounter, AdaptItemTurret.this.reload);
        }

        public void updateTile() {
            super.updateTile();
            if (!(Vars.world.build(this.lastDeviceBasePos) instanceof DeviceBase.DeviceBaseBuild)) {
                this.resetModifier();
            }
        }

        protected void shoot(BulletType type) {
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)AdaptItemTurret.this.shootX, (float)AdaptItemTurret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)AdaptItemTurret.this.shootX, (float)AdaptItemTurret.this.shootY);
            if (this.pattern.firstShotDelay > 0.0f) {
                AdaptItemTurret.this.chargeSound.at(bulletX, bulletY, Mathf.random((float)AdaptItemTurret.this.soundPitchMin, (float)AdaptItemTurret.this.soundPitchMax));
                type.chargeEffect.at(bulletX, bulletY, this.rotation);
            }
            this.pattern.shoot(this.barrelCounter, (xOffset, yOffset, angle, delay, mover) -> {
                ++this.queuedBullets;
                int barrel = this.barrelCounter;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> {
                        int prev = this.barrelCounter;
                        this.barrelCounter = barrel;
                        this.bullet(type, xOffset, yOffset, angle, mover);
                        this.barrelCounter = prev;
                    });
                } else {
                    this.bullet(type, xOffset, yOffset, angle, mover);
                }
            }, () -> ++this.barrelCounter);
            if (AdaptItemTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }

        @Override
        public ShootPattern pattern() {
            return this.pattern;
        }

        @Override
        public float reloadModifier() {
            return this.reloadModifier;
        }

        @Override
        public float kineticModifier() {
            return this.kineticModifier;
        }

        @Override
        public float energyModifier() {
            return this.energyModifier;
        }

        @Override
        public float rangeModifier() {
            return this.rangeModifier;
        }
    }
}

