/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.ctype.ContentType;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BuildVisibility;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class UnitSpawner
extends Block {
    protected static String divKey = "@@@";
    public float spawnRange = 4.0f;

    public UnitSpawner(String name) {
        super(name);
        this.alwaysUnlocked = true;
        this.ambientSound = this.breakSound = Sounds.none;
        this.destroySound = this.breakSound;
        this.size = 1;
        this.update = true;
        this.outputsPayload = true;
        this.hasPower = false;
        this.configurable = true;
        this.clipSize = 120.0f;
        this.saveConfig = true;
        this.rebuildable = false;
        this.solidifes = false;
        this.solid = false;
        this.requirements = ItemStack.empty;
        this.category = Category.units;
        this.destroyEffect = Fx.none;
        this.buildVisibility = BuildVisibility.sandboxOnly;
        this.config(UnitType.class, (build, unit) -> {
            build.toSpawnType = unit;
        });
        this.config(String.class, (build, unit) -> {
            String[] s = unit.split(divKey);
            if (s.length < 3) {
                return;
            }
            build.angle = Float.parseFloat(s[1]);
            build.delay = Float.parseFloat(s[2]);
            build.toSpawnType = (UnitType)Vars.content.getByName(ContentType.unit, s[0]);
        });
        this.configClear(tile -> {
            tile.toSpawnType = UnitTypes.alpha;
            tile.angle = 0.0f;
            tile.delay = 30.0f;
        });
    }

    public boolean isHidden() {
        return !Vars.state.rules.editor;
    }

    public boolean canBeBuilt() {
        return Vars.state.rules.editor;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (!this.canBeBuilt()) {
            this.drawPlaceText(Core.bundle.get("mod.ui.cautions.unit-initer"), x, y, valid);
        }
    }

    public class UnitIniterBuild
    extends Building {
        public UnitType toSpawnType = UnitTypes.alpha;
        public float angle;
        public float delay = 360.0f;
        public transient boolean addUnit = false;

        public void onDestroyed() {
        }

        public void afterDestroyed() {
        }

        public void buildConfiguration(Table table) {
            table.slider(5.0f, 20.0f, 1.0f, 0.0f, f -> {
                this.delay = f * 60.0f;
            }).growX().row();
            table.slider(0.0f, 360.0f, 45.0f, 0.0f, f -> {
                this.angle = f;
            }).growX().row();
            ItemSelection.buildTable((Table)table, (Seq)Vars.content.units().select(b -> !b.isHidden()), this::type, arg_0 -> ((UnitIniterBuild)this).configure(arg_0));
        }

        public UnitType type() {
            return (UnitType)Vars.content.getByName(ContentType.unit, this.config().split(divKey)[0]);
        }

        public String config() {
            return this.toSpawnType.name + divKey + this.angle + divKey + this.delay;
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            super.control(type, p1, p2, p3, p4);
            if (type == LAccess.shootp && p1 instanceof String) {
                this.toSpawnType = Vars.content.unit((String)p1);
                this.angle = (float)p2;
                this.delay = 30.0f;
            }
        }

        public void updateTile() {
            if (!this.addUnit) {
                this.addUnit();
            }
        }

        public void drawConfigure() {
        }

        public void draw() {
            if (Vars.state.isEditor()) {
                super.draw();
                Tmp.v1.trns(this.angle, (float)(8 * UnitSpawner.this.size) * 1.5f);
                Drawf.arrow((float)this.x, (float)this.y, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)(UnitSpawner.this.size * 8), (float)4.0f);
                if (this.toSpawnType == null) {
                    return;
                }
                Drawf.light((float)this.x, (float)this.y, (float)((float)(8 * UnitSpawner.this.size) * 3.0f), (Color)this.team.color, (float)0.8f);
                Draw.z((float)120.0f);
                Draw.rect((TextureRegion)this.toSpawnType.fullIcon, (float)this.x, (float)this.y, (float)(UnitSpawner.this.size * 8), (float)(UnitSpawner.this.size * 8));
                DrawFunc.overlayText(this.delay / 60.0f + "s", this.x - Tmp.v1.x, this.y - Tmp.v1.y, -4.0f, Pal.accent, true);
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.angle);
            write.f(this.delay);
            TypeIO.writeUnitType((Writes)write, (UnitType)this.toSpawnType);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.angle = read.f();
            this.delay = read.f();
            this.toSpawnType = TypeIO.readUnitType((Reads)read);
        }

        public void addUnit() {
            NHFunc.spawnUnit(this.team, this.x, this.y, this.angle, UnitSpawner.this.spawnRange, this.delay, 0.0f, this.toSpawnType, 1);
            this.kill();
            this.addUnit = true;
        }
    }
}

