/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectSet;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.modules.ItemModule;
import newhorizon.NHGroups;
import newhorizon.util.graphic.DrawFunc;

public class RemoteCoreStorage
extends StorageBlock {
    public float powerConsumption = 10.0f;

    public RemoteCoreStorage(String name) {
        super(name);
        this.update = true;
        this.hasItems = true;
        this.itemCapacity = 0;
        this.configurable = true;
        this.replaceable = false;
        this.consumePowerDynamic(b -> (float)NHGroups.placedRemoteCore[b.team.id].size * this.powerConsumption);
    }

    public static void clear() {
        for (ObjectSet<RemoteCoreStorageBuild> set : NHGroups.placedRemoteCore) {
            set.clear();
        }
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (this.maxPlaceNum(Vars.player.team()) <= NHGroups.placedRemoteCore[Vars.player.team().id].size) {
            this.drawPlaceText(Core.bundle.get("nh.reach-limit"), x, y, false);
        }
    }

    public boolean shouldLimit(Team team) {
        return (team != Vars.state.rules.waveTeam || Vars.state.rules.pvp) && !team.rules().cheat && !Vars.state.rules.infiniteResources;
    }

    public int maxPlaceNum(Team team) {
        return !this.shouldLimit(team) ? Integer.MAX_VALUE : 10;
    }

    public boolean isAccessible() {
        return true;
    }

    public void setBars() {
        super.setBars();
        this.removeBar("items");
        this.addBar("maxPlace", entity -> new Bar(() -> Core.bundle.format("nh.bar.max-place", new Object[]{NHGroups.placedRemoteCore[entity.team.id].size, this.shouldLimit(entity.team) ? Integer.valueOf(this.maxPlaceNum(entity.team)) : "\u221e"}), () -> NHGroups.placedRemoteCore[entity.team.id].size < this.maxPlaceNum(entity.team) ? Pal.accent : Pal.redderDust, () -> this.shouldLimit(entity.team) ? (float)NHGroups.placedRemoteCore[entity.team.id].size / (float)this.maxPlaceNum(entity.team) : 1.0f));
        this.addBar("warmup", entity -> new Bar(() -> Mathf.equal((float)entity.warmup, (float)1.0f, (float)0.015f) ? Core.bundle.get("done") : Core.bundle.get("research.load"), () -> Mathf.equal((float)entity.warmup, (float)1.0f, (float)0.015f) ? Pal.heal : Pal.redderDust, () -> entity.warmup));
        this.addBar("items", entity -> new Bar(() -> Core.bundle.format("bar.items", new Object[]{entity.items.total()}), () -> Pal.items, () -> entity.items.total() / (entity.core() == null ? Integer.MAX_VALUE : entity.core().storageCapacity)));
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return super.canPlaceOn(tile, team, rotation) && NHGroups.placedRemoteCore[team.id].size < this.maxPlaceNum(team);
    }

    public class RemoteCoreStorageBuild
    extends StorageBlock.StorageBuild {
        public float warmup;
        public float progress;

        public RemoteCoreStorageBuild() {
            super((StorageBlock)RemoteCoreStorage.this);
            this.warmup = 0.0f;
            this.progress = 0.0f;
        }

        public void onRemoved() {
            super.onRemoved();
            NHGroups.placedRemoteCore[this.team.id].remove((Object)this);
        }

        public void created() {
            Core.app.post(() -> NHGroups.placedRemoteCore[this.team.id].add((Object)this));
        }

        public void updateTile() {
            this.warmup = this.efficiency > 0.0f && this.core() != null && NHGroups.placedRemoteCore[this.team.id].size <= RemoteCoreStorage.this.maxPlaceNum(this.team) ? (Mathf.equal((float)this.warmup, (float)1.0f, (float)0.015f) ? 1.0f : Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)0.01f)) : (Mathf.equal((float)this.warmup, (float)0.0f, (float)0.015f) ? 0.0f : Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.03f));
            this.progress += this.warmup * this.efficiency * Time.delta;
            if (Mathf.equal((float)this.warmup, (float)1.0f, (float)0.015f)) {
                if (this.linkedCore == null || !this.linkedCore.isValid() && this.core() != null) {
                    this.linkedCore = this.core();
                    this.items = this.linkedCore.items;
                }
            } else {
                this.linkedCore = null;
                this.items = new ItemModule();
            }
        }

        public void draw() {
            super.draw();
            Draw.z((float)109.0f);
            Draw.color((Color)this.team.color);
            CoreBlock.CoreBuild b = this.core();
            if (b != null) {
                for (int i = 0; i < 5; ++i) {
                    float f = (this.progress - (float)(25 * i)) % 100.0f / 100.0f;
                    Tmp.v1.trns(this.angleTo((Position)b), f * 8.0f * (float)RemoteCoreStorage.this.size * 4.0f);
                    Lines.stroke((float)(this.warmup * 1.5f * (1.0f - f)));
                    Lines.square((float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)((1.0f - f) * 8.0f), (float)45.0f);
                }
            }
        }

        public boolean canPickup() {
            return false;
        }

        public void drawSelect() {
        }

        public void drawConfigure() {
            if (this.core() != null) {
                DrawFunc.posSquareLink(Mathf.equal((float)this.warmup, (float)1.0f, (float)0.015f) ? Pal.heal : Pal.redderDust, 1.0f, 4.0f, true, (Position)this.tile, (Position)this.core());
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }
    }
}

