/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Rand;
import arc.struct.Seq;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHItems;
import newhorizon.content.NHUnitTypes;

public class NexusCore
extends CoreBlock {
    public static Rand rand = new Rand();
    public final Seq<Trail> trails = Seq.with((Object[])new Trail[]{new Trail(30), new Trail(40), new Trail(50), new Trail(60), new Trail(70), new Trail(80), new Trail(90)});
    public final Interp interp = Interp.pow2Out;
    public float coreDelay = -1.0f;
    public int range = 40;
    public TextureRegion base;

    public NexusCore() {
        super("nexus-core");
        this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{NHItems.zeta, 1500, NHItems.presstanium, 1000, NHItems.juniorProcessor, 1000, NHItems.metalOxhydrigen, 1800, NHItems.multipleSteel, 600}));
        this.alwaysUnlocked = true;
        this.unitType = NHUnitTypes.liv;
        this.health = 30000;
        this.itemCapacity = 10000;
        this.size = 5;
        this.armor = 20.0f;
        this.incinerateNonBuildable = false;
        this.buildCostMultiplier = 2.0f;
        this.requiresCoreZone = false;
        this.unitCapModifier = 10;
        this.drawTeamOverlay = false;
    }

    public void load() {
        super.load();
        this.base = Core.atlas.find(this.name + "-base");
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
        this.stats.add(Stat.output, t -> {
            t.row().left();
            t.add((CharSequence)"").row();
            t.table(i -> {
                i.image().size(60.0f).color(Pal.lancerLaser).left();
                i.add((CharSequence)Core.bundle.get("mod.ui.gravity-trap-field-friendly")).growX().padLeft(6.0f).row();
            }).padTop(12.0f).growX().fillY().row();
            t.table(i -> {
                i.image().size(60.0f).color(Pal.redderDust).left();
                i.add((CharSequence)Core.bundle.get("mod.ui.gravity-trap-field-hostile")).growX().padLeft(6.0f).row();
            }).padTop(12.0f).growX().fillY().row();
        });
        this.stats.add(Stat.abilities, t -> t.table(table -> {
            table.left();
            table.defaults().fill().pad(4.0f).left();
            table.add((CharSequence)("- " + Core.bundle.get("mod.ui.gravity-trap.ability-1"))).row();
            table.add((CharSequence)("- " + Core.bundle.get("mod.ui.gravity-trap.ability-2"))).row();
            table.add((CharSequence)("- " + Core.bundle.get("mod.ui.gravity-trap.ability-3"))).row();
        }).fill());
    }
}

