/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.Input;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.TextArea;
import arc.scene.ui.layout.Table;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.WorldLabel;
import mindustry.graphics.Drawf;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Tile;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.meta.BuildVisibility;
import newhorizon.util.ui.TableFunc;

public class LabelSpawner
extends MessageBlock {
    public LabelSpawner(String name) {
        super(name);
        this.canOverdrive = false;
        this.targetable = false;
        this.forceDark = true;
        this.privileged = true;
        this.maxTextLength = 1000;
        this.config(Integer.class, LabelSpawnerBuild::setTargetPos);
        this.category = Category.logic;
        this.buildVisibility = BuildVisibility.sandboxOnly;
        this.requirements = ItemStack.empty;
    }

    public boolean checkForceDark(Tile tile) {
        return !this.accessible();
    }

    public boolean isHidden() {
        return !this.accessible();
    }

    public boolean canBreak(Tile tile) {
        return this.accessible();
    }

    public boolean canBeBuilt() {
        return this.accessible();
    }

    public boolean accessible() {
        return Vars.state.rules.editor;
    }

    public class LabelSpawnerBuild
    extends MessageBlock.MessageBuild {
        public int targetPos;

        public LabelSpawnerBuild() {
            super((MessageBlock)LabelSpawner.this);
            this.targetPos = -1;
        }

        public void damage(Team source, float damage) {
        }

        public void buildConfiguration(Table table) {
            if (!LabelSpawner.this.accessible()) {
                this.deselect();
                return;
            }
            table.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                if (Vars.mobile) {
                    Core.input.getTextInput(new Input.TextInput(){
                        {
                            this.text = this.message.toString();
                            this.multiline = true;
                            this.maxLength = LabelSpawner.this.maxTextLength;
                            this.accepted = str -> {
                                if (!str.equals(this.text)) {
                                    LabelSpawnerBuild.this.configure(str);
                                }
                            };
                        }
                    });
                } else {
                    BaseDialog dialog = new BaseDialog("@editmessage");
                    dialog.setFillParent(false);
                    TextArea a = (TextArea)dialog.cont.add((Element)new TextArea(this.message.toString().replace("\r", "\n"))).size(380.0f, 160.0f).get();
                    a.setFilter((textField, c) -> {
                        if (c == '\n') {
                            int count = 0;
                            for (int i = 0; i < textField.getText().length(); ++i) {
                                if (textField.getText().charAt(i) != '\n') continue;
                                ++count;
                            }
                            return count < LabelSpawner.this.maxNewlines;
                        }
                        return true;
                    });
                    a.setMaxLength(LabelSpawner.this.maxTextLength);
                    dialog.cont.row();
                    dialog.cont.label(() -> a.getText().length() + " / " + LabelSpawner.this.maxTextLength).color(Color.lightGray);
                    dialog.buttons.button("@ok", () -> {
                        if (!a.getText().equals(this.message.toString())) {
                            this.configure(a.getText());
                        }
                        dialog.hide();
                    }).size(130.0f, 60.0f);
                    dialog.update(() -> {
                        if (this.tile.build != this) {
                            dialog.hide();
                        }
                    });
                    dialog.closeOnBack();
                    dialog.show();
                }
                this.deselect();
            }).size(50.0f);
            table.button((Drawable)Icon.link, Styles.cleari, () -> TableFunc.selectPos(table, (Cons<Point2>)((Cons)p -> {
                this.targetPos = p.pack();
            }))).size(50.0f);
        }

        public void setTargetPos(int p) {
            this.targetPos = p;
        }

        public void onDestroyed() {
        }

        public void afterDestroyed() {
        }

        public void created() {
            Core.app.post(this::addLabel);
        }

        public void addLabel() {
            if (!Vars.net.client() && this.targetPos != -1) {
                WorldLabel l = (WorldLabel)Pools.obtain(WorldLabel.class, WorldLabel::create);
                String s = this.message.toString();
                l.text = s.startsWith("@") ? Core.bundle.get(s.replaceFirst("@", "")) : s;
                Tmp.p1.set(Point2.unpack((int)this.targetPos));
                l.set((float)(Tmp.p1.x * 8), (float)(Tmp.p1.y * 8));
                l.add();
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.targetPos);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.targetPos = read.i();
        }

        public void drawConfigure() {
            super.drawConfigure();
            if (this.targetPos != -1) {
                Tmp.p1.set(Point2.unpack((int)this.targetPos));
                Drawf.square((float)(Tmp.p1.x * 8), (float)(Tmp.p1.y * 8), (float)6.0f, (Color)this.team.color);
            }
        }

        public void drawSelect() {
            if (LabelSpawner.this.accessible()) {
                super.drawSelect();
            }
        }
    }
}

