/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import newhorizon.content.NHBullets;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.expand.bullets.EffectBulletType;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class HyperGenerator
extends PowerGenerator {
    private static final float minWarmup = 0.075f;
    public TextureRegion bottomRegion;
    public TextureRegion armorRegion;
    public TextureRegion gateRegion;
    public TextureRegion[] plasmaRegions;
    public float warmupSpeed = 0.0015f;
    public float disabledSpeed = 0.015f;
    public float itemDuration = 360.0f;
    public float structureLim = 0.3f;
    public float beginDamageScl = 0.01f;
    public float destroyedExplodeLimit = 0.5f;
    public int updateLightning;
    public int updateLightningRand;
    public float lightningRange = 160.0f;
    public int lightningLen = 4;
    public int lightningLenRand = 8;
    public float lightningDamage = 120.0f;
    public int subNum = 1;
    public int subNumRand = 1;
    public Seq<StatusEffect> toApplyStatus = new Seq();
    public float statusRange = 480.0f;
    public float statusDuration = 900.0f;
    public Cons<HyperGeneratorBuild> explodeAction = entity -> {};
    public Cons<Position> explodeSub = entity -> {};
    public float explosionRadius;
    public float explosionDamage;
    public float maxVelScl = 1.25f;
    public float minVelScl = 0.75f;
    public float maxTimeScl = 1.25f;
    public float minTimeScl = 0.75f;
    public float plasmaScl = 0.975f;
    public float gateSize = 5.0f;
    public float effectCircleSize = -1.0f;
    public float triWidth = 6.0f;
    public float triLength = 100.0f;
    public Effect updateEffect = NHFx.circle;
    public Effect workEffect = NHFx.line;
    public float updateEffectDiv = 20.0f;
    public float updateEffectSize = 20.0f;
    public float effectSinScl = 0.75f;
    public float effectSinMag = 0.11f;
    public Color effectColor = Color.white;
    public float workShake = 8.0f;
    public Sound workSound = Sounds.beamPlasma;
    public float attract = 8.0f;
    protected BulletType destroyed;

    public HyperGenerator(String name) {
        super(name);
        this.hasPower = true;
        this.hasLiquids = true;
        this.liquidCapacity = 30.0f;
        this.hasItems = true;
        this.consumesPower = true;
        this.outputsPower = true;
        this.baseExplosiveness = 1000.0f;
        this.explosionRadius = 220.0f;
        this.explosionDamage = 14000.0f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.reactor, BlockFlag.generator});
    }

    public void setBars() {
        super.setBars();
        this.addBar("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", new Object[]{Strings.fixed((float)(Math.max(entity.getPowerProduction() - this.consPower.usage, 0.0f) * 60.0f * entity.timeScale()), (int)1)}), () -> Pal.powerBar, () -> entity.productionEfficiency));
    }

    public void setStats() {
        super.setStats();
        if (this.hasItems) {
            this.stats.add(Stat.productionTime, this.itemDuration / 60.0f, StatUnit.seconds);
        }
        this.stats.add(Stat.abilities, StatValues.statusEffects(this.toApplyStatus));
        this.stats.add(Stat.abilities, this.statusRange / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.abilities, this.statusDuration / 6.0f, StatUnit.seconds);
    }

    public TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.teamRegion.found() && this.minfo.mod == null) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[4];
            textureRegionArray2[0] = this.bottomRegion;
            textureRegionArray2[1] = this.region;
            textureRegionArray2[2] = this.teamRegions[Team.sharded.id];
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[3] = this.armorRegion;
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[3];
            textureRegionArray3[0] = this.bottomRegion;
            textureRegionArray3[1] = this.region;
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[2] = this.armorRegion;
        }
        return textureRegionArray;
    }

    public void init() {
        super.init();
        if (this.effectCircleSize < 0.0f) {
            this.effectCircleSize = (float)(this.size * 8) / 6.0f;
        }
        this.clipSize = Math.max(this.clipSize, (float)(8 * this.size) * 8.0f);
        this.destroyed = new EffectBulletType(600.0f){
            private final Effect updateEffect1;
            private final Effect updateEffect2;
            {
                this.hittable = false;
                this.absorbable = false;
                this.speed = 0.0f;
                HyperGenerator.this.lightningLenRand = 4;
                HyperGenerator.this.lightningLen = 4;
                this.lightningDamage = HyperGenerator.this.lightningDamage / 2.0f;
                this.lightning = 3;
                this.damage = this.splashDamage = this.lightningDamage / 1.5f;
                this.splashDamageRadius = 38.0f;
                this.lightColor = this.lightningColor = HyperGenerator.this.effectColor;
                this.hitColor = this.lightningColor;
                this.despawnEffect = NHFx.circleOut(this.hitColor, HyperGenerator.this.lightningRange * 1.5f);
                this.hitEffect = NHFx.collapserBulletExplode;
                this.updateEffect2 = NHFx.blast(this.hitColor, HyperGenerator.this.lightningRange / 2.0f);
                this.updateEffect1 = NHFx.circleOut(HyperGenerator.this.effectColor, HyperGenerator.this.lightningRange * 0.75f);
                this.despawnShake = 80.0f;
                this.hitShake = 80.0f;
                this.despawnSound = NHSounds.hugeBlast;
            }

            public void init(Bullet b) {
                super.init(b);
                Units.nearby((Rect)Tmp.r1.setCenter(b.x, b.y).setSize(HyperGenerator.this.lightningRange * 4.0f), unit -> unit.impulse(Tmp.v3.set((Position)unit).sub(b.x, b.y).nor().scl(b.dst((Position)unit) * unit.mass() / 160.0f)));
            }

            @Override
            public void draw(Bullet b) {
                super.draw(b);
                float f = Mathf.curve((float)b.fout(), (float)0.0f, (float)0.15f);
                float f2 = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.1f);
                Draw.color((Color)HyperGenerator.this.effectColor);
                Fill.circle((float)b.x, (float)b.y, (float)((float)(HyperGenerator.this.size * 8) / 3.0f * f));
                for (int i : Mathf.signs) {
                    Drawf.tri((float)b.x, (float)b.y, (float)(HyperGenerator.this.triWidth * f2 * f), (float)(HyperGenerator.this.triLength * 1.3f * f2 * f), (float)((float)((i + 1) * 90) + Time.time * 2.0f));
                    Drawf.tri((float)b.x, (float)b.y, (float)(HyperGenerator.this.triWidth * f2 * f), (float)(HyperGenerator.this.triLength * 1.3f * f2 * f), (float)((float)((i + 1) * 90) - Time.time * 2.0f + 90.0f));
                }
                Draw.color((Color)Color.black);
                Draw.z((float)110.01f);
                Fill.circle((float)b.x, (float)b.y, (float)((float)(HyperGenerator.this.size * 8) / 5.0f * f));
                Draw.z((float)100.0f);
                Drawf.light((Position)b, (float)(HyperGenerator.this.lightningRange * 4.0f * b.fout((Interp)Interp.pow2Out)), (Color)HyperGenerator.this.effectColor, (float)0.75f);
            }

            public void update(Bullet b) {
                float range;
                super.update(b);
                Units.nearby((Rect)Tmp.r1.setCenter(b.x, b.y).setSize(HyperGenerator.this.lightningRange * 3.0f), unit -> unit.impulse(Tmp.v3.set((Position)unit).sub(b.x, b.y).nor().scl(-HyperGenerator.this.attract * 100.0f)));
                if (Mathf.chanceDelta((double)((b.fin() * 3.0f + 1.0f) / 4.0f * 0.65f))) {
                    NHFunc.randFadeLightningEffect(b.x, b.y, HyperGenerator.this.lightningRange * 1.5f, Mathf.random((float)12.0f, (float)20.0f), this.lightningColor, Mathf.chance((double)0.5));
                }
                if (Mathf.chanceDelta((double)0.2)) {
                    this.updateEffect2.at(b.x + Mathf.range((float)((float)(HyperGenerator.this.size * 8) * 0.75f)), b.y + Mathf.range((float)((float)(HyperGenerator.this.size * 8) * 0.75f)));
                }
                if (Mathf.chanceDelta((double)0.075)) {
                    this.updateEffect1.at(b.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), b.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)));
                }
                Effect.shake((float)10.0f, (float)30.0f, (Position)b);
                if (b.timer(3, 8.0f)) {
                    PosLightning.createRange(b, (Position)b, Team.derelict, HyperGenerator.this.lightningRange * 2.0f, 255, HyperGenerator.this.effectColor, true, this.lightningDamage, HyperGenerator.this.subNum + Mathf.random((int)HyperGenerator.this.subNumRand), 2.5f, HyperGenerator.this.updateLightning + Mathf.random((int)HyperGenerator.this.updateLightningRand), (Cons<Position>)((Cons)point -> {
                        NHFx.lightningHitSmall.at(point);
                        Damage.damage((float)point.getX(), (float)point.getY(), (float)this.splashDamageRadius, (float)this.splashDamage);
                    }));
                }
                if (b.timer(4, 5.0f)) {
                    range = (float)(HyperGenerator.this.size * 8) / 1.5f;
                    NHFx.hyperExplode.at(b.x + Mathf.range((float)range), b.y + Mathf.range((float)range), HyperGenerator.this.effectColor);
                    Sounds.explosion.at((Position)b);
                    NHBullets.hyperBlast.create((Entityc)b, Team.derelict, b.x, b.y, (float)Mathf.random((int)360), NHBullets.hyperBlast.damage * HyperGenerator.this.baseExplosiveness, Mathf.random((float)HyperGenerator.this.minVelScl, (float)HyperGenerator.this.maxVelScl), Mathf.random((float)HyperGenerator.this.minTimeScl, (float)HyperGenerator.this.maxTimeScl), new Object());
                }
                if (b.timer(5, 8.0f)) {
                    range = (float)(HyperGenerator.this.size * 8) / 1.5f;
                    NHFx.hitSparkLarge.at(b.x + Mathf.range((float)range), b.y + Mathf.range((float)range), HyperGenerator.this.effectColor);
                    NHBullets.hyperBlastLinker.create((Entityc)b, Team.derelict, b.x, b.y, (float)Mathf.random((int)360), NHBullets.hyperBlast.damage * HyperGenerator.this.baseExplosiveness, Mathf.random((float)HyperGenerator.this.minVelScl, (float)HyperGenerator.this.maxVelScl), Mathf.random((float)HyperGenerator.this.minTimeScl, (float)HyperGenerator.this.maxTimeScl), new Object());
                }
            }

            public void despawned(Bullet b) {
                super.despawned(b);
                Units.nearby((Rect)Tmp.r1.setCenter(b.x, b.y).setSize(HyperGenerator.this.lightningRange * 4.0f), unit -> {
                    unit.vel.set(Tmp.v1.set((Position)unit).sub((Position)b).nor().scl(6.0f));
                    unit.kill();
                });
                for (int i = 0; i < 7; ++i) {
                    Time.run((float)Mathf.random((int)80), () -> {
                        NHFx.hyperExplode.at(b.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), b.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.effectColor);
                        NHFx.hyperCloud.at(b.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), b.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.effectColor);
                        NHFx.circle.at(b.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), b.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.explosionRadius, HyperGenerator.this.effectColor);
                    });
                }
            }
        };
    }

    public void load() {
        super.load();
        this.bottomRegion = Core.atlas.find(this.name + "-bottom");
        this.armorRegion = Core.atlas.find(this.name + "-armor");
        this.gateRegion = Core.atlas.find(this.name + "-gate");
        this.plasmaRegions = new TextureRegion[4];
        for (int index = 0; index < 4; ++index) {
            this.plasmaRegions[index] = Core.atlas.find(this.name + "-plasma-" + index);
        }
    }

    public class HyperGeneratorBuild
    extends PowerGenerator.GeneratorBuild {
        public float progress;
        public float warmup;

        public HyperGeneratorBuild() {
            super((PowerGenerator)HyperGenerator.this);
        }

        public void updateTile() {
            super.updateTile();
            if (this.efficiency > 0.0f) {
                if (this.timer(0, HyperGenerator.this.itemDuration / this.edelta())) {
                    if (this.warmup > HyperGenerator.this.destroyedExplodeLimit) {
                        HyperGenerator.this.workSound.at((Position)this, Mathf.random((float)0.9f, (float)1.1f));
                        NHFx.hyperInstall.at(this.x, this.y, HyperGenerator.this.effectCircleSize / 1.5f * (this.warmup + 0.3f), HyperGenerator.this.effectColor);
                        Effect.shake((float)HyperGenerator.this.workShake, (float)HyperGenerator.this.workShake, (Position)this);
                        if (Mathf.chanceDelta((double)(this.warmup / 2.0f))) {
                            PosLightning.createRandomRange(Team.derelict, (Position)this, HyperGenerator.this.lightningRange, HyperGenerator.this.effectColor, true, HyperGenerator.this.lightningDamage * Math.max(Mathf.curve((float)(1.0f - this.health / this.maxHealth()), (float)HyperGenerator.this.structureLim, (float)1.0f) + HyperGenerator.this.beginDamageScl, 0.001f), HyperGenerator.this.lightningLen + Mathf.random((int)HyperGenerator.this.lightningLenRand), 2.5f, HyperGenerator.this.subNum + Mathf.random((int)HyperGenerator.this.subNumRand), HyperGenerator.this.updateLightning + Mathf.random((int)HyperGenerator.this.updateLightningRand), (Cons<Position>)((Cons)point -> NHFx.lightningHitLarge.at(point.getX(), point.getY(), HyperGenerator.this.effectColor)));
                        }
                        if (this.optionalEfficiency > 0.0f) {
                            Units.nearby((Team)this.team, (float)this.x, (float)this.y, (float)HyperGenerator.this.statusRange, u -> {
                                Fx.chainLightning.at(this.x, this.y, 0.0f, HyperGenerator.this.effectColor, u);
                                HyperGenerator.this.toApplyStatus.each(s -> u.apply(s, HyperGenerator.this.statusDuration));
                                u.healFract(2.5f);
                            });
                        }
                    }
                    this.consume();
                }
                this.progress += this.efficiency * Time.delta;
                this.warmup = Mathf.equal((float)this.warmup, (float)1.0f, (float)0.0015f) ? 1.0f : Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)(HyperGenerator.this.warmupSpeed + (float)Mathf.num((boolean)Vars.net.active()) * 0.025f));
            } else {
                this.warmup = Mathf.equal((float)this.warmup, (float)0.0f, (float)0.0015f) ? 0.0f : Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)HyperGenerator.this.disabledSpeed);
            }
            this.productionEfficiency = Mathf.pow((float)this.warmup, (float)5.0f);
            if (this.warmup > 0.075f) {
                for (int i : Mathf.signs) {
                    if (!Mathf.chance((double)(this.warmup / HyperGenerator.this.updateEffectDiv))) continue;
                    HyperGenerator.this.updateEffect.at(this.x + (float)i * Mathf.random((float)HyperGenerator.this.effectCircleSize), this.y + (float)i * Mathf.random((float)HyperGenerator.this.effectCircleSize), HyperGenerator.this.updateEffectSize * this.warmup, HyperGenerator.this.effectColor);
                }
                if (Mathf.chanceDelta((double)(Mathf.curve((float)(1.0f - this.health / this.maxHealth()), (float)HyperGenerator.this.structureLim, (float)1.0f) / 25.0f))) {
                    PosLightning.createRandomRange(Team.derelict, (Position)this, HyperGenerator.this.lightningRange, HyperGenerator.this.effectColor, true, HyperGenerator.this.lightningDamage * (Mathf.curve((float)(1.0f - this.health / this.maxHealth()), (float)HyperGenerator.this.structureLim, (float)1.0f) + HyperGenerator.this.beginDamageScl), HyperGenerator.this.lightningLen + Mathf.random((int)HyperGenerator.this.lightningLenRand), 2.5f, HyperGenerator.this.subNum + Mathf.random((int)HyperGenerator.this.subNumRand), HyperGenerator.this.updateLightning + Mathf.random((int)HyperGenerator.this.updateLightningRand), (Cons<Position>)((Cons)point -> NHFx.lightningHitLarge.at(point.getX(), point.getY(), HyperGenerator.this.effectColor)));
                }
                if (Mathf.chanceDelta((double)(this.warmup / HyperGenerator.this.updateEffectDiv * 1.5f))) {
                    HyperGenerator.this.workEffect.at(this.x, this.y, HyperGenerator.this.updateEffectSize * 3.0f * this.warmup, HyperGenerator.this.effectColor);
                }
                if (Mathf.chanceDelta((double)(this.warmup / HyperGenerator.this.updateEffectDiv * 3.0f))) {
                    Tmp.v1.rnd((float)(HyperGenerator.this.size * 8) * this.warmup * 0.9f).add((Position)this.tile);
                    NHFx.chainLightningFade.at(this.x, this.y, 12.0f, HyperGenerator.this.effectColor, (Object)Tmp.v1.cpy());
                }
                if (Mathf.chanceDelta((double)(this.warmup / HyperGenerator.this.updateEffectDiv * 2.0f))) {
                    Tmp.v1.rnd((float)(HyperGenerator.this.size * 8) * this.warmup * 1.5f).add((Position)this.tile);
                    NHFx.chainLightningFadeReversed.at(this.x, this.y, 12.0f, HyperGenerator.this.effectColor, (Object)Tmp.v1.cpy());
                }
            }
        }

        public void draw() {
            int i;
            super.draw();
            Color drawColor = Tmp.c1.set(HyperGenerator.this.effectColor).lerp(Color.white, Mathf.absin((float)(Time.time * 1.3f), (float)1.0f, (float)0.08f));
            Draw.rect((TextureRegion)HyperGenerator.this.bottomRegion, (float)this.x, (float)this.y);
            for (i = 0; i < HyperGenerator.this.plasmaRegions.length; ++i) {
                float r = ((float)(HyperGenerator.this.size * 8) - 3.0f + Mathf.absin((float)Time.time, (float)(2.0f + (float)i), (float)(5.0f - (float)i * 0.5f))) * HyperGenerator.this.plasmaScl;
                Draw.color((Color)HyperGenerator.this.effectColor, (Color)drawColor, (float)(i / HyperGenerator.this.plasmaRegions.length));
                Draw.alpha((float)((0.25f + Mathf.absin((float)Time.time, (float)(2.0f + (float)i * 2.0f), (float)(0.3f + (float)i * 0.05f))) * this.warmup));
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)HyperGenerator.this.plasmaRegions[i], (float)this.x, (float)this.y, (float)r, (float)r, (float)(Time.time * (12.0f + (float)i * 6.0f) * this.warmup));
                Draw.blend();
            }
            Draw.color();
            for (i = 0; i < 4; ++i) {
                for (int j : Mathf.signs) {
                    Tmp.v1.trns((float)(90 * i + 45), (float)(-(1 - j) * HyperGenerator.this.size * 8) * Draw.scl * Mathf.sqrt2);
                    Tmp.v2.trns((float)(90 * i - 45), -HyperGenerator.this.gateSize * (float)j * this.warmup).add(Tmp.v1);
                    TextureRegion gate = new TextureRegion(HyperGenerator.this.gateRegion);
                    gate.flip(j < 0, j < 0);
                    Draw.rect((TextureRegion)gate, (float)(this.x + Tmp.v2.x), (float)(this.y + Tmp.v2.y), (float)(i * 90));
                }
            }
            Draw.rect((TextureRegion)HyperGenerator.this.region, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)HyperGenerator.this.armorRegion, (float)this.x, (float)this.y);
            if (this.warmup > 0.075f) {
                float drawSin = (1.0f + Mathf.absin((float)this.progress, (float)(HyperGenerator.this.effectSinScl * 2.0f), (float)(HyperGenerator.this.effectSinMag * 1.1f))) * this.warmup;
                float drawSin2 = (1.0f + Mathf.absin((float)this.progress, (float)HyperGenerator.this.effectSinScl, (float)HyperGenerator.this.effectSinMag)) * this.warmup;
                float drawSin3 = (1.0f + Mathf.absin((float)(this.progress + HyperGenerator.this.effectSinScl / 2.0f), (float)HyperGenerator.this.effectSinScl, (float)HyperGenerator.this.effectSinMag)) * this.warmup;
                Draw.z((float)109.0f);
                Draw.color((Color)drawColor);
                Fill.circle((float)this.x, (float)this.y, (float)(HyperGenerator.this.effectCircleSize * drawSin));
                for (int i2 : Mathf.signs) {
                    Drawf.tri((float)this.x, (float)this.y, (float)(HyperGenerator.this.triWidth * this.warmup), (float)(HyperGenerator.this.triLength * drawSin2), (float)((float)((i2 + 1) * 90) + this.progress));
                    Drawf.tri((float)this.x, (float)this.y, (float)(HyperGenerator.this.triWidth * this.warmup * 0.8f), (float)(HyperGenerator.this.triLength * drawSin3 * 0.8f), (float)((float)((i2 + 1) * 90) - this.progress * 1.1f + 90.0f));
                }
                Lines.stroke((float)(this.warmup * HyperGenerator.this.triWidth * 0.55f));
                DrawFunc.circlePercentFlip(this.x, this.y, (float)(HyperGenerator.this.size * 8) * 0.85f * (1.0f + Mathf.absin((float)(this.progress * 2.0f), (float)24.0f, (float)0.125f)) * this.warmup, this.progress * 0.85f, 30.0f);
                Lines.stroke((float)(this.warmup * HyperGenerator.this.triWidth * 0.35f));
                DrawFunc.circlePercentFlip(this.x, this.y, (float)(HyperGenerator.this.size * 8) * 1.1f * (1.0f + Mathf.absin((float)(this.progress * 1.25f), (float)24.0f, (float)0.125f)) * this.warmup, this.progress * 0.95f + 5.0f, 45.0f);
            }
            Draw.reset();
            Drawf.light((Position)this.tile, (float)((float)(HyperGenerator.this.size * 8 * 4) * this.warmup), (Color)HyperGenerator.this.effectColor, (float)0.95f);
        }

        public void onDestroyed() {
            int i;
            super.onDestroyed();
            if (this.warmup < HyperGenerator.this.destroyedExplodeLimit) {
                return;
            }
            HyperGenerator.this.explodeAction.get((Object)this);
            HyperGenerator.this.destroyed.create((Entityc)this, Team.derelict, this.x, this.y, 0.0f);
            for (i = 0; i < 30; ++i) {
                Time.run((float)Mathf.random((float)80.0f), () -> {
                    HyperGenerator.this.explodeSub.get((Object)this);
                    Sounds.explosion.at((Position)this);
                });
            }
            for (i = 0; i < 10; ++i) {
                Time.run((float)((float)i * (3.0f + Mathf.random((float)2.0f))), () -> {
                    HyperGenerator.this.explodeSub.get((Object)this);
                    Sounds.explosion.at((Position)this);
                    PosLightning.createRandomRange(Team.derelict, (Position)this, HyperGenerator.this.lightningRange * 3.0f, HyperGenerator.this.effectColor, true, HyperGenerator.this.lightningDamage, HyperGenerator.this.lightningLen + Mathf.random((int)HyperGenerator.this.lightningLenRand), 2.5f, HyperGenerator.this.subNum + Mathf.random((int)HyperGenerator.this.subNumRand), HyperGenerator.this.updateLightning + Mathf.random((int)HyperGenerator.this.updateLightningRand), (Cons<Position>)((Cons)point -> NHFx.lightningHitLarge.at(point.getX(), point.getY(), HyperGenerator.this.effectColor)));
                });
            }
            Sounds.explosion.at((Position)this);
            Effect.shake((float)6.0f, (float)16.0f, (float)this.x, (float)this.y);
            for (i = 0; i < 7; ++i) {
                Time.run((float)Mathf.random((int)80), () -> {
                    NHFx.hyperExplode.at(this.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), this.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.effectColor);
                    NHFx.hyperCloud.at(this.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), this.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.effectColor);
                    NHFx.circle.at(this.x + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), this.y + (float)Mathf.range((int)(HyperGenerator.this.size * 8)), HyperGenerator.this.explosionRadius, HyperGenerator.this.effectColor);
                });
            }
            Damage.damage((float)this.x, (float)this.y, (float)HyperGenerator.this.explosionRadius, (float)HyperGenerator.this.explosionDamage);
        }

        public float ambientVolume() {
            return this.warmup;
        }

        public void drawLight() {
            Drawf.light((float)this.x, (float)this.y, (float)((110.0f + Mathf.absin((float)5.0f, (float)5.0f)) * this.warmup), (Color)HyperGenerator.this.effectColor, (float)(0.8f * this.warmup));
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)HyperGenerator.this.statusRange, (Color)this.team.color);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.warmup = read.f();
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.warmup);
        }
    }
}

