/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.gen.Posc;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import newhorizon.expand.type.Device;
import newhorizon.expand.type.DeviceData;
import newhorizon.util.func.MathUtil;

public class DeviceBase
extends Block {
    public DeviceBase(String name) {
        super(name);
        this.size = 2;
        this.update = true;
        this.solid = true;
        this.destructible = true;
        this.rotate = true;
        this.hasItems = false;
        this.hasLiquids = false;
        this.hasPower = false;
        this.canOverdrive = false;
        this.drawDisabled = false;
        this.configurable = true;
        this.saveConfig = true;
    }

    public class DeviceBaseBuild
    extends Building {
        public Seq<DeviceData> targets = new Seq();
        public Seq<Device> devices = Seq.with((Object[])new Device[0]);

        public void updateTile() {
            super.updateTile();
            this.updateTargets();
            this.targets.each(target -> this.devices.each(device -> device.applyBuilding(this, (DeviceData)target, 1.0f)));
        }

        public void updateTargets() {
            this.targets.clear();
            if (this.front() != null) {
                this.targets.add((Object)new DeviceData(this.front(), 0.0f));
            }
        }

        public void buildConfiguration(Table table) {
        }

        public void drawSelect() {
            super.drawSelect();
            Draw.z((float)35.01f);
            Draw.color((Color)Pal.gray);
            Lines.stroke((float)3.0f);
            Lines.square((float)this.x, (float)this.y, (float)((float)(DeviceBase.this.size * 8) / 2.0f - 1.5f));
            for (DeviceData target : this.targets) {
                Building b = target.building;
                if (b == null) continue;
                Tmp.v1.set(Geometry.raycastRect((float)b.x, (float)b.y, (float)this.x, (float)this.y, (Rect)Tmp.r1.setCentered(this.x, this.y, (float)(DeviceBase.this.size * 8)).grow(-5.0f)));
                Tmp.v2.trns(MathUtil.angle((Posc)b, (Posc)this), (float)(b.block.size * 8) / 2.0f - 2.5f).add((Position)b);
                Draw.z((float)35.01f);
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)3.0f);
                Lines.circle((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f - 2.5f));
                Draw.z((float)35.01f);
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)3.0f);
                Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
                Draw.z((float)35.02f);
                Draw.color((Color)Pal.accent);
                Lines.stroke((float)1.0f);
                Lines.circle((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f - 2.5f));
                Draw.z((float)35.02f);
                Draw.color((Color)Pal.accent);
                Lines.stroke((float)1.0f);
                Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
            }
            Draw.z((float)35.02f);
            Draw.color((Color)Pal.accent);
            Lines.stroke((float)1.0f);
            Lines.square((float)this.x, (float)this.y, (float)((float)(DeviceBase.this.size * 8) / 2.0f - 2.5f));
        }
    }
}

