/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.CharacterOverlay;

public class CharacterDisplay
extends Block {
    public TextureRegion maskRegion;
    public TextureRegion[] letterRegions;
    public String queueText = "";

    public CharacterDisplay(String name) {
        super(name);
        this.size = 2;
        this.sync = true;
        this.update = true;
        this.rotate = false;
        this.saveConfig = true;
        this.configurable = true;
        this.logicConfigurable = true;
        this.selectionColumns = 8;
        this.selectionRows = 8;
        this.config(Integer.class, (build, color) -> {
            build.displayColor = color;
        });
        this.config(Integer[].class, (build, character) -> {
            try {
                build.displayColor = character[0];
                build.displayCharacter = character[1];
            }
            catch (Exception e) {
                Log.err((Throwable)e);
            }
        });
        this.config(String.class, (build, packed) -> {
            String[] split = packed.split("@");
            try {
                build.displayColor = Strings.parseInt((String)split[0]);
                build.displayCharacter = Strings.parseInt((String)split[1]);
            }
            catch (Exception e) {
                Log.err((Throwable)e);
            }
        });
        this.configClear(build -> {
            build.displayCharacter = -1;
            build.displayColor = Color.white.rgba();
        });
    }

    public void placeEnded(Tile tile, Unit builder, int rotation, Object config) {
        if (tile.build != null) {
            if (this.queueText.isEmpty()) {
                return;
            }
            if (config instanceof String) {
                String conf = (String)config;
                try {
                    String[] split = conf.split("@");
                    split[1] = CharacterOverlay.charToData((char)this.queueText.charAt(0)) + "";
                    tile.build.configure((Object)(split[0] + "@" + split[1]));
                }
                catch (Exception e) {
                    Log.err((Throwable)e);
                }
            }
            this.queueText = this.queueText.substring(1);
        }
    }

    public void load() {
        super.load();
        this.maskRegion = Core.atlas.find(this.name + "-mask");
        this.letterRegions = new TextureRegion[64];
        for (int i = 0; i < 64; ++i) {
            this.letterRegions[i] = Core.atlas.find("character-overlay" + i);
        }
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        Object object = plan.config;
        if (object instanceof UnlockableContent) {
            UnlockableContent content = (UnlockableContent)object;
            Draw.rect((TextureRegion)content.uiIcon, (float)plan.drawx(), (float)plan.drawy());
        }
    }

    public class SpriteDisplayBuild
    extends Building {
        public int displayCharacter;
        public int displayColor = Color.white.rgba();

        public void buildConfiguration(Table table) {
            ButtonGroup group = new ButtonGroup();
            group.setMinCheckCount(0);
            group.clear();
            Table color = new Table();
            color.table(input -> {
                TextField text = new TextField(CharacterDisplay.this.queueText);
                text.update(() -> {
                    CharacterDisplay.this.queueText = text.getText();
                });
                input.add((Element)text).growX();
                input.button((Drawable)Icon.pick, Styles.clearNonei, () -> Vars.ui.picker.show(Tmp.c1.set(this.displayColor), c -> this.configure(c.rgba() + "@" + this.displayCharacter)));
            }).growX().row();
            Table cont = new Table().top();
            cont.defaults().size(40.0f);
            cont.clearChildren();
            int i = 0;
            for (int region = 0; region < CharacterDisplay.this.letterRegions.length; ++region) {
                int finalRegion = region;
                TextureRegion character = CharacterDisplay.this.letterRegions[region];
                ImageButton button = (ImageButton)cont.button(Tex.whiteui, Styles.clearNoneTogglei, (float)(character.width + character.height) / 2.0f, () -> Vars.control.input.config.hideConfig()).group(group).get();
                button.changed(() -> this.configure(this.displayColor + "@" + (button.isChecked() ? finalRegion : -1)));
                button.getStyle().imageUp = new TextureRegionDrawable(character);
                button.update(() -> button.setChecked(this.displayCharacter == finalRegion));
                if (i++ % 8 != 7) continue;
                cont.row();
            }
            Table main = new Table(Styles.black6);
            main.add((Element)color).growX().row();
            main.add((Element)cont).maxHeight(320.0f);
            table.top().add((Element)main);
        }

        public String config() {
            return this.displayColor + "@" + this.displayCharacter;
        }

        public void draw() {
            Draw.rect((TextureRegion)CharacterDisplay.this.region, (float)this.x, (float)this.y);
            Tmp.c1.set(this.displayColor);
            if (this.displayCharacter >= 0 && this.displayCharacter < CharacterDisplay.this.letterRegions.length) {
                Draw.z((float)35.0f);
                Draw.rect((TextureRegion)CharacterDisplay.this.maskRegion, (float)this.x, (float)this.y);
                TextureRegion character = CharacterDisplay.this.letterRegions[this.displayCharacter];
                Draw.color((Color)Tmp.c1);
                Draw.rect((TextureRegion)character, (float)this.x, (float)this.y, (float)((float)character.width * 0.16f * (float)CharacterDisplay.this.size), (float)((float)character.height * 0.16f * (float)CharacterDisplay.this.size));
            }
            Draw.reset();
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.displayCharacter);
            write.i(this.displayColor);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.displayCharacter = read.i();
            this.displayColor = read.i();
        }
    }
}

