/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.concurrent.atomic.AtomicBoolean;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.StatUnit;
import newhorizon.NHGroups;
import newhorizon.content.NHStats;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.expand.block.special.AdaptOverdriveProjector;
import newhorizon.util.graphic.DrawFunc;

public class AssignedBeacon
extends AdaptOverdriveProjector {
    public int maxLink = 4;

    public AssignedBeacon(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.configurable = true;
        this.saveConfig = true;
        this.copyConfig = true;
        this.canOverdrive = false;
        this.schematicPriority = -30;
        this.size = 3;
        this.config(Integer.class, AssignedBeaconBuild::handleLink);
        this.config(Point2[].class, (entity, data) -> {
            for (Point2 p : data) {
                entity.handleLink(Point2.pack((int)(p.x + entity.tileX()), (int)(p.y + entity.tileY())));
            }
        });
        this.configClear(entity -> entity.linkBuilds.clear());
    }

    public void setBars() {
        super.setBars();
        this.removeBar("boost");
        this.addBar("productivity", e -> new Bar(() -> Core.bundle.format("nh.bar.productivity-boost", new Object[]{Strings.autoFixed((float)(e.realBoost() * 100.0f), (int)0)}), () -> Pal.ammo, () -> 1.0f));
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
        Drawf.dashRect((Color)this.baseColor, (float)((float)(x * 8) + this.offset - this.range / 2.0f), (float)((float)(y * 8) + this.offset - this.range / 2.0f), (float)this.range, (float)this.range);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.maxLinks, (float)this.maxLink, StatUnit.none);
    }

    public class AssignedBeaconBuild
    extends AdaptOverdriveProjector.AdaptOverdriveProjectorBuild {
        public ObjectFloatMap<Building> linkBuilds = new ObjectFloatMap();
        public float[] buffer;

        @Override
        public void updateTile() {
            if (this.buffer != null) {
                for (int i = 0; i < this.buffer.length; i += 2) {
                    Building b = Vars.world.build((int)this.buffer[i]);
                    if (b == null) continue;
                    this.linkBuilds.put((Object)b, this.buffer[i + 1]);
                }
                this.buffer = null;
            }
            this.smoothEfficiency = Mathf.lerpDelta((float)this.smoothEfficiency, (float)this.efficiency, (float)0.08f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)(this.efficiency > 0.0f ? 1.0f : 0.0f), (float)0.08f);
            if (AssignedBeacon.this.hasBoost) {
                this.phaseHeat = Mathf.lerpDelta((float)this.phaseHeat, (float)this.optionalEfficiency, (float)0.1f);
            }
            if (this.efficiency > 0.0f) {
                this.useProgress += this.delta();
            }
            if (this.useProgress >= AssignedBeacon.this.useTime) {
                this.consume();
                this.useProgress %= AssignedBeacon.this.useTime;
            }
            this.checkLinks();
            this.updateLink();
        }

        public Seq<Building> linkBuilds() {
            return this.linkBuilds.keys().toArray();
        }

        public void updateLink() {
            this.linkBuilds().each(b -> {
                block6: {
                    float progress;
                    block7: {
                        block9: {
                            GenericCrafter.GenericCrafterBuild build;
                            GenericCrafter crafter;
                            block8: {
                                progress = this.linkBuilds.get(b, 0.0f);
                                Block patt3914$temp = b.block;
                                if (!(patt3914$temp instanceof GenericCrafter)) break block6;
                                crafter = (GenericCrafter)patt3914$temp;
                                if (!(b instanceof GenericCrafter.GenericCrafterBuild)) break block6;
                                build = (GenericCrafter.GenericCrafterBuild)b;
                                if (!((progress += this.getProgressIncrease(crafter.craftTime / this.realBoost() / this.efficiency) * build.efficiency * build.timeScale()) >= 1.0f)) break block7;
                                Block patt4222$temp = b.block;
                                if (!(patt4222$temp instanceof RecipeGenericCrafter)) break block8;
                                RecipeGenericCrafter crafter1 = (RecipeGenericCrafter)patt4222$temp;
                                if (!(b instanceof RecipeGenericCrafter.RecipeGenericCrafterBuild)) break block8;
                                RecipeGenericCrafter.RecipeGenericCrafterBuild build1 = (RecipeGenericCrafter.RecipeGenericCrafterBuild)b;
                                if (build1.getRecipe() == null) break block9;
                                if (crafter1.outputItems != null) {
                                    for (ItemStack itemStack : crafter1.outputItems) {
                                        build.items.add(itemStack.item, itemStack.amount);
                                    }
                                }
                                if (crafter1.outputPayloads != null) {
                                    for (ItemStack itemStack : crafter1.outputPayloads) {
                                        build.getPayloads().add(itemStack.item, itemStack.amount);
                                    }
                                }
                                break block9;
                            }
                            if (crafter.outputItems != null) {
                                for (ItemStack itemStack : crafter.outputItems) {
                                    build.items.add(itemStack.item, itemStack.amount);
                                }
                            }
                        }
                        progress %= 1.0f;
                    }
                    this.linkBuilds.put(b, progress);
                }
            });
        }

        public Point2[] config() {
            Point2[] out = new Point2[this.linkBuilds.size];
            for (int i = 0; i < this.linkBuilds.size; ++i) {
                out[i] = new Point2(((Building)this.linkBuilds().get(i)).tileX() - this.tileX(), ((Building)this.linkBuilds().get(i)).tileY() - this.tileY());
            }
            return out;
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (other != null && this.linkValid(other) && !this.containBuild(other)) {
                this.configure(other.pos());
                return false;
            }
            return true;
        }

        public boolean linkValid(Building b) {
            return b != null && b.isValid() && Math.abs(b.x - this.x) <= this.range() / 2.0f && Math.abs(b.y - this.y) <= this.range() / 2.0f && b.team == this.team && b.block.canOverdrive;
        }

        public boolean containBuild(Building b) {
            AtomicBoolean contains = new AtomicBoolean(false);
            NHGroups.beaconBoostLinks.each((source, targets) -> {
                if (source != this && targets.contains(target -> target == b)) {
                    contains.set(true);
                }
            });
            return contains.get();
        }

        public void handleLink(int value) {
            Building other = Vars.world.build(value);
            if (other != null && this.linkValid(other) && !this.containBuild(other)) {
                if (this.linkBuilds().contains((Object)other)) {
                    this.linkBuilds.remove((Object)other, 0.0f);
                } else {
                    if (this.linkBuilds.size >= AssignedBeacon.this.maxLink) {
                        return;
                    }
                    this.linkBuilds.put((Object)other, 0.0f);
                }
            }
        }

        public void drawConfigure() {
            Drawf.dashSquare((Color)Pal.accent, (float)this.x, (float)this.y, (float)this.range());
            NHGroups.beaconBoostLinks.keys().toSeq().each(b -> {
                if (b instanceof AssignedBeaconBuild) {
                    AssignedBeaconBuild build = (AssignedBeaconBuild)((Object)b);
                    build.drawConnect();
                }
            });
        }

        public void drawConnect() {
            Draw.z((float)35.0f);
            Draw.color((Color)AssignedBeacon.this.baseColor);
            Draw.alpha((float)0.3f);
            Fill.square((float)this.x, (float)this.y, (float)((float)(AssignedBeacon.this.size * 8) / 2.0f));
            Draw.z((float)35.01f);
            Draw.color((Color)AssignedBeacon.this.baseColor);
            Lines.stroke((float)1.5f);
            Lines.square((float)this.x, (float)this.y, (float)((float)(AssignedBeacon.this.size * 8) / 2.0f + 0.5f));
            for (Building b : this.linkBuilds()) {
                if (b == null) continue;
                Tmp.v1.set(Geometry.raycastRect((float)b.x, (float)b.y, (float)this.x, (float)this.y, (Rect)Tmp.r1.setCentered(this.x, this.y, (float)(AssignedBeacon.this.size * 8))));
                Tmp.v2.set(Geometry.raycastRect((float)this.x, (float)this.y, (float)b.x, (float)b.y, (Rect)Tmp.r1.setCentered(b.x, b.y, (float)(b.block.size * 8))));
                Draw.z((float)35.0f);
                Draw.color((Color)AssignedBeacon.this.baseColor);
                Draw.alpha((float)0.3f);
                Fill.square((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f));
                Draw.z((float)35.01f);
                Draw.color((Color)AssignedBeacon.this.baseColor);
                Lines.stroke((float)1.0f);
                Lines.square((float)b.x, (float)b.y, (float)((float)(b.block.size * 8) / 2.0f + 0.5f));
                Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
                float progress = this.linkBuilds.get((Object)b, 0.0f);
                if (!(progress > 0.001f)) continue;
                DrawFunc.circlePercent(b.x, b.y, (float)(b.block.size * 8) * 0.375f, this.linkBuilds.get((Object)b, 0.0f), 0.0f);
            }
        }

        public void checkLinks() {
            while (this.linkBuilds.size > AssignedBeacon.this.maxLink) {
                this.linkBuilds.remove((Object)((Building)this.linkBuilds().pop()), 0.0f);
            }
            for (Building b : this.linkBuilds()) {
                if (this.linkValid(b)) continue;
                this.linkBuilds.remove((Object)b, 0.0f);
            }
            NHGroups.beaconBoostLinks.put((Object)this, this.linkBuilds());
        }

        public void remove() {
            super.remove();
            NHGroups.beaconBoostLinks.remove((Object)this);
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.linkBuilds.size);
            this.linkBuilds.each(buildingEntry -> {
                write.i(((Building)buildingEntry.key).pos());
                write.f(buildingEntry.value);
            });
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 2) {
                int size = read.i();
                this.buffer = new float[size * 2];
                for (int i = 0; i < size; ++i) {
                    int pos = read.i();
                    float value = read.f();
                    this.buffer[i * 2] = pos;
                    this.buffer[i * 2 + 1] = value;
                }
            }
        }
    }
}

