/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.factory;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.input.Placement;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.expand.block.inner.LinkBlock;
import newhorizon.expand.block.production.factory.MultiBlock;
import newhorizon.expand.block.production.factory.MultiBlockEntity;

public class AdaptCrafter
extends GenericCrafter
implements MultiBlock {
    public ObjectSet<UnlockableContent> payloadFilter = new ObjectSet();
    public Seq<Point2> linkPos = new Seq();
    public IntSeq linkSize = new IntSeq();
    public boolean canMirror = true;
    public int[] rotations = new int[]{0, 1, 2, 3, 0, 1, 2, 3};
    public float powerProduction = 0.0f;
    public int payloadCapacity = 10;
    public PayloadStack[] outputPayloads;

    public AdaptCrafter(String name) {
        super(name);
        this.hasItems = true;
        this.hasLiquids = true;
        this.hasPower = true;
        this.acceptsPayload = true;
        this.outputsPayload = true;
        this.rotate = true;
        this.rotateDraw = true;
        this.quickRotate = false;
        this.allowDiagonal = false;
    }

    public void init() {
        super.init();
        if (this.powerProduction > 0.0f) {
            this.consumesPower = false;
        }
    }

    public void setBars() {
        super.setBars();
        if (this.hasPower && this.outputsPower && this.powerProduction > 0.0f) {
            this.removeBar("power");
            this.addBar("power", entity -> new Bar(() -> Core.bundle.format("bar.poweroutput", new Object[]{Strings.fixed((float)(entity.getPowerProduction() * 60.0f * entity.timeScale()), (int)1)}), () -> Pal.powerBar, () -> entity.warmup));
        }
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.size);
        this.stats.add(Stat.size, "@x@", new Object[]{this.getMaxSize((int)this.size, (int)0).x, this.getMaxSize((int)this.size, (int)0).y});
        if (this.powerProduction > 0.0f) {
            this.stats.remove(Stat.powerUse);
            this.stats.add(Stat.basePowerGeneration, this.powerProduction * 60.0f, StatUnit.powerSecond);
        }
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return super.canPlaceOn(tile, team, rotation) && this.checkLink(tile, team, this.size, rotation);
    }

    public void placeBegan(Tile tile, Block previous) {
        this.createPlaceholder(tile, this.size);
    }

    public void changePlacementPath(Seq<Point2> points, int rotation) {
        Placement.calculateNodes(points, (Block)this, (int)rotation, (point, other) -> {
            if (rotation % 2 == 0) {
                return Math.abs(point.x - other.x) == this.getMaxSize((int)this.size, (int)rotation).x;
            }
            return Math.abs(point.y - other.y) == this.getMaxSize((int)this.size, (int)rotation).y;
        });
    }

    @Override
    public Seq<Point2> linkBlockPos() {
        return this.linkPos;
    }

    @Override
    public IntSeq linkBlockSize() {
        return this.linkSize;
    }

    @Override
    public Block mirrorBlock() {
        return this;
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    public void loadIcon() {
        super.loadIcon();
        this.uiIcon = Core.atlas.find(this.name + "-icon", this.name);
    }

    public TextureRegion[] getGeneratedIcons() {
        return super.getGeneratedIcons();
    }

    public void flipRotation(BuildPlan req, boolean x) {
        if (this.canMirror) {
            if (this.mirrorBlock() != null) {
                req.rotation = this.rotations[req.rotation + (x ? 0 : 4)];
            }
        } else {
            super.flipRotation(req, x);
        }
    }

    public class AdaptCrafterBuild
    extends GenericCrafter.GenericCrafterBuild
    implements MultiBlockEntity {
        public boolean linkCreated;
        public Seq<Building> linkEntities;
        public Seq<Building[]> linkProximityMap;
        public int dumpIndex;
        public Tile teamPos;
        public Tile statusPos;
        public PayloadSeq payloads;

        public AdaptCrafterBuild() {
            super((GenericCrafter)AdaptCrafter.this);
            this.linkCreated = false;
            this.dumpIndex = 0;
            this.payloads = new PayloadSeq();
        }

        public PayloadSeq getPayloads() {
            return this.payloads;
        }

        /*
         * WARNING - void declaration
         */
        public boolean shouldConsume() {
            if (AdaptCrafter.this.outputItems != null) {
                for (ItemStack itemStack : AdaptCrafter.this.outputItems) {
                    if (this.items.get(itemStack.item) + itemStack.amount <= AdaptCrafter.this.itemCapacity) continue;
                    return AdaptCrafter.this.powerProduction > 0.0f;
                }
            }
            if (AdaptCrafter.this.outputPayloads != null) {
                for (ItemStack itemStack : AdaptCrafter.this.outputPayloads) {
                    if (this.getPayloads().get(itemStack.item) + itemStack.amount <= AdaptCrafter.this.payloadCapacity) continue;
                    return AdaptCrafter.this.powerProduction > 0.0f;
                }
            }
            if (AdaptCrafter.this.outputLiquids != null && !AdaptCrafter.this.ignoreLiquidFullness) {
                void var4_10;
                boolean allFull = true;
                LiquidStack[] liquidStackArray = AdaptCrafter.this.outputLiquids;
                int n = liquidStackArray.length;
                boolean bl = false;
                while (var4_10 < n) {
                    LiquidStack output = liquidStackArray[var4_10];
                    if (this.liquids.get(output.liquid) >= AdaptCrafter.this.liquidCapacity - 0.001f) {
                        if (!AdaptCrafter.this.dumpExtraLiquid) {
                            return false;
                        }
                    } else {
                        allFull = false;
                    }
                    ++var4_10;
                }
                if (allFull) {
                    return false;
                }
            }
            return this.enabled;
        }

        public float getPowerProduction() {
            return AdaptCrafter.this.powerProduction * this.warmup * this.efficiency;
        }

        public void created() {
            super.created();
            this.linkProximityMap = new Seq();
            if (AdaptCrafter.this.instantBuild || !Vars.state.rules.editor && Vars.state.rules.instantBuild && Vars.state.rules.infiniteResources) {
                this.linkEntities = AdaptCrafter.this.setLinkBuild((Building)this, this.block, this.tile, this.team, AdaptCrafter.this.size, this.rotation);
                this.linkCreated = true;
                this.updateLinkProximity();
            }
        }

        public void updateTile() {
            if (this.isPayload()) {
                return;
            }
            if (!this.linkCreated) {
                this.linkEntities = AdaptCrafter.this.setLinkBuild((Building)this, this.block, this.tile, this.team, AdaptCrafter.this.size, this.rotation);
                this.linkCreated = true;
                this.updateLinkProximity();
            }
            if (this.timer(0, 600.0f)) {
                boolean linkValid = true;
                for (Tile t : AdaptCrafter.this.getLinkTiles(this.tile, AdaptCrafter.this.size, this.rotation)) {
                    Building building = t.build;
                    if (building instanceof LinkBlock.LinkBuild) {
                        LinkBlock.LinkBuild lb = (LinkBlock.LinkBuild)building;
                        if (lb.linkBuild == this && lb.isValid()) continue;
                    }
                    linkValid = false;
                    break;
                }
                if (!linkValid) {
                    this.linkEntities.each(Building::kill);
                    this.kill();
                }
            }
            super.updateTile();
        }

        public void craft() {
            super.craft();
            if (AdaptCrafter.this.outputPayloads != null) {
                for (PayloadStack output : AdaptCrafter.this.outputPayloads) {
                    this.payloads.add(output.item, output.amount);
                }
            }
        }

        public void incrementDumpIndex(int prox) {
            this.dumpIndex = (this.dumpIndex + 1) % prox;
        }

        public void handlePayload(Building source, Payload payload) {
            this.payloads.add(payload.content(), 1);
            Fx.payloadDeposit.at(payload.x(), payload.y(), payload.angleTo((Position)this), (Object)new UnitAssembler.YeetData(new Vec2(this.x, this.y), payload.content()));
        }

        public boolean dump(Item todump) {
            if (!this.block.hasItems || this.items.total() == 0 || this.linkProximityMap.size == 0 || todump != null && !this.items.has(todump)) {
                return false;
            }
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (todump == null) {
                    for (int ii = 0; ii < Vars.content.items().size; ++ii) {
                        Item item;
                        if (!this.items.has(ii) || !target.acceptItem(source, item = (Item)Vars.content.items().get(ii)) || !this.canDump(target, item)) continue;
                        target.handleItem(source, item);
                        this.items.remove(item, 1);
                        this.incrementDumpIndex(this.linkProximityMap.size);
                        return true;
                    }
                } else if (target.acceptItem(source, todump) && this.canDump(target, todump)) {
                    target.handleItem(source, todump);
                    this.items.remove(todump, 1);
                    this.incrementDumpIndex(this.linkProximityMap.size);
                    return true;
                }
                this.incrementDumpIndex(this.linkProximityMap.size);
            }
            return false;
        }

        public boolean dumpPayload(Payload todump) {
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (todump != null && this.getPayloads().get(todump.content()) > 0 && target.acceptPayload(source, todump)) {
                    target.handlePayload((Building)this, todump);
                    this.getPayloads().remove(todump.content(), 1);
                    if (target instanceof PayloadConveyor.PayloadConveyorBuild) {
                        Fx.payloadDeposit.at(this.x, this.y, this.angleTo((Position)target), (Object)new UnitAssembler.YeetData(new Vec2(target.x, target.y), todump.content()));
                    }
                    this.incrementDumpIndex(this.linkProximityMap.size);
                    return true;
                }
                this.incrementDumpIndex(this.linkProximityMap.size);
            }
            return false;
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return AdaptCrafter.this.payloadFilter.contains((Object)payload.content()) && this.getPayloads().get(payload.content()) < AdaptCrafter.this.payloadCapacity;
        }

        public void dumpLiquid(Liquid liquid, float scaling, int outputDir) {
            int dump = this.cdump;
            if (this.liquids.get(liquid) <= 1.0E-4f) {
                return;
            }
            if (!Vars.net.client() && Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
                liquid.unlock();
            }
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                float fract;
                float ofract;
                this.incrementDumpIndex(this.linkProximityMap.size);
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (outputDir != -1 && (outputDir + this.rotation) % 4 != this.relativeTo(target) || (target = target.getLiquidDestination(source, liquid)) == null || !target.block.hasLiquids || !this.canDumpLiquid(target, liquid) || target.liquids == null || !((ofract = target.liquids.get(liquid) / target.block.liquidCapacity) < (fract = this.liquids.get(liquid) / this.block.liquidCapacity))) continue;
                this.transferLiquid(target, (fract - ofract) * this.block.liquidCapacity / scaling, liquid);
            }
        }

        public void dumpOutputs() {
            boolean timer = this.timer(AdaptCrafter.this.timerDump, (float)AdaptCrafter.this.dumpTime / this.timeScale);
            if (AdaptCrafter.this.outputItems != null && timer) {
                for (ItemStack itemStack : AdaptCrafter.this.outputItems) {
                    this.dump(itemStack.item);
                }
            }
            if (AdaptCrafter.this.outputPayloads != null && timer) {
                for (ItemStack itemStack : AdaptCrafter.this.outputPayloads) {
                    BuildPayload payload = new BuildPayload((Block)itemStack.item, this.team);
                    payload.set(this.x, this.y, this.rotdeg());
                    this.dumpPayload((Payload)payload);
                }
            }
            if (AdaptCrafter.this.outputLiquids != null) {
                for (int i = 0; i < AdaptCrafter.this.outputLiquids.length; ++i) {
                    int dir = AdaptCrafter.this.liquidOutputDirections.length > i ? AdaptCrafter.this.liquidOutputDirections[i] : -1;
                    this.dumpLiquid(AdaptCrafter.this.outputLiquids[i].liquid, 2.0f, dir);
                }
            }
        }

        public void offload(Item item) {
            this.produced(item, 1);
            int dump = this.dumpIndex;
            for (int i = 0; i < this.linkProximityMap.size; ++i) {
                this.incrementDumpIndex(this.linkProximityMap.size);
                int idx = (i + dump) % this.linkProximityMap.size;
                Building[] pair = (Building[])this.linkProximityMap.get(idx);
                Building target = pair[0];
                Building source = pair[1];
                if (!target.acceptItem(source, item) || !this.canDump(target, item)) continue;
                target.handleItem(source, item);
                return;
            }
            this.handleItem((Building)this, item);
        }

        @Override
        public void updateLinkProximity() {
            if (this.linkEntities != null) {
                this.linkProximityMap.clear();
                for (Building link : this.linkEntities) {
                    for (Building linkProx : link.proximity) {
                        if (linkProx == this || this.linkEntities.contains((Object)linkProx) || !this.checkValidPair(linkProx, link)) continue;
                        this.linkProximityMap.add((Object)new Building[]{linkProx, link});
                    }
                }
                for (Building prox : this.proximity) {
                    if (this.linkEntities.contains((Object)prox) || !this.checkValidPair(prox, (Building)this)) continue;
                    this.linkProximityMap.add((Object)new Building[]{prox, this});
                }
            }
        }

        public boolean checkValidPair(Building target, Building source) {
            for (Building[] pair : this.linkProximityMap) {
                Building pairTarget = pair[0];
                Building pairSource = pair[1];
                if (target != pairTarget || target.relativeTo(pairSource) != target.relativeTo(source)) continue;
                return false;
            }
            return true;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.updateLinkProximity();
        }

        public void onRemoved() {
            AdaptCrafter.this.createPlaceholder(this.tile, AdaptCrafter.this.size);
        }

        public boolean canPickup() {
            return false;
        }

        public void drawTeam() {
            this.teamPos = Vars.world.tile(this.tileX() + AdaptCrafter.this.teamOverlayPos((int)AdaptCrafter.this.size, (int)this.rotation).x, this.tileY() + AdaptCrafter.this.teamOverlayPos((int)AdaptCrafter.this.size, (int)this.rotation).y);
            if (this.teamPos != null) {
                Draw.color((Color)this.team.color);
                Draw.rect((String)"block-border", (float)this.teamPos.worldx(), (float)this.teamPos.worldy());
                Draw.color();
            }
        }

        public void drawStatus() {
            this.statusPos = Vars.world.tile(this.tileX() + AdaptCrafter.this.statusOverlayPos((int)AdaptCrafter.this.size, (int)this.rotation).x, this.tileY() + AdaptCrafter.this.statusOverlayPos((int)AdaptCrafter.this.size, (int)this.rotation).y);
            if (this.block.enableDrawStatus && this.block.consumers.length > 0) {
                float multiplier = this.block.size > 1 ? 1.0f : 0.64f;
                Draw.z((float)71.0f);
                Draw.color((Color)Pal.gray);
                Fill.square((float)this.statusPos.worldx(), (float)this.statusPos.worldy(), (float)(2.5f * multiplier), (float)45.0f);
                Draw.color((Color)this.status().color);
                Fill.square((float)this.statusPos.worldx(), (float)this.statusPos.worldy(), (float)(1.5f * multiplier), (float)45.0f);
                Draw.color();
            }
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            this.payloads.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 2) {
                this.payloads = new PayloadSeq();
                this.payloads.read(read);
            }
        }
    }
}

