/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.drill;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHContent;
import newhorizon.expand.BasicMultiBlock;
import newhorizon.util.func.MathUtil;
import newhorizon.util.graphic.DrawFunc;

public class OreCollector
extends BasicMultiBlock {
    public static Seq<Tile> tmpClusters = new Seq();
    public static ObjectFloatMap<Item> returnCount = new ObjectFloatMap();
    public TextureRegion[] innerRegions;
    public TextureRegion[] outerRegions;
    public TextureRegion baseRegion;
    public int tier = 5;
    public float mineTime = 120.0f;
    public float drillTime = 30.0f;
    public float warmupSpeed = 0.075f;
    @Nullable
    public Item blockedItem;
    @Nullable
    public Seq<Item> blockedItems;
    public float optionalBoostIntensity = 2.0f;
    public float hardnessDrillMultiplier = 10.0f;
    public ObjectFloatMap<Item> drillMultipliers = new ObjectFloatMap();
    public float baseDrillCount = 1.0f;
    public int collectOffset = 5;
    public int collectSize = 7;

    public OreCollector(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.rotate = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.clipSize = 288.0f;
        this.ambientSound = Sounds.loopDrill;
        this.ambientSoundVolume = 0.018f;
        this.group = BlockGroup.drills;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    public void load() {
        super.load();
        this.innerRegions = new TextureRegion[4];
        this.outerRegions = new TextureRegion[4];
        this.baseRegion = Core.atlas.find(this.name + "-base");
        for (int i = 0; i < 4; ++i) {
            this.innerRegions[i] = Core.atlas.find(this.name + "-inner-" + i);
            this.outerRegions[i] = Core.atlas.find(this.name + "-outer-" + i);
        }
    }

    public TextureRegion getPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        return this.baseRegion;
    }

    public void setBars() {
        super.setBars();
    }

    public boolean outputsItems() {
        return true;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        this.getOreOutput(tmpClusters, x, y, rotation);
        int i = 0;
        for (ObjectFloatMap.Entry entry : returnCount.entries()) {
            Tmp.v1.setZero().add((float)this.collectOffset, 0.0f).rotate((float)(rotation * 90)).add(0.0f, (float)(this.collectSize - this.size) / 2.0f).add((float)x, (float)y);
            if (rotation == 3) {
                Tmp.v1.set((float)x, (float)y);
            }
            this.drawPlaceText("[white]" + ((Item)entry.key).emoji() + "[] " + ((Item)entry.key).localizedName + " " + Strings.autoFixed((float)(entry.value / (this.mineTime / 60.0f)), (int)2) + StatUnit.perSecond.localized(), (int)Tmp.v1.x, (int)Tmp.v1.y + i, valid);
            ++i;
        }
        x *= 8;
        y *= 8;
        Rect rect = this.getRect(Tmp.r1, x += (int)this.offset, y += (int)this.offset, rotation);
        Color c = valid ? Pal.accent : Pal.remove;
        Drawf.dashRect((Color)c, (Rect)rect);
        Draw.color((Color)Pal.accent);
        Draw.alpha((float)0.5f);
        tmpClusters.each(tile -> Fill.square((float)tile.worldx(), (float)tile.worldy(), (float)4.0f));
        Draw.reset();
    }

    public float getDrillTime(Item item) {
        return (this.drillTime + this.hardnessDrillMultiplier * (float)item.hardness) / this.drillMultipliers.get((Object)item, 1.0f);
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        Rect rect = this.getRect(Tmp.r1, tile.worldx() + this.offset, tile.worldy() + this.offset, rotation).grow(-0.1f);
        this.getOreClusters(tmpClusters, tile.x, tile.y, rotation);
        boolean hasOre = !tmpClusters.isEmpty();
        boolean overlap = Vars.indexer.getFlagged(team, BlockFlag.drill).contains(b -> this.checkOverlap(rect, Tmp.r2, b.block, (Building)b));
        boolean planOverlap = team.data().getBuildings((Block)ConstructBlock.get((int)this.size)).contains(b -> this.checkOverlap(rect, Tmp.r2, ((ConstructBlock.ConstructBuild)b).current, (Building)b));
        return super.canPlaceOn(tile, team, rotation) && hasOre && !overlap && !planOverlap;
    }

    public boolean checkOverlap(Rect rect1, Rect rect2, Block block, Building building) {
        if (building == null) {
            return false;
        }
        if (!(block instanceof OreCollector)) {
            return false;
        }
        return ((OreCollector)block).getRect(rect2, building.x, building.y, building.rotation).overlaps(rect1);
    }

    public Rect getRect(Rect rect, float x, float y, int rotation) {
        rect.setCentered(x, y, (float)(this.collectSize * 8));
        float len = (float)(8 * (this.collectSize + this.size)) / 2.0f;
        rect.x += (float)Geometry.d4x((int)rotation) * len;
        rect.y += (float)Geometry.d4y((int)rotation) * len;
        return rect;
    }

    public void getOreClusters(Seq<Tile> out, int x, int y, int rotation) {
        out.clear();
        int cx = x + Geometry.d4x((int)rotation) * this.collectOffset;
        int cy = y + Geometry.d4y((int)rotation) * this.collectOffset;
        int offset = this.collectSize / 2;
        for (int tx = cx - offset; tx <= cx + offset; ++tx) {
            for (int ty = cy - offset; ty <= cy + offset; ++ty) {
                Tile tile = Vars.world.tile(tx, ty);
                if (tile == null || tile.block() == null || tile.block().itemDrop == null) continue;
                out.add((Object)tile);
            }
        }
    }

    public void getOreOutput(Seq<Tile> out, int x, int y, int rotation) {
        this.getOreClusters(out, x, y, rotation);
        returnCount.clear();
        out.each(tile -> {
            if (tile.block().itemDrop == null) {
                return;
            }
            Item drops = tile.block().itemDrop;
            if (!(drops == null || drops.hardness > this.tier || this.blockedItems != null && this.blockedItems.contains((Object)drops))) {
                returnCount.increment((Object)drops, 0.0f, 60.0f / this.getDrillTime(drops) * tile.block().attributes.get(NHContent.density));
            }
        });
    }

    public void drawBlockBase(float x, float y, int rotation) {
        Draw.rect((TextureRegion)this.innerRegions[rotation], (float)x, (float)y);
        Tmp.v1.set(4.0f, 20.0f).rotate((float)(rotation * 90));
        Tmp.v2.set(4.0f, -20.0f).rotate((float)(rotation * 90));
        Draw.rect((TextureRegion)this.outerRegions[(rotation + 3) % 4], (float)(x + Tmp.v1.x), (float)(y + Tmp.v1.y));
        Draw.rect((TextureRegion)this.outerRegions[(rotation + 1) % 4], (float)(x + Tmp.v2.x), (float)(y + Tmp.v2.y));
    }

    public class OreCollectorBuilding
    extends BasicMultiBlock.BasicMultiBuilding {
        public Seq<Tile> oreClusters = new Seq();
        public float progress;
        public float warmup;

        @Override
        public void created() {
            super.created();
            OreCollector.this.getOreClusters(this.oreClusters, this.tileX(), this.tileY(), this.rotation);
        }

        public void draw() {
            OreCollector.this.drawBlockBase(this.x, this.y, this.rotation);
            if (this.warmup > 0.01f) {
                this.drawScanner();
            }
        }

        private void drawScanner() {
            float len1 = (float)(OreCollector.this.collectSize * 8) / 2.0f;
            float len2 = (float)(OreCollector.this.size * 8) / 2.0f;
            float len3 = 8 * OreCollector.this.collectSize;
            float len4 = 8.0f;
            float outlineAlpha = this.warmup * MathUtil.timeValue(0.65f, 0.8f, 3.0f);
            float innerAlpha = this.warmup * MathUtil.timeValue(0.2f, 0.25f, 3.0f);
            float ang = DrawFunc.rotator_90(DrawFunc.cycle(Time.time / 4.0f, 0.0f, 45.0f), 0.15f);
            float scl = MathUtil.timeValue(0.75f, 1.25f, 3.0f);
            Draw.z((float)35.0f);
            Draw.color((Color)this.team.color);
            Tmp.c1.set(this.team.color).lerp(Color.white, 0.8f).a(innerAlpha);
            float shift1 = 2.0f;
            float shift2 = MathUtil.timeValue(6.0f, 8.0f, 3.0f);
            Draw.alpha((float)innerAlpha);
            Rect rect = OreCollector.this.getRect(Tmp.r1, this.x, this.y, this.rotation);
            Fill.rect((Rect)rect);
            Tmp.v1.setZero().add(len2 - 1.0f, len1 - 1.0f).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v2.setZero().add(len2 - 1.0f, -len1 + 1.0f).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v3.setZero().add(len2 - len4, -len1 + len4).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v4.setZero().add(len2 - len4, len1 - len4).rotate(this.rotdeg()).add(this.x, this.y);
            Lines.stroke((float)2.0f);
            Draw.alpha((float)outlineAlpha);
            Draw.z((float)110.0f);
            Fill.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)1.25f);
            Fill.circle((float)Tmp.v2.x, (float)Tmp.v2.y, (float)1.25f);
            Fill.circle((float)Tmp.v3.x, (float)Tmp.v3.y, (float)1.25f);
            Fill.circle((float)Tmp.v4.x, (float)Tmp.v4.y, (float)1.25f);
            Tmp.v1.setZero().add(len2 - 1.5f, len1 - 1.5f).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v2.setZero().add(len2 - 1.5f, -len1 + 1.5f).rotate(this.rotdeg()).add(this.x, this.y);
            Lines.line((float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y);
            Lines.line((float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Tmp.v1.setZero().add(len2, len1 - 2.0f).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v2.setZero().add(len2, -len1 + 2.0f).rotate(this.rotdeg()).add(this.x, this.y);
            Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
            Tmp.v1.setZero().add(len2, len1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v2.setZero().add(len2, -len1).rotate(this.rotdeg()).add(this.x, this.y);
            Draw.alpha((float)innerAlpha);
            Draw.z((float)35.0f);
            Fill.quad((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Tmp.v1.setZero().add(len2, len1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v2.setZero().add(len2 + len3, len1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v3.setZero().add(len2 + len3 - shift1, len1 - shift1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v4.setZero().add(len2, len1 - shift1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v5.setZero().add(len2, len1 - shift2).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v6.setZero().add(len2 + len3 - shift2, len1 - shift2).rotate(this.rotdeg()).add(this.x, this.y);
            Draw.alpha((float)outlineAlpha);
            Draw.z((float)110.0f);
            Fill.quad((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Draw.alpha((float)innerAlpha);
            Draw.z((float)35.0f);
            Fill.quad((float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v4.x, (float)Tmp.v4.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v5.x, (float)Tmp.v5.y, (float)0.0f, (float)Tmp.v6.x, (float)Tmp.v6.y, (float)0.0f);
            Tmp.v1.setZero().add(len2 + len3, -len1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v4.setZero().add(len2 + len3 - shift1, -len1 + shift1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v5.setZero().add(len2 + len3 - shift2, -len1 + shift2).rotate(this.rotdeg()).add(this.x, this.y);
            Draw.alpha((float)outlineAlpha);
            Draw.z((float)110.0f);
            Fill.quad((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Draw.alpha((float)innerAlpha);
            Draw.z((float)35.0f);
            Fill.quad((float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v4.x, (float)Tmp.v4.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v5.x, (float)Tmp.v5.y, (float)0.0f, (float)Tmp.v6.x, (float)Tmp.v6.y, (float)0.0f);
            Tmp.v2.setZero().add(len2, -len1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v3.setZero().add(len2, -len1 + shift1).rotate(this.rotdeg()).add(this.x, this.y);
            Tmp.v6.setZero().add(len2, -len1 + shift2).rotate(this.rotdeg()).add(this.x, this.y);
            Draw.alpha((float)outlineAlpha);
            Draw.z((float)110.0f);
            Fill.quad((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v4.x, (float)Tmp.v4.y);
            Draw.alpha((float)innerAlpha);
            Draw.z((float)35.0f);
            Fill.quad((float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v4.x, (float)Tmp.v4.y, (float)Tmp.c1.toFloatBits(), (float)Tmp.v5.x, (float)Tmp.v5.y, (float)0.0f, (float)Tmp.v6.x, (float)Tmp.v6.y, (float)0.0f);
            Draw.alpha((float)this.warmup);
            Lines.stroke((float)0.5f);
            this.oreClusters.each(tile -> {
                if (tile.block().itemDrop != null) {
                    Draw.color((Color)tile.block().itemDrop.color);
                    Draw.z((float)122.0f);
                    Fill.rect((float)tile.worldx(), (float)tile.worldy(), (float)(8.0f * scl), (float)(8.0f * scl), (float)ang);
                    Draw.z((float)110.0f);
                    for (int i = 0; i < 4; ++i) {
                        Tmp.v1.set(2.0f * scl, 6.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Tmp.v2.set(6.0f * scl, 6.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Tmp.v3.set(6.0f * scl, 2.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Lines.beginLine();
                        Lines.linePoint((float)Tmp.v1.x, (float)Tmp.v1.y);
                        Lines.linePoint((float)Tmp.v2.x, (float)Tmp.v2.y);
                        Lines.linePoint((float)Tmp.v3.x, (float)Tmp.v3.y);
                        Lines.endLine();
                        Tmp.v1.set(2.0f * scl, 4.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Tmp.v2.set(4.0f * scl, 4.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Tmp.v3.set(4.0f * scl, 2.0f * scl).rotate(ang + (float)(i * 90)).add(tile.worldx(), tile.worldy());
                        Lines.beginLine();
                        Lines.linePoint((float)Tmp.v1.x, (float)Tmp.v1.y);
                        Lines.linePoint((float)Tmp.v2.x, (float)Tmp.v2.y);
                        Lines.linePoint((float)Tmp.v3.x, (float)Tmp.v3.y);
                        Lines.endLine();
                    }
                }
            });
            Draw.z((float)110.0f);
            Draw.color((Color)Tmp.c1.set(this.team.color).lerp(Color.white, 0.5f));
            for (int tx = 0; tx < 8; ++tx) {
                for (int ty = 0; ty < 8; ++ty) {
                    float rx = (float)tx * 7.5f + this.x + (float)(OreCollector.this.collectOffset * 8 * Geometry.d4x((int)this.rotation)) - 26.5f;
                    float ry = (float)ty * 7.5f + this.y + (float)(OreCollector.this.collectOffset * 8 * Geometry.d4y((int)this.rotation)) - 26.5f;
                    float a = this.warmup * MathUtil.timeValue(0.2f, 0.65f, 1.0f, Mathf.randomSeed((long)Point2.pack((int)((int)rx), (int)((int)ry)), (float)0.0f, (float)360.0f));
                    Draw.alpha((float)a);
                    if (tx < 7) {
                        Lines.lineAngle((float)rx, (float)ry, (float)0.0f, (float)3.0f);
                    }
                    if (ty < 7) {
                        Lines.lineAngle((float)rx, (float)ry, (float)90.0f, (float)3.0f);
                    }
                    if (tx > 0) {
                        Lines.lineAngle((float)rx, (float)ry, (float)180.0f, (float)3.0f);
                    }
                    if (ty <= 0) continue;
                    Lines.lineAngle((float)rx, (float)ry, (float)270.0f, (float)3.0f);
                }
            }
            Draw.reset();
        }

        public boolean shouldConsume() {
            return this.items.total() < OreCollector.this.itemCapacity && this.enabled && !this.oreClusters.isEmpty();
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.timer(OreCollector.this.timerDump, (float)OreCollector.this.dumpTime / this.timeScale)) {
                this.dump();
            }
            if (this.items.total() < OreCollector.this.itemCapacity && this.efficiency > 0.0f) {
                float multiplier = Mathf.lerp((float)1.0f, (float)OreCollector.this.optionalBoostIntensity, (float)this.optionalEfficiency);
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)1.0f, (float)OreCollector.this.warmupSpeed);
                this.progress += this.edelta() * this.warmup * multiplier;
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)OreCollector.this.warmupSpeed);
                return;
            }
            if (this.progress >= OreCollector.this.mineTime) {
                OreCollector.this.getOreOutput(this.oreClusters, this.tileX(), this.tileY(), this.rotation);
                this.oreClusters.each(tile -> {
                    if (tile.block() != null && tile.block().itemDrop != null) {
                        Fx.mineHuge.at(tile.worldx(), tile.worldy(), tile.block().itemDrop.color);
                        Fx.itemTransfer.at(tile.worldx(), tile.worldy(), 0.0f, tile.block().itemDrop.color, (Object)this);
                    }
                });
                returnCount.each(entry -> this.addItem((Item)entry.key, entry.value));
                this.progress %= OreCollector.this.mineTime;
            }
        }

        public void addItem(Item item, float value) {
            float chance = value % 1.0f;
            this.items.add(item, Math.min(this.getMaximumAccepted(item) - this.items.get(item), (int)value));
            if (this.getMaximumAccepted(item) > this.items.get(item) && Mathf.chance((double)chance)) {
                this.items.add(item, 1);
            }
        }

        @Override
        public void drawStatus() {
            super.drawStatus();
        }
    }
}

