/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.drill;

import arc.Core;
import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.type.Item;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import newhorizon.content.NHStats;
import newhorizon.expand.block.production.drill.AdaptDrill;
import newhorizon.util.graphic.SpriteUtil;

public class DrillModule
extends Block {
    public TextureRegion[] topRegion;
    public TextureRegion baseRegion;
    public Seq<Item[]> convertList = new Seq();
    public ObjectFloatMap<Item> convertMul = new ObjectFloatMap();
    public float boostSpeed = 0.0f;
    public float boostFinalMul = 0.0f;
    public float powerMul = 0.0f;
    public float powerExtra = 0.0f;
    public Cons<DrillModuleBuild> drawer = module -> {};

    public DrillModule(String name) {
        super(name);
        this.size = 2;
        this.update = false;
        this.solid = true;
        this.destructible = true;
        this.rotate = true;
        this.drawCracks = false;
        this.hasItems = false;
        this.hasLiquids = false;
        this.hasPower = false;
        this.canOverdrive = false;
        this.drawDisabled = false;
        this.ambientSound = Sounds.loopDrill;
        this.ambientSoundVolume = 0.018f;
        this.group = BlockGroup.drills;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
    }

    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(this.name + "-base");
        this.topRegion = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-top"), 64, 64, 1);
    }

    public void setStats() {
        super.setStats();
        if (this.powerMul != 0.0f || this.powerExtra != 0.0f) {
            this.stats.add(NHStats.powerConsModifier, Core.bundle.get("nh.stat.power-cons-modifier"), new Object[]{Strings.autoFixed((float)(this.powerMul * 100.0f), (int)0), Strings.autoFixed((float)this.powerExtra, (int)0)});
        }
        if (this.boostSpeed != 0.0f || this.boostFinalMul != 0.0f) {
            this.stats.add(NHStats.minerBoosModifier, Core.bundle.get("nh.stat.miner-boost-modifier"), new Object[]{Strings.autoFixed((float)(this.boostSpeed * 100.0f), (int)0), Strings.autoFixed((float)(this.boostFinalMul * 100.0f), (int)0)});
        }
        if (this.convertList.size > 0) {
            this.stats.add(NHStats.itemConvertList, this.getConvertList(), new Object[0]);
        }
    }

    public String getConvertList() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.convertList.size; ++i) {
            Item[] convert = (Item[])this.convertList.get(i);
            String cvt = Fonts.getUnicodeStr((String)convert[0].name) + convert[0].localizedName + " -> " + Fonts.getUnicodeStr((String)convert[1].name) + convert[1].localizedName + "(" + Strings.autoFixed((float)(this.convertMul.get((Object)convert[0], this.boostFinalMul) * 100.0f), (int)0) + "%)" + (i == this.convertList.size - 1 ? "" : "\n");
            builder.append(cvt);
        }
        return builder.toString();
    }

    public void drawDefaultPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegion[plan.rotation + 8], (float)plan.drawx(), (float)plan.drawy());
        this.drawPlanConfig(plan, list);
    }

    public class DrillModuleBuild
    extends Building {
        @Nullable
        public AdaptDrill.AdaptDrillBuild drillBuild;
        public float smoothWarmup;
        public float targetWarmup;

        public void draw() {
            Draw.rect((TextureRegion)DrillModule.this.baseRegion, (float)this.x, (float)this.y);
            Draw.z((float)35.0f);
            this.drawTeamTop();
            if (this.drillBuild != null) {
                Draw.rect((TextureRegion)DrillModule.this.topRegion[this.rotation], (float)this.x, (float)this.y);
                Draw.rect((TextureRegion)DrillModule.this.topRegion[this.rotation + 4], (float)((float)(Geometry.d4x((int)this.rotation) * DrillModule.this.size * 8) + this.x), (float)((float)(Geometry.d4y((int)this.rotation) * DrillModule.this.size * 8) + this.y));
            } else {
                Draw.rect((TextureRegion)DrillModule.this.topRegion[this.rotation + 8], (float)this.x, (float)this.y);
            }
            DrillModule.this.drawer.get((Object)this);
            this.targetWarmup = this.drillBuild != null && this.drillBuild.modules.contains((Object)this) ? this.drillBuild.warmup : 0.0f;
            this.smoothWarmup = Mathf.lerp((float)this.smoothWarmup, (float)this.targetWarmup, (float)0.02f);
        }

        public boolean canApply(AdaptDrill.AdaptDrillBuild drill) {
            for (int i = 0; i < DrillModule.this.size; ++i) {
                Point2 p = Edges.getEdges((int)DrillModule.this.size)[this.rotation * DrillModule.this.size + i];
                Building t = Vars.world.build(this.tileX() + p.x, this.tileY() + p.y);
                if (t == drill) continue;
                return false;
            }
            return (float)drill.modules.size < drill.maxModules();
        }

        public void apply(AdaptDrill.AdaptDrillBuild drill) {
        }
    }
}

