/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.drill;

import arc.graphics.Color;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.world.blocks.production.Drill;
import newhorizon.content.NHStats;
import newhorizon.expand.block.production.drill.DrillModule;

public class AdaptDrill
extends Drill {
    public int maxModules = 1;

    public AdaptDrill(String name) {
        super(name);
        this.size = 4;
        this.itemCapacity = 40;
        this.canOverdrive = false;
        this.drawTeamOverlay = false;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.maxModules, (float)this.maxModules);
    }

    public class AdaptDrillBuild
    extends Drill.DrillBuild {
        public Seq<DrillModule.DrillModuleBuild> modules;

        public AdaptDrillBuild() {
            super((Drill)AdaptDrill.this);
            this.modules = new Seq();
        }

        public float maxModules() {
            return AdaptDrill.this.maxModules;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.modules.clear();
            this.proximity.each(building -> {
                DrillModule.DrillModuleBuild module;
                if (building instanceof DrillModule.DrillModuleBuild && (module = (DrillModule.DrillModuleBuild)((Object)building)).canApply(this)) {
                    module.drillBuild = this;
                    this.modules.add((Object)module);
                    module.apply(this);
                }
            });
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.selected((Building)this, (Color)Pal.accent);
            this.modules.each(building -> Drawf.selected((Building)building, (Color)Pal.accent));
        }

        public void remove() {
            super.remove();
            for (DrillModule.DrillModuleBuild module : this.modules) {
                module.drillBuild = null;
            }
        }

        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.firstItem) {
                return this.dominantItem;
            }
            return super.senseObject(sensor);
        }
    }
}

