/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.inner;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.meta.BuildVisibility;

public class PlaceholderBlock
extends Block {
    public PlaceholderBlock(String name) {
        super(name);
        this.update = true;
        this.squareSprite = false;
        this.destructible = true;
        this.breakable = false;
        this.solid = true;
        this.rebuildable = false;
        this.inEditor = false;
        this.buildVisibility = BuildVisibility.hidden;
    }

    public boolean canBreak(Tile tile) {
        return false;
    }

    public boolean isHidden() {
        return true;
    }

    public void load() {
        super.load();
        this.region = Core.atlas.find("status-blasted");
    }

    public void loadIcon() {
        this.fullIcon = this.uiIcon = Core.atlas.find("status-blasted");
    }

    public class PlaceholderBuild
    extends Building {
        public boolean checkTile = false;
        public Tile linkTile;
        public ConstructBlock.ConstructBuild linkBuild;

        public void updateLink(Tile tile) {
            this.linkTile = tile;
            if (tile.build instanceof ConstructBlock.ConstructBuild) {
                this.linkBuild = (ConstructBlock.ConstructBuild)tile.build;
            }
        }

        public void draw() {
        }

        public void updateTile() {
            super.updateTile();
            if (!this.checkTile && this.linkBuild == null && this.linkTile != null) {
                this.updateLink(this.linkTile);
                this.checkTile = true;
            }
            if (this.linkBuild == null || !this.linkBuild.isAdded()) {
                this.tile.removeNet();
            }
        }

        public TextureRegion getDisplayIcon() {
            return this.linkBuild == null ? this.block.uiIcon : this.linkBuild.getDisplayIcon();
        }

        public String getDisplayName() {
            String name;
            String string = name = this.linkBuild == null ? this.block.localizedName : this.linkBuild.block.localizedName;
            return this.team == Team.derelict ? name + "\n" + Core.bundle.get("block.derelict") : name + (this.team != Vars.player.team() && !this.team.emoji.isEmpty() ? " " + this.team.emoji : "");
        }

        public float handleDamage(float amount) {
            if (this.linkBuild != null) {
                return this.linkBuild.handleDamage(amount);
            }
            return 0.0f;
        }
    }
}

