/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.util.Log;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import newhorizon.NewHorizon;
import newhorizon.util.graphic.SpriteUtil;

public class TiledFloor
extends Floor {
    public TextureRegion[][] spilt;
    public String tileName = "plating-floor";
    public int splitTileSize = 4;
    public int splitVariants = 12;
    public boolean useTiles = true;
    boolean splitLoaded = false;

    public TiledFloor(String name) {
        super(name);
    }

    public TiledFloor(String name, int sSize, int sVar) {
        super(name);
        this.splitTileSize = sSize;
        this.splitVariants = sVar;
    }

    public void load() {
        super.load();
        TextureAtlas.AtlasRegion full = Core.atlas.find(NewHorizon.name(this.tileName));
        if (this.autotile) {
            TextureAtlas.AtlasRegion tiled = Core.atlas.find(this.name + "-tiled");
            if (tiled.height == 128) {
                this.autotileRegions = SpriteUtil.splitRegionArray((TextureRegion)tiled, 32, 32);
            }
            if (tiled.height == 136) {
                this.autotileRegions = SpriteUtil.splitRegionArray((TextureRegion)tiled, 32, 32, 1);
            }
            if (this.autotileVariants > 1) {
                this.autotileVariantRegions = new TextureRegion[this.autotileVariants][];
                for (int i = 0; i < this.autotileVariants; ++i) {
                    TextureAtlas.AtlasRegion tiledVariant = Core.atlas.find(this.name + "-tiled-" + (i + 1));
                    if (tiled.height == 128) {
                        this.autotileVariantRegions[i] = SpriteUtil.splitRegionArray((TextureRegion)tiledVariant, 32, 32);
                        continue;
                    }
                    if (tiled.height == 136) {
                        this.autotileVariantRegions[i] = SpriteUtil.splitRegionArray((TextureRegion)tiledVariant, 32, 32, 1);
                        continue;
                    }
                    Log.err((String)("Failed to load tile " + this.name + "-tiled-" + (i + 1) + ": " + tiledVariant.width + "x" + tiledVariant.height), (Object[])new Object[0]);
                }
            }
        }
        if (!this.useTiles) {
            return;
        }
        int pw = this.splitTileSize * this.splitVariants * 32;
        int ph = this.splitTileSize * 32;
        if (full.width == pw && full.height == ph) {
            this.spilt = new TextureRegion[this.splitTileSize * this.splitVariants][this.splitTileSize];
            for (int i = 0; i < this.splitVariants; ++i) {
                this.spilt = full.split(32, 32);
            }
            this.splitLoaded = true;
        } else {
            Log.err((String)("Failed to load tile " + this.tileName + "with size " + pw + "x" + ph), (Object[])new Object[]{". tiled disable."});
        }
    }

    private void drawTile(Tile tile) {
        int tx = tile.x / this.splitTileSize * this.splitTileSize;
        int ty = tile.y / this.splitTileSize * this.splitTileSize;
        int index = Mathf.randomSeed((long)Point2.pack((int)tx, (int)ty), (int)0, (int)(this.splitVariants - 1));
        int ix = index * this.splitTileSize + tile.x - tx;
        int iy = this.splitTileSize - (tile.y - ty) - 1;
        Draw.rect((TextureRegion)this.spilt[ix][iy], (float)tile.worldx(), (float)tile.worldy());
    }

    public void drawBase(Tile tile) {
        if (this.useTiles && this.splitLoaded) {
            this.drawTile(tile);
        }
        super.drawBase(tile);
    }
}

