/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.world.draw.DrawBlock;

public class DrawScanLine
extends DrawBlock {
    public float lineStroke = 0.786f;
    public float scanLength = 16.0f;
    public float scanAngle = 0.0f;
    public float phaseOffset = 0.0f;
    public float strokeScl = 4.0f;
    public float strokeRange = 8.0f;
    public float strokePlusScl = 0.25f;
    public float totalProgressMultiplier = 1.0f;
    public float scanScl = 6.0f;
    public float alpha = 0.67f;
    public Color colorFrom = Pal.accent;
    public Color colorTo = Color.white;
    public float colorLerpRatio = 0.53f;
    public float colorLerpScl = 3.3f;
    public float x;
    public float y;

    public void draw(Building build) {
        Draw.blend((Blending)Blending.additive);
        Draw.color((Color)this.colorFrom, (Color)this.colorTo, (float)Mathf.absin((float)(build.totalProgress() * this.totalProgressMultiplier + this.phaseOffset), (float)this.colorLerpScl, (float)this.colorLerpRatio));
        Draw.alpha((float)(this.alpha * build.warmup()));
        float stroke = this.lineStroke * (1.0f + Mathf.absin((float)(build.totalProgress() * this.totalProgressMultiplier), (float)this.strokeScl, (float)this.strokePlusScl)) * build.warmup();
        Lines.stroke((float)stroke);
        Tmp.v1.trns(this.scanAngle + build.rotdeg(), Mathf.sin((float)(build.totalProgress() * this.totalProgressMultiplier + this.phaseOffset), (float)this.scanScl, (float)this.strokeRange)).add(this.x, this.y).add(build.x, build.y);
        Lines.lineAngleCenter((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(this.scanAngle + 90.0f + build.rotdeg()), (float)(this.scanLength * build.warmup() - stroke));
        Draw.reset();
        Draw.blend();
    }
}

