/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.drawer;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import arc.util.Tmp;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRegionRotated
extends DrawBlock {
    public TextureRegion[] region;
    public TextureRegion iconRegion;
    public boolean oneSprite = false;
    public String suffix = "";
    public float x = 0.0f;
    public float y = 0.0f;
    public float layer = -1.0f;

    public DrawRegionRotated(String suffix) {
        this.suffix = suffix;
    }

    public DrawRegionRotated() {
    }

    public void draw(Building build) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Tmp.v1.set(this.x, this.y).rotate(build.rotdeg());
        if (this.oneSprite) {
            Draw.rect((TextureRegion)this.region[build.rotation], (float)(Tmp.v1.x + build.x), (float)(Tmp.v1.y + build.y), (float)build.rotdeg());
        } else {
            Draw.rect((TextureRegion)this.region[build.rotation], (float)(Tmp.v1.x + build.x), (float)(Tmp.v1.y + build.y));
        }
        Draw.z((float)z);
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Tmp.v1.set(this.x, this.y).rotate((float)(plan.rotation * 90));
        if (this.oneSprite) {
            Draw.rect((TextureRegion)this.region[plan.rotation], (float)(Tmp.v1.x + plan.drawx()), (float)(Tmp.v1.y + plan.drawy()), (float)(plan.rotation * 90));
        } else {
            Draw.rect((TextureRegion)this.region[plan.rotation], (float)(Tmp.v1.x + plan.drawx()), (float)(Tmp.v1.y + plan.drawy()));
        }
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.iconRegion};
    }

    public void load(Block block) {
        this.region = new TextureRegion[4];
        if (this.oneSprite) {
            for (int i = 0; i < 4; ++i) {
                this.region[i] = Core.atlas.find(block.name + this.suffix);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.region[i] = Core.atlas.find(block.name + this.suffix + "-" + i);
            }
        }
        this.iconRegion = Core.atlas.find(block.name + this.suffix + "-icon", this.region[0]);
    }
}

