/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.NewHorizon;

public class AdaptLiquidDirectionalUnloader
extends Block {
    public TextureRegion[] topRegions = new TextureRegion[4];
    public TextureRegion baseRegion;
    public TextureRegion liquidRegion;
    public float speed = 5.0f;

    public AdaptLiquidDirectionalUnloader(String name) {
        super(name);
        this.group = BlockGroup.liquids;
        this.update = true;
        this.solid = true;
        this.configurable = true;
        this.saveConfig = true;
        this.rotate = true;
        this.noUpdateDisabled = true;
        this.unloadable = false;
        this.envDisabled = 0;
        this.clearOnDoubleTap = true;
        this.priority = -1.0f;
        this.hasLiquids = true;
        this.liquidCapacity = 50.0f;
        this.outputsLiquid = true;
        this.config(Liquid.class, (tile, Liquid2) -> {
            tile.unloadLiquid = Liquid2;
        });
        this.configClear(tile -> {
            tile.unloadLiquid = null;
        });
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speed, 60.0f * this.speed, StatUnit.liquidSecond);
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "duct-unloader-center");
    }

    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    public void load() {
        super.load();
        for (int i = 0; i < this.topRegions.length; ++i) {
            this.topRegions[i] = Core.atlas.find(this.name + "-top-" + i);
        }
        this.baseRegion = Core.atlas.find(NewHorizon.name("logistics-base"));
        this.liquidRegion = Core.atlas.find(this.name + "-liquid");
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.baseRegion, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.topRegions[plan.rotation], (float)plan.drawx(), (float)plan.drawy());
        this.drawPlanConfig(plan, list);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public class AdaptLiquidDirectionalUnloaderBuild
    extends Building {
        public float unloadTimer = 0.0f;
        public Liquid unloadLiquid = null;
        public int offset = 0;

        public void updateTile() {
            float f;
            if (this.liquids.current() != this.unloadLiquid) {
                this.liquids.clear();
            }
            this.unloadTimer += this.edelta();
            if (f >= Time.delta) {
                Building back = this.back();
                if (back != null && back.block != null && back.liquids != null && back.team == this.team && this.unloadLiquid != null) {
                    float fl = this.liquids.get(this.unloadLiquid);
                    float bl = back.liquids.get(this.unloadLiquid);
                    float fc = this.block.liquidCapacity;
                    float bc = back.block.liquidCapacity;
                    if (bl > 0.0f && bl / bc > fl / fc) {
                        float amount = Math.min(AdaptLiquidDirectionalUnloader.this.speed * Time.delta, back.liquids.get(this.unloadLiquid));
                        float a = Math.min(amount, this.block.liquidCapacity - this.liquids.get(this.unloadLiquid));
                        float balance = Math.min(a, (bl / bc - fl / fc) * bc);
                        this.handleLiquid(this, this.unloadLiquid, balance);
                        back.liquids.remove(this.unloadLiquid, balance);
                    }
                }
                this.unloadTimer %= AdaptLiquidDirectionalUnloader.this.speed;
            }
            if (this.liquids.currentAmount() > 0.01f) {
                this.dumpLiquid(this.liquids.current(), 2.0f, 0);
            }
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)AdaptLiquidDirectionalUnloader.this, (Table)table, (Seq)Vars.content.liquids(), () -> this.unloadLiquid, arg_0 -> ((AdaptLiquidDirectionalUnloaderBuild)this).configure(arg_0));
        }

        public Liquid config() {
            return this.unloadLiquid;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.unloadLiquid == null ? -1 : (int)this.unloadLiquid.id);
            write.s(this.offset);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = read.s();
            this.unloadLiquid = id == -1 ? null : (Liquid)Vars.content.liquids().get((int)id);
            this.offset = read.s();
        }

        public void draw() {
            Draw.rect((TextureRegion)AdaptLiquidDirectionalUnloader.this.baseRegion, (float)this.x, (float)this.y);
            if (this.unloadLiquid != null) {
                Draw.color((Color)this.unloadLiquid.color);
                Draw.rect((TextureRegion)AdaptLiquidDirectionalUnloader.this.liquidRegion, (float)this.x, (float)this.y);
                Draw.color();
            }
            Draw.rect((TextureRegion)AdaptLiquidDirectionalUnloader.this.topRegions[this.rotation], (float)this.x, (float)this.y);
        }

        public void drawSelect() {
            this.drawIO();
            Draw.reset();
        }

        private void drawIO() {
            Building front = this.front();
            Building back = this.back();
            if (this.unloadLiquid != null && front != null && back != null && front.acceptLiquid((Building)this, this.unloadLiquid)) {
                float alpha = Math.abs(100.0f - Time.time * 2.0f % 100.0f) / 100.0f;
                float ix = front.x;
                float iy = front.y;
                float ox = back.x;
                float oy = back.y;
                float px = Mathf.lerp((float)ix, (float)ox, (float)alpha);
                float py = Mathf.lerp((float)iy, (float)oy, (float)alpha);
                Draw.z((float)35.0f);
                Draw.color((Color)Pal.gray);
                Lines.stroke((float)2.5f);
                Fill.square((float)ix, (float)iy, (float)2.5f, (float)45.0f);
                Fill.square((float)ox, (float)oy, (float)2.5f, (float)45.0f);
                Lines.stroke((float)4.0f);
                Lines.line((float)ix, (float)iy, (float)ox, (float)oy);
                Draw.z((float)35.0001f);
                Draw.color((Color)(this.unloadLiquid == null ? Pal.gray : this.unloadLiquid.color));
                Fill.square((float)ix, (float)iy, (float)1.0f, (float)45.0f);
                Fill.square((float)ox, (float)oy, (float)1.0f, (float)45.0f);
                Lines.stroke((float)1.0f);
                Lines.line((float)ix, (float)iy, (float)ox, (float)oy);
                Draw.z((float)35.0002f);
                Draw.mixcol((Color)Draw.getColor(), (float)1.0f);
                Draw.color();
                Fill.square((float)px, (float)py, (float)1.0f, (float)45.0f);
                Draw.mixcol();
            }
        }
    }
}

