/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.item.logistics;

import arc.Core;
import arc.Graphics;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.world.blocks.distribution.OverflowDuct;
import newhorizon.NewHorizon;

public class AdaptDirectionalGate
extends OverflowDuct {
    public TextureRegion baseRegion;
    public TextureRegion overlayRegion;
    public TextureRegion invertRegion;

    public AdaptDirectionalGate(String name) {
        super(name);
        this.saveConfig = true;
        this.placeableLiquid = true;
        this.drawTeamOverlay = false;
        this.config(Boolean.class, (build, invert) -> {
            build.invert = invert;
        });
    }

    public void load() {
        super.load();
        this.baseRegion = Core.atlas.find(NewHorizon.name("logistics-base"));
        this.overlayRegion = Core.atlas.find(this.name + "-overlay");
        this.invertRegion = Core.atlas.find(this.name + "-invert");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.baseRegion, (float)plan.drawx(), (float)plan.drawy());
        Draw.rect((TextureRegion)this.overlayRegion, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    public class AdaptDirectionalGateBuild
    extends OverflowDuct.OverflowDuctBuild {
        public boolean invert;

        public AdaptDirectionalGateBuild() {
            super((OverflowDuct)AdaptDirectionalGate.this);
        }

        public boolean invert() {
            return this.invert;
        }

        public void draw() {
            Draw.rect((TextureRegion)AdaptDirectionalGate.this.baseRegion, (float)this.x, (float)this.y);
            Draw.rect((TextureRegion)(this.invert ? AdaptDirectionalGate.this.invertRegion : AdaptDirectionalGate.this.overlayRegion), (float)this.x, (float)this.y, (float)this.rotdeg());
        }

        public void tapped() {
            super.tapped();
            Fx.placeBlock.at((Position)this, (float)AdaptDirectionalGate.this.size);
            Sounds.click.at((Position)this);
            this.configure(!this.invert);
        }

        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        public Object config() {
            return this.invert;
        }

        @Nullable
        public Building target() {
            Building front;
            if (this.current == null) {
                return null;
            }
            if (this.invert()) {
                boolean rc;
                Building l = this.left();
                Building r = this.right();
                boolean lc = l != null && l.team == this.team && l.acceptItem((Building)this, this.current);
                boolean bl = rc = r != null && r.team == this.team && r.acceptItem((Building)this, this.current);
                if (lc && !rc) {
                    return l;
                }
                if (rc && !lc) {
                    return r;
                }
                if (lc) {
                    return this.cdump == 0 ? l : r;
                }
            }
            if ((front = this.front()) != null && front.team == this.team && front.acceptItem((Building)this, this.current)) {
                return front;
            }
            if (this.invert()) {
                return null;
            }
            for (int i = -1; i <= 1; ++i) {
                Building other;
                int dir = Mathf.mod((int)(this.rotation + ((i + this.cdump + 1) % 3 - 1)), (int)4);
                if (dir == this.rotation || (other = this.nearby(dir)) == null || other.team != this.team || !other.acceptItem((Building)this, this.current)) continue;
                return other;
            }
            return null;
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.invert);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.invert = read.bool();
        }
    }
}

