/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.distribution.item;

import arc.Core;
import arc.Graphics;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.Conveyor;
import newhorizon.util.graphic.SpriteUtil;

public class AdaptConveyor
extends Conveyor {
    public TextureRegion[] edgeRegions;
    public TextureRegion[] armorRegions;
    public TextureRegion[] arrowRegions;
    public TextureRegion[] pulseRegions;
    public float framePeriod = 8.0f;

    public AdaptConveyor(String name) {
        super(name);
        this.canOverdrive = false;
        this.placeableLiquid = true;
        this.drawTeamOverlay = false;
        this.config(Boolean.class, (build, armored) -> {
            build.armored = armored;
        });
    }

    public void load() {
        super.load();
        this.edgeRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-edge"), 32, 32, 1);
        this.armorRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-edge-armored"), 32, 32, 1);
        this.arrowRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-arrow"), 32, 32, 1);
        this.pulseRegions = SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-pulse"), 32, 32, 1);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        Draw.rect((TextureRegion)this.region, (float)plan.drawx(), (float)plan.drawy(), (float)(plan.rotation * 90));
    }

    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        boolean armored;
        boolean bl = armored = tile.build instanceof AdaptConveyorBuild && ((AdaptConveyorBuild)tile.build).armored;
        if (!armored) {
            return (otherblock.outputsItems() || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
        }
        return otherblock.outputsItems() && this.blendsArmored(tile, rotation, otherx, othery, otherrot, otherblock) || this.lookingAt(tile, rotation, otherx, othery, otherblock) && otherblock.hasItems;
    }

    public boolean blendsArmored(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return Point2.equals((int)(tile.x + Geometry.d4((int)rotation).x), (int)(tile.y + Geometry.d4((int)rotation).y), (int)otherx, (int)othery) || !otherblock.rotatedOutput(otherx, othery) && Edges.getFacingEdge((Block)otherblock, (int)otherx, (int)othery, (Tile)tile) != null && Edges.getFacingEdge((Block)otherblock, (int)otherx, (int)othery, (Tile)tile).relativeTo(tile) == rotation || otherblock instanceof Conveyor && otherblock.rotatedOutput(otherx, othery) && Point2.equals((int)(otherx + Geometry.d4((int)otherrot).x), (int)(othery + Geometry.d4((int)otherrot).y), (int)tile.x, (int)tile.y);
    }

    public boolean blends(Building self, Building other) {
        if (other == null) {
            return false;
        }
        return this.blends(self.tile, self.rotation, other.tileX(), other.tileY(), other.rotation, other.block);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    public int conveyorFrame() {
        return (int)(Time.time % this.framePeriod / this.framePeriod * 16.0f);
    }

    public int pulseFrame() {
        int value = (int)(Time.time / 4.0f % 4.0f);
        if (value == 0) {
            return 0;
        }
        if (value == 1) {
            return 1;
        }
        if (value == 2) {
            return 2;
        }
        if (value == 3) {
            return 1;
        }
        return 0;
    }

    public class AdaptConveyorBuild
    extends Conveyor.ConveyorBuild {
        public int drawIndex;
        public boolean armored;

        public AdaptConveyorBuild() {
            super((Conveyor)AdaptConveyor.this);
            this.drawIndex = 0;
            this.armored = false;
        }

        public void tapped() {
            super.tapped();
            Fx.placeBlock.at((Position)this, (float)AdaptConveyor.this.size);
            Sounds.click.at((Position)this);
            this.configure(!this.armored);
            this.onProximityUpdate();
        }

        public Graphics.Cursor getCursor() {
            return this.interactable(Vars.player.team()) ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
        }

        public Object config() {
            return this.armored;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.drawIndex = 0;
            if (this.check(this.tile.x, this.tile.y + 1)) {
                ++this.drawIndex;
            }
            if (this.check(this.tile.x + 1, this.tile.y)) {
                this.drawIndex += 2;
            }
            if (this.check(this.tile.x, this.tile.y - 1)) {
                this.drawIndex += 4;
            }
            if (this.check(this.tile.x - 1, this.tile.y)) {
                this.drawIndex += 8;
            }
        }

        public boolean check(int x, int y) {
            Building other = Vars.world.build(x, y);
            return AdaptConveyor.this.blends((Building)this, other);
        }

        public void draw() {
            Draw.color((Color)this.team.color, (Color)Pal.gray, (float)0.35f);
            Draw.alpha((float)0.5f);
            Draw.z((float)29.75f);
            Draw.rect((TextureRegion)AdaptConveyor.this.pulseRegions[this.blendbits + AdaptConveyor.this.pulseFrame() * 5], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            Draw.alpha((float)1.0f);
            Draw.mixcol((Color)this.team.color, (Color)Color.clear, (float)0.65f);
            Draw.z((float)29.8f);
            Draw.rect((TextureRegion)AdaptConveyor.this.arrowRegions[AdaptConveyor.this.conveyorFrame()], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            boolean backDraw = true;
            if (AdaptConveyor.this.blends((Building)this, this.right())) {
                Draw.rect((TextureRegion)AdaptConveyor.this.arrowRegions[AdaptConveyor.this.conveyorFrame() + 16], (float)this.x, (float)this.y, (float)(this.rotdeg() + 90.0f));
                backDraw = false;
            }
            if (AdaptConveyor.this.blends((Building)this, this.back())) {
                Draw.rect((TextureRegion)AdaptConveyor.this.arrowRegions[AdaptConveyor.this.conveyorFrame() + 16], (float)this.x, (float)this.y, (float)this.rotdeg());
                backDraw = false;
            }
            if (AdaptConveyor.this.blends((Building)this, this.left())) {
                Draw.rect((TextureRegion)AdaptConveyor.this.arrowRegions[AdaptConveyor.this.conveyorFrame() + 16], (float)this.x, (float)this.y, (float)(this.rotdeg() - 90.0f));
                backDraw = false;
            }
            if (backDraw) {
                Draw.rect((TextureRegion)AdaptConveyor.this.arrowRegions[AdaptConveyor.this.conveyorFrame() + 16], (float)this.x, (float)this.y, (float)this.rotdeg());
            }
            Draw.z((float)29.85f);
            Draw.color((Color)this.team.color, (Color)Color.white, (float)0.3f);
            if (!this.armored) {
                Draw.rect((TextureRegion)AdaptConveyor.this.edgeRegions[this.blendbits], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            } else {
                Draw.rect((TextureRegion)AdaptConveyor.this.armorRegions[this.blendbits], (float)this.x, (float)this.y, (float)(8 * this.blendsclx), (float)(8 * this.blendscly), (float)(this.rotation * 90));
            }
            Draw.color();
            Draw.z((float)29.9f);
            float layer = 29.9f;
            float wwidth = Vars.world.unitWidth();
            float wheight = Vars.world.unitHeight();
            float scaling = 0.01f;
            for (int i = 0; i < this.len; ++i) {
                Item item = this.ids[i];
                Tmp.v1.trns((float)(this.rotation * 90), 8.0f, 0.0f);
                Tmp.v2.trns((float)(this.rotation * 90), -4.0f, this.xs[i] * 8.0f / 2.0f);
                float ix = this.x + Tmp.v1.x * this.ys[i] + Tmp.v2.x;
                float iy = this.y + Tmp.v1.y * this.ys[i] + Tmp.v2.y;
                Draw.z((float)(layer + (ix / wwidth + iy / wheight) * scaling));
                Draw.rect((TextureRegion)item.fullIcon, (float)ix, (float)iy, (float)5.0f, (float)5.0f);
            }
        }

        public boolean acceptItem(Building source, Item item) {
            if (!this.armored) {
                return super.acceptItem(source, item);
            }
            return super.acceptItem(source, item) && (source.block instanceof Conveyor || Edges.getFacingEdge((Tile)source.tile, (Tile)this.tile).relativeTo(this.tile) == this.rotation);
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.armored);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.armored = read.bool();
        }
    }
}

