/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.graphic.DrawFunc;

public class ShieldGenerator
extends BaseTurret {
    public final int timerUse;
    public float shieldArc;
    public float shieldRange;
    public float shieldHealth;
    public float recoverSpeed;
    public float powerCons;
    public float elevation;
    public TextureRegion turret;

    public ShieldGenerator(String name) {
        super(name);
        this.timerUse = this.timers++;
        this.shieldArc = 70.0f;
        this.shieldRange = 250.0f;
        this.shieldHealth = 150000.0f;
        this.recoverSpeed = 166.66667f;
        this.powerCons = 333.33334f;
        this.elevation = -1.0f;
        this.configurable = true;
        this.saveConfig = true;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.envEnabled |= 2;
        this.ambientSound = NHSounds.largeBeam;
        this.ambientSoundVolume = 0.08f;
        this.canOverdrive = false;
        this.rotateSpeed = 0.15f;
        this.range = 265.0f;
        this.size = 5;
        this.clipSize = 600.0f;
        this.health = 20000;
        this.armor = 32.0f;
        this.itemCapacity = 50;
        this.consumePower(this.powerCons);
        this.consumeItem(NHItems.ancimembrane, 2);
        this.config(Float.class, (build, rotation) -> {
            build.targetAngel = rotation.floatValue();
        });
        this.configClear(build -> {
            build.targetAngel = 90.0f;
        });
    }

    public void init() {
        super.init();
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
    }

    public void load() {
        super.load();
        this.turret = Core.atlas.find(this.name + "-turret");
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.turret};
    }

    public void drawPlan(BuildPlan plan, Eachable<BuildPlan> list, boolean valid) {
        super.drawPlan(plan, list, valid);
    }

    public void setBars() {
        super.setBars();
        this.addBar("riftShield", entity -> new Bar("stat.shieldhealth", Pal.accent, () -> 1.0f - entity.buildup / this.shieldHealth).blink(Color.white));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shieldHealth, this.shieldHealth);
        this.stats.add(Stat.cooldownTime, "5s", new Object[0]);
    }

    public class ShieldGeneratorBuild
    extends BaseTurret.BaseTurretBuild
    implements ControlBlock {
        @Nullable
        public BlockUnitc unit;
        public boolean broken;
        public float buildup;
        public float radscl;
        public float hit;
        public float warmup;
        public float targetAngel;
        public Seq<Bullet> absorbedBullets;
        public Vec2 backCenter;
        public Vec2 rightCenter;
        public Vec2 leftCenter;
        protected Rand rand;
        protected Rect rect;

        public ShieldGeneratorBuild() {
            super((BaseTurret)ShieldGenerator.this);
            this.broken = true;
            this.targetAngel = 90.0f;
            this.absorbedBullets = new Seq();
            this.rand = new Rand((long)this.id);
            this.rect = new Rect();
        }

        public void created() {
            super.created();
            this.backCenter = new Vec2(this.x - Angles.trnsx((float)(this.rotation - 180.0f), (float)16.0f), this.y - Angles.trnsy((float)(this.rotation - 180.0f), (float)16.0f));
            this.rightCenter = this.backCenter.cpy().add(Angles.trnsx((float)(this.rotation - ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f), Angles.trnsy((float)(this.rotation - ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f));
            this.leftCenter = this.backCenter.cpy().add(Angles.trnsx((float)(this.rotation + ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f), Angles.trnsy((float)(this.rotation + ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f));
        }

        public Float config() {
            return Float.valueOf(this.targetAngel);
        }

        public void buildConfiguration(Table table) {
            if (Vars.state.isEditor()) {
                table.slider(0.0f, 360.0f, 45.0f, this.rotation, f -> {
                    this.rotation = this.targetAngel = f;
                }).growX().row();
            } else {
                table.slider(0.0f, 360.0f, 45.0f, this.targetAngel, arg_0 -> ((ShieldGeneratorBuild)this).configure(arg_0)).growX().row();
            }
        }

        public float getPercentage() {
            return Mathf.pow((float)((ShieldGenerator.this.shieldHealth + this.buildup) / ShieldGenerator.this.shieldHealth), (float)2.0f);
        }

        public void draw() {
            Draw.rect((TextureRegion)ShieldGenerator.this.region, (float)this.x, (float)this.y);
            Draw.color();
            Draw.z((float)50.0f);
            Drawf.shadow((TextureRegion)ShieldGenerator.this.turret, (float)(this.x - ShieldGenerator.this.elevation), (float)(this.y - ShieldGenerator.this.elevation), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)ShieldGenerator.this.turret, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
            if (!this.broken & this.radscl > 0.0f) {
                this.drawShield();
            }
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)this.range(), (Color)this.team.color);
            Drawf.dashLine((Color)this.team.color, (float)this.x, (float)this.y, (float)this.leftCenter.x, (float)this.leftCenter.y);
            Drawf.dashLine((Color)this.team.color, (float)this.x, (float)this.y, (float)this.rightCenter.x, (float)this.rightCenter.y);
        }

        public boolean shouldAmbientSound() {
            return this.efficiency > 0.0f;
        }

        public void update() {
            super.update();
            this.updateLerpAngel();
            this.updateConsume();
            this.updateShield();
            this.updateBullet();
            this.updateUnit();
            if (this.hit > 1.0f) {
                this.hit = 1.0f;
                this.hit -= 0.016666668f;
            }
        }

        private void updateLerpAngel() {
            if (this.unit != null && this.unit.isShooting()) {
                this.targetAngel = Angles.angle((float)this.x, (float)this.y, (float)this.unit.aimX(), (float)this.unit.aimY());
            }
            this.rotation = Angles.moveToward((float)this.rotation, (float)this.targetAngel, (float)(ShieldGenerator.this.rotateSpeed * this.efficiency));
            this.backCenter = new Vec2(this.x - Angles.trnsx((float)(this.rotation - 180.0f), (float)16.0f), this.y - Angles.trnsy((float)(this.rotation - 180.0f), (float)16.0f));
            this.rightCenter = this.backCenter.cpy().add(Angles.trnsx((float)(this.rotation - ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f), Angles.trnsy((float)(this.rotation - ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f));
            this.leftCenter = this.backCenter.cpy().add(Angles.trnsx((float)(this.rotation + ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f), Angles.trnsy((float)(this.rotation + ShieldGenerator.this.shieldArc / 2.0f), (float)250.0f));
        }

        private void updateConsume() {
            if (!this.broken && this.timer(ShieldGenerator.this.timerUse, 60.0f / this.getPercentage()) && this.efficiency > 0.0f) {
                this.consume();
            }
        }

        private void updateShield() {
            this.radscl = Mathf.lerpDelta((float)this.radscl, (float)(this.broken ? 0.0f : this.warmup), (float)0.025f);
            this.warmup = Mathf.lerpDelta((float)this.warmup, (float)this.efficiency, (float)0.05f);
            if (this.buildup > 0.0f) {
                this.buildup -= this.delta() * ShieldGenerator.this.recoverSpeed * (this.broken ? 2.0f : 1.0f);
            }
            if (this.broken && this.buildup <= 0.0f) {
                this.broken = false;
            }
            if (this.buildup >= ShieldGenerator.this.shieldHealth && !this.broken) {
                this.broken = true;
                this.buildup = ShieldGenerator.this.shieldHealth;
                if (this.team != Vars.state.rules.defaultTeam) {
                    Events.fire((Enum)EventType.Trigger.forceProjectorBreak);
                }
                this.drawShieldBreakFx();
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
        }

        private void updateBullet() {
            if (!this.broken && this.efficiency > 0.01f) {
                Groups.bullet.intersect(this.backCenter.x - ShieldGenerator.this.range, this.backCenter.y - ShieldGenerator.this.range, ShieldGenerator.this.range * 2.0f, ShieldGenerator.this.range * 2.0f, bullet -> {
                    float chance = (2000.0f - bullet.damage) / 2000.0f * 0.8f + 0.2f;
                    float dst = Mathf.dst((float)this.backCenter.x, (float)this.backCenter.y, (float)bullet.x, (float)bullet.y);
                    float angel = Angles.angle((float)this.backCenter.x, (float)this.backCenter.y, (float)bullet.x, (float)bullet.y);
                    boolean in = Angles.within((float)this.rotation, (float)angel, (float)(ShieldGenerator.this.shieldArc / 2.0f));
                    if (dst < 260.0f && dst > 220.0f && bullet.team != this.team && in) {
                        float bAng = bullet.vel.angle() + 180.0f;
                        float nAng = Tmp.v1.set(bullet.x - this.backCenter.x, bullet.y - this.backCenter.y).angle();
                        if (Mathf.chance((double)chance)) {
                            bullet.vel.rotate((nAng - bAng) * 2.0f + 180.0f);
                            bullet.team(this.team);
                        } else {
                            bullet.absorb();
                        }
                        this.hit += bullet.damage / ShieldGenerator.this.recoverSpeed;
                        this.buildup += bullet.damage;
                        NHFx.sharpBlastRand(this.team.color, Color.white, nAng, 90.0f, 65.0f, Mathf.clamp((float)(bullet.damage / 1200.0f)) * 100.0f).at((Position)bullet);
                    }
                });
            }
        }

        private void updateUnit() {
            if (!this.broken && this.efficiency > 0.01f) {
                Units.nearbyEnemies((Team)this.team, (float)this.backCenter.x, (float)this.backCenter.y, (float)ShieldGenerator.this.range, unit -> {
                    float dst = Mathf.dst((float)this.backCenter.x, (float)this.backCenter.y, (float)unit.x, (float)unit.y);
                    float angel = Angles.angle((float)this.backCenter.x, (float)this.backCenter.y, (float)unit.x, (float)unit.y);
                    boolean in = Angles.within((float)this.rotation, (float)angel, (float)(ShieldGenerator.this.shieldArc / 2.0f));
                    if (dst < 260.0f && dst > 220.0f && in) {
                        Vec2 vec2 = new Vec2(unit.x - this.backCenter.x, unit.y - this.backCenter.y);
                        unit.apply(NHStatusEffects.emp3);
                        unit.vel.setZero();
                        unit.move(vec2.setLength(0.5f));
                        this.hit += unit.hitSize * 4.0f / ShieldGenerator.this.recoverSpeed;
                        this.buildup += unit.hitSize * 4.0f;
                    }
                });
            }
        }

        private void drawShield() {
            float sin1 = (Mathf.sin((float)(Time.time / 30.0f)) * 0.12f + 1.0f) * this.radscl;
            float sin2 = (Mathf.sin((float)(Time.time / 30.0f)) * 0.18f + 1.1f) * this.radscl;
            float xStart = this.backCenter.x;
            float yStart = this.backCenter.y;
            Vec2 vec = new Vec2(xStart, yStart);
            if (Vars.state.isPlaying() && this.radscl > 0.01f && Mathf.chanceDelta((double)0.1666666716337204)) {
                PosLightning.createEffect((Position)vec, (Position)this.rightCenter, this.team.color, 1, 2.0f * sin1);
                PosLightning.createEffect((Position)vec, (Position)this.leftCenter, this.team.color, 1, 2.0f * sin1);
            }
            this.drawPulse();
            this.drawWave();
            this.drawTransfer();
            Draw.z((float)110.0f);
            Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
            Fill.circle((float)xStart, (float)yStart, (float)(15.0f * sin1));
            Fill.circle((float)this.rightCenter.x, (float)this.rightCenter.y, (float)(15.0f * sin1));
            Fill.circle((float)this.leftCenter.x, (float)this.leftCenter.y, (float)(15.0f * sin1));
            Lines.stroke((float)(16.0f * sin1));
            Lines.arc((float)this.backCenter.x, (float)this.backCenter.y, (float)250.0f, (float)0.19444445f, (float)(this.rotation - 35.0f));
            Draw.z((float)110.0001f);
            Draw.color((Color)Color.black);
            Fill.circle((float)xStart, (float)yStart, (float)(9.0f * sin2));
            Fill.circle((float)this.rightCenter.x, (float)this.rightCenter.y, (float)(9.0f * sin2));
            Fill.circle((float)this.leftCenter.x, (float)this.leftCenter.y, (float)(9.0f * sin2));
            Lines.stroke((float)(9.0f * sin2));
            Lines.arc((float)this.backCenter.x, (float)this.backCenter.y, (float)250.0f, (float)0.19444445f, (float)(this.rotation - 35.0f));
            Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
            Draw.z((float)110.0002f);
            if (this.radscl > 0.01f) {
                DrawFunc.surround(this.id, this.rightCenter.x, this.rightCenter.y, 22.0f, 6, 4.0f, 6.0f, sin1);
                DrawFunc.surround(this.id + 1, this.leftCenter.x, this.leftCenter.y, 22.0f, 6, 4.0f, 6.0f, sin1);
                DrawFunc.surround(this.id + 2, this.backCenter.x, this.backCenter.y, 22.0f, 8, 3.0f, 5.0f, sin1);
            }
        }

        private void drawPulse() {
            Draw.z((float)110.0f);
            Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
            Draw.alpha((float)0.75f);
            float base = Time.time / 400.0f / (this.buildup / ShieldGenerator.this.shieldHealth * 0.5f + 1.0f);
            for (int i = 0; i < 60; ++i) {
                this.rand.setSeed((long)(this.id + i));
                float fin = (this.rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float dst = 250.0f;
                float deg = this.rotation + (ShieldGenerator.this.shieldArc / 2.0f - fin * ShieldGenerator.this.shieldArc) * (this.rand.chance(0.5) ? -1.0f : 1.0f);
                float xShift = Angles.trnsx((float)deg, (float)dst);
                float yShift = Angles.trnsy((float)deg, (float)dst);
                Fill.circle((float)(this.backCenter.x + xShift), (float)(this.backCenter.y + yShift), (float)((float)this.rand.random(10, 12) * (0.8f + Mathf.sin((float)(Time.time / 60.0f + this.rand.random((float)Math.PI * 2))) * 0.2f) * this.radscl * (this.buildup / ShieldGenerator.this.shieldHealth * 0.5f + 1.0f)));
            }
            Draw.alpha((float)1.0f);
        }

        private void drawWave() {
            float base = Time.time / 120.0f;
            Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
            Draw.z((float)110.0f);
            for (int i = 0; i < 10; ++i) {
                Rand rand = new Rand((long)(this.id + i));
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float deg = rand.random(360.0f);
                float pos = rand.random(12.0f);
                float len = rand.random(12, 18);
                Tmp.v1.set(Mathf.sinDeg((float)deg) * pos, Mathf.cosDeg((float)deg) * pos);
                Lines.stroke((float)(4.0f * fout * this.radscl));
                if (rand.chance(0.5)) {
                    Lines.circle((float)(this.leftCenter.x + Tmp.v1.x), (float)(this.leftCenter.y + Tmp.v1.y), (float)(len * fin * this.radscl));
                    continue;
                }
                Lines.circle((float)(this.rightCenter.x + Tmp.v1.x), (float)(this.rightCenter.y + Tmp.v1.y), (float)(len * fin * this.radscl));
            }
        }

        private void drawTransfer() {
            float base = Time.time / 250.0f;
            Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
            Draw.z((float)110.0f);
            for (int i = 0; i < 30; ++i) {
                this.rand.setSeed((long)(this.id + i));
                float fin = (this.rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float dst = 250.0f;
                float deg = this.rotation + this.rand.random(-ShieldGenerator.this.shieldArc / 2.0f, ShieldGenerator.this.shieldArc / 2.0f);
                float xEnd = Angles.trnsx((float)deg, (float)dst);
                float yEnd = Angles.trnsy((float)deg, (float)dst);
                Vec2 pos = this.backCenter.cpy().add(xEnd, yEnd);
                float ang = Angles.angle((float)this.x, (float)this.y, (float)pos.x, (float)pos.y);
                float start = this.rand.random(0.2f, 0.4f);
                Tmp.v1.set(this.x, this.y);
                Tmp.v1.lerp(pos, fin * start + (1.0f - start));
                Fill.poly((float)Tmp.v1.x, (float)Tmp.v1.y, (int)6, (float)(this.rand.random(5.0f, 8.0f) * fin * this.radscl), (float)(ang + (float)this.rand.random(-30, 30)));
            }
        }

        private void drawShieldBreakFx() {
            Effect effect1 = new Effect(135.0f, e -> {
                float sin1 = (Mathf.sin((float)(Time.time / 30.0f)) * 0.12f + 1.0f) * this.radscl * e.fout();
                float sin2 = (Mathf.sin((float)(Time.time / 30.0f)) * 0.18f + 1.1f) * this.radscl * e.fout();
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                Fill.circle((float)this.x, (float)this.y, (float)(22.0f * sin1));
                Fill.circle((float)this.rightCenter.x, (float)this.rightCenter.y, (float)(15.0f * sin1));
                Fill.circle((float)this.leftCenter.x, (float)this.leftCenter.y, (float)(15.0f * sin1));
                Lines.stroke((float)(16.0f * sin1));
                Lines.arc((float)this.backCenter.x, (float)this.backCenter.y, (float)250.0f, (float)0.19444445f, (float)(this.rotation - 35.0f));
                Draw.color((Color)Color.black);
                Fill.circle((float)this.x, (float)this.y, (float)(12.0f * sin2));
                Fill.circle((float)this.rightCenter.x, (float)this.rightCenter.y, (float)(9.0f * sin2));
                Fill.circle((float)this.leftCenter.x, (float)this.leftCenter.y, (float)(9.0f * sin2));
                Lines.stroke((float)(9.0f * sin2));
                Lines.arc((float)this.backCenter.x, (float)this.backCenter.y, (float)250.0f, (float)0.19444445f, (float)(this.rotation - 35.0f));
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                DrawFunc.surround(this.id, this.rightCenter.x, this.rightCenter.y, 22.0f, 6, 4.0f, 6.0f, sin1);
                DrawFunc.surround(this.id + 1, this.leftCenter.x, this.leftCenter.y, 22.0f, 6, 4.0f, 6.0f, sin1);
            });
            Effect effect2 = new Effect(80.0f, e -> {
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                Angles.randLenVectors((long)this.id, (int)120, (float)250.0f, (float)(this.rotation - ShieldGenerator.this.shieldArc / 2.0f), (float)ShieldGenerator.this.shieldArc, (x, y) -> {
                    this.rand.setSeed((long)((float)e.id + (x + y)));
                    float dst = ShieldGenerator.this.shieldRange;
                    float deg = this.rotation + this.rand.random(-ShieldGenerator.this.shieldArc / 2.0f, ShieldGenerator.this.shieldArc / 2.0f);
                    float xEnd = Angles.trnsx((float)deg, (float)dst);
                    float yEnd = Angles.trnsy((float)deg, (float)dst);
                    Vec2 pos = this.backCenter.cpy().add(xEnd, yEnd);
                    float ang = Angles.angle((float)x, (float)y, (float)pos.x, (float)pos.y) + this.rand.random(-30.0f, 30.0f);
                    float start = this.rand.random(-0.6f, 0.6f);
                    Tmp.v1.set(x, y);
                    Tmp.v1.lerp(pos, e.fout(Interp.smooth) * start + (1.0f - start));
                    Fill.poly((float)Tmp.v1.x, (float)Tmp.v1.y, (int)6, (float)(this.rand.random(12.0f, 18.0f) * e.fout(Interp.smooth) * this.radscl), (float)(ang + (float)this.rand.random(-30, 30)));
                });
            });
            effect1.at((Position)this);
            effect2.at((Position)this);
        }

        public Unit unit() {
            if (this.unit == null) {
                this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
                this.unit.tile((Building)this);
            }
            return (Unit)this.unit;
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.broken);
            write.f(this.buildup);
            write.f(this.radscl);
            write.f(this.warmup);
            write.f(this.rotation);
            write.f(this.targetAngel);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.broken = read.bool();
            this.buildup = read.f();
            this.radscl = read.f();
            this.warmup = read.f();
            this.rotation = read.f();
            this.targetAngel = read.f();
        }
    }
}

