/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.gen.WaterMovec;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.Stat;
import newhorizon.content.NHContent;
import newhorizon.expand.entities.Carrier;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.ui.TableFunc;

public class HyperSpaceWarper
extends Block {
    private static Tile furthest;
    public float reloadTime = 3600.0f;
    public DrawBlock drawer = new DrawDefault();
    public Effect completeEffect = Fx.none;
    public float completeEffectChance = 0.075f;
    public Effect triggerEffect = new Effect(16.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(3.0f - e.fin() * 2.0f));
        Lines.square((float)e.x, (float)e.y, (float)(4.0f * e.rotation + e.fin() * 5.0f));
    });

    public HyperSpaceWarper(String name) {
        super(name);
        this.configurable = true;
        this.update = true;
        this.canOverdrive = true;
        this.solid = true;
        this.config(Point2.class, HyperSpaceWarperBuild::setTarget);
        this.config(IntSeq.class, HyperSpaceWarperBuild::setSelects);
        this.config(Integer.class, HyperSpaceWarperBuild::teleport);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        this.drawer.getRegionsToOutline((Block)this, out);
    }

    public void setBars() {
        super.setBars();
        this.addBar("upgradeProgress", entity -> new Bar(() -> Core.bundle.get("bar.progress"), () -> Pal.lancerLaser, () -> entity.reload / this.reloadTime));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, t -> {
            t.row().left();
            t.add((CharSequence)"").row();
            t.table(i -> {
                i.image().size(60.0f).color(Pal.lancerLaser).left();
                i.add((CharSequence)Core.bundle.get("mod.ui.gravity-trap-field-friendly")).growX().padLeft(6.0f).row();
            }).padTop(12.0f).growX().fillY().row();
            t.table(i -> {
                i.image().size(60.0f).color(Pal.redderDust).left();
                i.add((CharSequence)Core.bundle.get("mod.ui.gravity-trap-field-hostile")).growX().padLeft(6.0f).row();
            }).padTop(12.0f).growX().fillY().row();
        });
    }

    public class HyperSpaceWarperBuild
    extends Building {
        public float reload;
        public float warmup;
        public int target;
        public IntSeq selects = new IntSeq();
        public Vec2 targetV = new Vec2().set((Position)this);
        public transient boolean isJammed = false;
        public transient Vec2 interceptedPos = new Vec2(this.x, this.y);
        public transient float totalProgress = 0.0f;

        public float warmup() {
            return this.reload / HyperSpaceWarper.this.reloadTime;
        }

        public float progress() {
            return this.reload / HyperSpaceWarper.this.reloadTime;
        }

        public float totalProgress() {
            return this.totalProgress;
        }

        public Building init(Tile tile, Team team, boolean shouldAdd, int rotation) {
            return super.init(tile, team, shouldAdd, rotation);
        }

        public boolean onConfigureBuildTapped(Building other) {
            return this == other;
        }

        public boolean chargeValid() {
            return this.reload > HyperSpaceWarper.this.reloadTime;
        }

        public void updateTile() {
            if (this.efficiency > 0.0f) {
                this.totalProgress += this.edelta();
                if (!this.chargeValid()) {
                    this.reload += this.efficiency * this.delta();
                } else if (Mathf.chanceDelta((double)HyperSpaceWarper.this.completeEffectChance)) {
                    HyperSpaceWarper.this.completeEffect.at(this.x + (float)Mathf.range((int)(8 * HyperSpaceWarper.this.size / 2)), this.y + (float)Mathf.range((int)(8 * HyperSpaceWarper.this.size / 2)), this.team.color);
                }
            }
            this.warmup = this.efficiency > 0.0f && this.chargeValid() ? (Mathf.equal((float)this.warmup, (float)1.0f, (float)0.0015f) ? 1.0f : Mathf.lerpDelta((float)this.warmup, (float)1.0f, (float)0.01f)) : (Mathf.equal((float)this.warmup, (float)0.0f, (float)0.0015f) ? 0.0f : Mathf.lerpDelta((float)this.warmup, (float)0.0f, (float)0.03f));
        }

        public void draw() {
            HyperSpaceWarper.this.drawer.draw((Building)this);
            Draw.z((float)102.0f);
            Draw.color((Color)this.team.color);
            TextureRegion arrowRegion = NHContent.arrowRegion;
            for (int l = 0; l < 4; ++l) {
                float angle = 45 + 90 * l;
                float regSize = (float)HyperSpaceWarper.this.size / 12.0f;
                for (int i = 0; i < 4; ++i) {
                    float angle2 = angle + (float)Mathf.sign((i % 2 == 0 ? 1 : 0) != 0) * DrawFunc.rotator_90(DrawFunc.cycle(25 * i, 100.0f), 0.05f * (float)i + 0.01f);
                    Tmp.v1.trns(angle2, (float)((i - 4) * 8));
                    float f = (100.0f - (Time.time - (float)(25 * i)) % 100.0f) / 100.0f;
                    Draw.rect((TextureRegion)arrowRegion, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)((float)arrowRegion.width * regSize * f * this.warmup), (float)((float)arrowRegion.height * regSize * f * this.warmup), (float)(angle2 - 90.0f));
                }
            }
            Drawf.light((Position)this.tile, (float)((float)(HyperSpaceWarper.this.size * 8 * 3) * this.warmup), (Color)this.team.color, (float)0.85f);
        }

        public boolean canTeleport() {
            return this.chargeValid() || this.cheating();
        }

        public void placed() {
            super.placed();
        }

        public void setTarget(Point2 p) {
            this.target = p.pack();
            this.targetV.set(World.unconv((float)p.x), World.unconv((float)p.y));
        }

        public void setSelects(IntSeq seq) {
            this.selects = seq;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.target = read.i();
            this.warmup = read.f();
            this.reload = read.f();
            this.targetV = TypeIO.readVec2((Reads)read);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.target);
            write.f(this.warmup);
            write.f(this.reload);
            TypeIO.writeVec2((Writes)write, (Vec2)this.targetV);
        }

        public void buildConfiguration(Table table) {
            table.table(p -> {
                p.update(() -> {
                    Vars.control.input.commandMode = true;
                });
                p.table(Tex.paneSolid, t -> {
                    t.button("@mod.ui.select-target", (Drawable)Icon.move, Styles.cleart, () -> TableFunc.selectPos(table, (Cons<Point2>)((Cons)arg_0 -> ((HyperSpaceWarperBuild)this).configure(arg_0)))).size(240.0f, 60.0f).row();
                    t.button("@mod.ui.select-unit", (Drawable)Icon.filter, Styles.cleart, () -> this.configure(Vars.control.input.selectedUnits.mapInt(Unit::id))).size(240.0f, 60.0f).disabled(b -> Vars.control.input.selectedUnits.isEmpty()).row();
                    t.button("@mod.ui.transport-unit", (Drawable)Icon.download, Styles.cleart, () -> this.configure(Math.max(4, (int)Mathf.sqrt((float)((float)this.selects.size / (float)Math.PI)) + 2))).size(240.0f, 60.0f).disabled(b -> !this.canTeleport()).row();
                    if (Vars.mobile) {
                        t.button("@back", (Drawable)Icon.leftOpen, Styles.cleart, () -> {
                            this.deselect();
                            Vars.control.input.inv.hide();
                            p.update(() -> {});
                            Core.app.post(() -> {
                                Vars.control.input.commandRect = false;
                                Vars.control.input.commandMode = false;
                            });
                        }).size(240.0f, 60.0f).row();
                    }
                }).fill();
            }).fill().row();
        }

        public void teleport(int spawnRange) {
            Tmp.p1.set(Point2.unpack((int)this.target));
            if (this.selects.isEmpty() || Vars.world.tile(this.target) == null) {
                return;
            }
            Rand rand = NHFunc.rand;
            rand.setSeed((long)this.core().items.total());
            ObjectMap spawnPos = new ObjectMap(this.selects.size + 1);
            Seq air = new Seq();
            Seq ground = new Seq();
            Seq navy = new Seq();
            Seq<Boolf<Tile>> request = NHFunc.formats();
            air.addAll(NHFunc.getAcceptableTiles(Tmp.p1.x, Tmp.p1.y, spawnRange, (Boolf<Tile>)((Boolf)request.get(0))));
            navy.addAll(NHFunc.getAcceptableTiles(Tmp.p1.x, Tmp.p1.y, spawnRange, (Boolf<Tile>)((Boolf)request.get(1))));
            ground.addAll(NHFunc.getAcceptableTiles(Tmp.p1.x, Tmp.p1.y, spawnRange, (Boolf<Tile>)((Boolf)request.get(2))));
            this.isJammed = false;
            for (int id : this.selects.items) {
                Unit u = (Unit)Groups.unit.getByID(id);
                if (u == null) continue;
                if (u.type.flying) {
                    if (air.isEmpty()) {
                        this.isJammed = true;
                        return;
                    }
                    spawnPos.put((Object)u, (Object)new Vec2().set((Position)air.remove(rand.nextInt(air.size))));
                    continue;
                }
                if (u instanceof WaterMovec) {
                    if (navy.isEmpty()) {
                        this.isJammed = true;
                        return;
                    }
                    spawnPos.put((Object)u, (Object)new Vec2().set((Position)navy.remove(rand.nextInt(navy.size))));
                    continue;
                }
                if (ground.isEmpty()) {
                    this.isJammed = true;
                    return;
                }
                spawnPos.put((Object)u, (Object)new Vec2().set((Position)ground.remove(rand.nextInt(ground.size))));
            }
            float angle = this.angleTo(Tmp.p1.x * 8, Tmp.p1.y * 8);
            for (Unit u : spawnPos.keys()) {
                Carrier c = (Carrier)Pools.obtain(Carrier.class, Carrier::new);
                c.init(u, (Vec2)spawnPos.get((Object)u), angle);
                c.set((Position)u);
                c.add();
            }
            this.selects.clear();
            this.consume();
            this.reload = 0.0f;
            HyperSpaceWarper.this.triggerEffect.at(this.x, this.y, this.team.color);
        }

        public Vec2 onAveragePos(Vec2 vec2) {
            if (this.selects.isEmpty()) {
                return vec2;
            }
            float avgX = 0.0f;
            float avgY = 0.0f;
            for (int id : this.selects.items) {
                Unit u = (Unit)Groups.unit.getByID(id);
                if (u == null) continue;
                avgX += u.x;
                avgY += u.y;
            }
            return vec2.set(avgX /= (float)this.selects.size, avgY /= (float)this.selects.size);
        }

        public void drawConfigure() {
            super.drawConfigure();
            Seq selectedUnits = Vars.control.input.selectedUnits;
            selectedUnits.removeAll(u -> !u.isCommandable());
            Draw.color((Color)this.team.color);
            for (Unit unit : selectedUnits) {
                Drawf.square((float)unit.x, (float)unit.y, (float)(unit.hitSize / 1.4f + 1.0f), (float)(DrawFunc.rotator_90() + 45.0f));
            }
            if (!this.selects.isEmpty()) {
                for (Object id : (Object)this.selects.items) {
                    Unit unit = (Unit)Groups.unit.getByID((int)id);
                    if (unit == null) continue;
                    Drawf.square((float)unit.x, (float)unit.y, (float)(unit.hitSize / 3.0f), (float)(-DrawFunc.rotator_90() + 45.0f));
                    for (int i = 0; i < 4; ++i) {
                        Tmp.v1.trns(DrawFunc.rotator_90() + 45.0f + (float)(i * 90), unit.hitSize / 1.9f);
                        DrawFunc.arrow(NHContent.arrowRegion, unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, 1.0f, Tmp.v1.angle() + 90.0f, this.team.color.cpy().lerp(Color.white, 0.05f + Mathf.absin((float)4.0f, (float)0.1f)));
                    }
                }
            }
            if (!this.selects.isEmpty()) {
                this.onAveragePos(Tmp.v6);
                Drawf.square((float)Tmp.v6.x, (float)Tmp.v6.y, (float)12.0f, (float)45.0f, (Color)this.team.color);
                DrawFunc.posSquareLink(this.team.color, 3.0f, 4.0f, true, Tmp.v6.x, Tmp.v6.y, this.targetV.x, this.targetV.y);
                Drawf.arrow((float)Tmp.v6.x, (float)Tmp.v6.y, (float)this.targetV.x, (float)this.targetV.y, (float)16.0f, (float)8.0f, (Color)this.team.color);
                Draw.reset();
            }
            Drawf.square((float)this.targetV.x, (float)this.targetV.y, (float)14.0f, (float)(45.0f + DrawFunc.rotator_90()), (Color)this.team.color);
            if (this.isJammed) {
                DrawFunc.overlayText(Core.bundle.get("spawn-error"), this.x, this.y, (float)(HyperSpaceWarper.this.size * 8) / 2.0f, Pal.redderDust, true);
            }
        }
    }
}

