/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Posc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.type.Category;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.expand.bullets.AdaptedSapBulletType;
import newhorizon.util.feature.PosLightning;

public class ChargeWall
extends Block {
    public TextureRegion heatRegion;
    public TextureRegion lightRegion;
    public float maxEnergy;
    public float maxHeat;
    public float heatPerRise;
    public float healLightStMin;
    public float healReloadTime;
    public float healPerEnr;
    public float healPercent;
    public float shootReloadTime;
    public float shootPerEnr;
    public float shootDamage;
    public float coolingReloadTime;
    public float chargeCoefficient;
    public float range;
    public int lightningActHits;
    public Color effectColor;
    public Effect chargeActEffect;
    public Effect hitEffect;
    public Effect shootEffect;
    public Effect onDestroyedEffect;
    public BulletType releaseType;
    Cons<ChargeWallBuild> closestTargetAct;
    Cons<ChargeWallBuild> maxChargeAct;
    Cons<ChargeWallBuild> destroyAct;

    public ChargeWall(String name) {
        super(name);
        this.maxEnergy = this.size * this.size * 3000;
        this.maxHeat = this.size * this.size * 400;
        this.heatPerRise = 50.0f;
        this.healLightStMin = 0.35f;
        this.healReloadTime = 75.0f;
        this.healPerEnr = 55.0f;
        this.healPercent = this.size;
        this.shootReloadTime = 20.0f;
        this.shootPerEnr = 80.0f;
        this.shootDamage = 50.0f;
        this.coolingReloadTime = 30.0f;
        this.chargeCoefficient = 1.1f;
        this.range = 200.0f;
        this.lightningActHits = this.size * this.size * 4;
        this.effectColor = NHColor.lightSkyBack;
        this.chargeActEffect = NHFx.circleSplash;
        this.hitEffect = NHFx.circleSplash;
        this.shootEffect = NHFx.circleSplash;
        this.onDestroyedEffect = Fx.none;
        this.releaseType = new AdaptedSapBulletType(){
            {
                this.damage = ChargeWall.this.shootDamage;
                this.status = StatusEffects.none;
                this.sapStrength = 0.45f;
                this.length = this.range;
                this.drawSize = this.range * 2.0f;
                this.hitColor = this.color = ChargeWall.this.effectColor;
                this.despawnEffect = this.shootEffect = Fx.none;
                this.width = 0.62f;
                this.lifetime = 35.0f;
            }
        };
        this.closestTargetAct = tile -> PosLightning.create((Entityc)tile, tile.team, (Position)tile, (Position)tile.target, this.effectColor, true, this.shootDamage, 4, 2.5f, 2, (Cons<Position>)((Cons)target -> {
            this.hitEffect.at(target.getX(), target.getY(), tile.angleTo((Position)target), this.effectColor);
            this.shootEffect.at(tile.x, tile.y, this.effectColor);
            this.releaseType.create((Entityc)tile, tile.team, tile.x, tile.y, tile.angleTo((Position)target));
        }));
        this.maxChargeAct = tile -> {
            this.chargeActEffect.at(tile.x, tile.y, this.effectColor);
            PosLightning.createRandom(tile.team, (Position)tile, tile.range(), this.effectColor, true, this.shootDamage, 8, 2.5f, 3, (Cons<Position>)((Cons)p -> NHFx.lightningHitSmall.at(tile.x, tile.y, this.effectColor)));
        };
        this.destroyAct = tile -> {
            this.onDestroyedEffect.at(tile.x, tile.y, this.effectColor);
            PosLightning.createRandomRange(tile.team, (Position)tile, tile.range(), this.effectColor, true, this.shootDamage * 3.0f, 10, 2.5f, 3, 8, (Cons<Position>)((Cons)p -> NHFx.lightningHitLarge.at(tile.x, tile.y, this.effectColor)));
        };
        this.update = true;
        this.category = Category.defense;
        this.solid = true;
        this.destructible = true;
        this.group = BlockGroup.walls;
        this.buildCostMultiplier = 3.0f;
        this.canOverdrive = false;
        this.attacks = true;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public void setBars() {
        super.setBars();
        this.addBar("Energy", entity -> new Bar(() -> "Energy", () -> NHColor.lightSkyBack, () -> entity.energy / this.maxEnergy));
        this.addBar("Heat", entity -> new Bar(() -> "Heat", () -> Color.valueOf((String)"#FF732A"), () -> entity.heat / this.maxHeat));
    }

    public void load() {
        super.load();
        this.heatRegion = Core.atlas.find(this.name + "-heat");
        this.lightRegion = Core.atlas.find(this.name + "-light");
    }

    public class ChargeWallBuild
    extends Building
    implements Ranged {
        public float energy;
        public float healReload;
        public float dmgScl = 1.0f;
        public float heat;
        public float shootHeat;
        public float shootReload;
        public float coolingReload;
        public Posc target;

        public float range() {
            return ChargeWall.this.range;
        }

        public float handleDamage(float amount) {
            return amount * this.dmgScl;
        }

        public boolean collision(Bullet other) {
            float dmg = other.damage() * other.type().buildingDamageMultiplier;
            this.damage(dmg);
            this.energy += ChargeWall.this.chargeCoefficient * dmg * this.dmgScl;
            return true;
        }

        public void updateTile() {
            this.coolingReload += Time.delta;
            if (this.coolingReload > ChargeWall.this.coolingReloadTime) {
                this.updateCooling();
            }
            this.shootHeat = Mathf.lerpDelta((float)this.shootHeat, (float)0.0f, (float)0.015f);
            if (this.timer(0, 20.0f)) {
                this.findTarget();
            }
            if (!this.validateTarget()) {
                this.target = null;
            } else if (this.energy > ChargeWall.this.shootPerEnr) {
                this.updateShooting();
            }
            this.fixEnr();
            this.updateHealTile();
            if (this.energy > ChargeWall.this.maxEnergy) {
                ChargeWall.this.maxChargeAct.get((Object)this);
                this.heatRise();
            }
            if (this.heat > ChargeWall.this.maxHeat * ChargeWall.this.healLightStMin && Mathf.chance((double)(0.15f * Time.delta))) {
                Fx.reactorsmoke.at((float)(this.tile.x + Mathf.range((int)(ChargeWall.this.size * 8 / 2))), (float)(this.tile.y + Mathf.range((int)(ChargeWall.this.size * 8 / 2))));
            }
        }

        public void onDestroyed() {
            super.onDestroyed();
            ChargeWall.this.destroyAct.get((Object)this);
            if (this.target != null) {
                ChargeWall.this.closestTargetAct.get((Object)this);
            }
        }

        protected void updateShooting() {
            this.coolingReload = 0.0f;
            if (this.shootReload < ChargeWall.this.shootReloadTime) {
                this.shootReload += Time.delta;
            } else {
                this.energy -= ChargeWall.this.shootPerEnr;
                this.shootReload = 0.0f;
                this.shootHeat = 1.0f;
                ChargeWall.this.closestTargetAct.get((Object)this);
            }
        }

        protected void updateCooling() {
            this.energy = Mathf.lerpDelta((float)this.energy, (float)0.0f, (float)0.015f);
            this.heat = Mathf.lerpDelta((float)this.heat, (float)0.0f, (float)0.015f);
        }

        protected void findTarget() {
            this.target = Units.closestTarget((Team)this.team, (float)this.x, (float)this.y, (float)this.range());
        }

        protected boolean validateTarget() {
            return !Units.invalidateTarget((Posc)this.target, (Team)this.team, (float)this.x, (float)this.y);
        }

        protected void fixEnr() {
            if (this.energy < 0.0f) {
                this.energy = 0.0f;
            }
        }

        protected void updateHealTile() {
            if (this.energy < ChargeWall.this.healPerEnr) {
                return;
            }
            if (this.healReload < ChargeWall.this.healReloadTime) {
                this.healReload += Time.delta;
            } else {
                this.energy -= ChargeWall.this.healPerEnr;
                this.healReload = 0.0f;
                Fx.healBlockFull.at(this.x, this.y, (float)this.block.size, ChargeWall.this.effectColor);
                if (this.healthf() > 0.975f) {
                    this.heat -= ChargeWall.this.healPercent * ChargeWall.this.maxHeat;
                }
                this.heal(ChargeWall.this.healPercent * this.maxHealth);
            }
        }

        protected void heatRise() {
            this.energy = 0.0f;
            if (this.heat < ChargeWall.this.maxHeat) {
                this.heat += ChargeWall.this.heatPerRise;
            } else {
                this.onDestroyed();
                this.kill();
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)ChargeWall.this.region, (float)this.x, (float)this.y);
            Draw.z((float)100.0f);
            Draw.color((Color)ChargeWall.this.effectColor);
            Draw.alpha((float)(this.energy / ChargeWall.this.maxEnergy * 4.0f));
            Draw.rect((TextureRegion)ChargeWall.this.lightRegion, (float)this.x, (float)this.y);
            Draw.reset();
            if (this.heat > ChargeWall.this.maxHeat * ChargeWall.this.healLightStMin) {
                Draw.blend((Blending)Blending.additive);
                float flash = 1.0f + (this.heat - ChargeWall.this.maxHeat * ChargeWall.this.healLightStMin) / (1.0f - ChargeWall.this.maxHeat * ChargeWall.this.healLightStMin) * 5.4f;
                flash += flash * Time.delta;
                Draw.color((Color)Color.red, (Color)Color.yellow, (float)Mathf.absin((float)flash, (float)9.0f, (float)1.0f));
                Draw.alpha((float)0.6f);
                Draw.rect((TextureRegion)ChargeWall.this.heatRegion, (float)this.x, (float)this.y);
            }
            Draw.blend();
            Draw.reset();
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)this.range(), (Color)this.team.color);
        }
    }
}

