/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.defence;

import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawDefault;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import newhorizon.content.NHStats;

public class AdaptRegenProjector
extends Block {
    private static final IntSet taken = new IntSet();
    private static final IntFloatMap mendMap = new IntFloatMap();
    private static long lastUpdateFrame = -1L;
    public int range = 14;
    public float baseHeal = 0.5f;
    public float healPercent = 0.2f;
    public float optionalMultiplier = 2.0f;
    public float optionalUseTime = 480.0f;
    public DrawBlock drawer = new DrawDefault();
    public float effectChance = 0.003f;
    public Color baseColor = Pal.heal;
    public Effect effect = Fx.regenParticle;

    public AdaptRegenProjector(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.group = BlockGroup.projectors;
        this.hasPower = true;
        this.hasItems = true;
        this.emitLight = true;
        this.suppressable = true;
        this.envEnabled |= 2;
        this.rotateDraw = false;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.blockRepair});
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        x *= 8;
        y *= 8;
        Drawf.dashSquare((Color)this.baseColor, (float)(x += (int)this.offset), (float)(y += (int)this.offset), (float)(this.range * 8));
        Vars.indexer.eachBlock(Vars.player.team(), Tmp.r1.setCentered((float)x, (float)y, (float)(this.range * 8)), b -> true, t -> Drawf.selected((Building)t, (Color)Tmp.c1.set(this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f))));
    }

    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawer.drawPlan((Block)this, plan, list);
    }

    public boolean outputsItems() {
        return false;
    }

    public TextureRegion[] icons() {
        return this.drawer.finalIcons((Block)this);
    }

    public void load() {
        super.load();
        this.drawer.load((Block)this);
    }

    public void setStats() {
        this.stats.timePeriod = this.optionalUseTime;
        super.setStats();
        this.stats.add(Stat.repairTime, (float)((int)(1.0f / (this.healPercent / 100.0f) / 60.0f)), StatUnit.seconds);
        this.stats.add(NHStats.baseRepairAmount, (float)((int)(this.baseHeal * 60.0f)), StatUnit.perSecond);
        this.stats.add(Stat.range, (float)this.range, StatUnit.blocks);
        Consume consume = this.findConsumer(c -> c instanceof ConsumeItems);
        if (consume instanceof ConsumeItems) {
            ConsumeItems cons = (ConsumeItems)consume;
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.itemBoosters((String)("{0}" + StatUnit.timesSpeed.localized()), (float)this.stats.timePeriod, (float)this.optionalMultiplier, (float)0.0f, (ItemStack[])cons.items));
        }
    }

    public class RegenProjectorBuild
    extends Building {
        public Seq<Building> targets = new Seq();
        public int lastChange = -2;
        public float warmup;
        public float totalTime;
        public float optionalTimer;
        public boolean anyTargets = false;
        public boolean didRegen = false;

        public void updateTargets() {
            this.targets.clear();
            taken.clear();
            Vars.indexer.eachBlock(this.team, Tmp.r1.setCentered(this.x, this.y, (float)(AdaptRegenProjector.this.range * 8)), b -> true, arg_0 -> this.targets.add(arg_0));
        }

        public void updateTile() {
            if (this.lastChange != Vars.world.tileChanges) {
                this.lastChange = Vars.world.tileChanges;
                this.updateTargets();
            }
            this.warmup = Mathf.approachDelta((float)this.warmup, (float)(this.didRegen ? 1.0f : 0.0f), (float)0.014285714f);
            this.totalTime += this.warmup * Time.delta;
            this.didRegen = false;
            this.anyTargets = false;
            if (this.checkSuppression()) {
                return;
            }
            this.anyTargets = this.targets.contains(Building::damaged);
            if (this.efficiency > 0.0f) {
                float f;
                this.optionalTimer += Time.delta * this.optionalEfficiency;
                if (f >= AdaptRegenProjector.this.optionalUseTime) {
                    this.consume();
                    this.optionalTimer = 0.0f;
                }
                float healAmount = Mathf.lerp((float)1.0f, (float)AdaptRegenProjector.this.optionalMultiplier, (float)this.optionalEfficiency) * AdaptRegenProjector.this.healPercent;
                for (Building build : this.targets) {
                    if (!build.damaged() || build.isHealSuppressed()) continue;
                    this.didRegen = true;
                    int pos = build.pos();
                    float value = mendMap.get(pos);
                    mendMap.put(pos, Math.min(Math.max(value, healAmount * this.edelta() * (float)build.block.health / 100.0f), (float)build.block.health - build.health));
                    if (!(value <= 0.0f) || !Mathf.chanceDelta((double)(AdaptRegenProjector.this.effectChance * (float)build.block.size * (float)build.block.size))) continue;
                    AdaptRegenProjector.this.effect.at(build.x + Mathf.range((float)((float)(build.block.size * 8) / 2.0f - 1.0f)), build.y + Mathf.range((float)((float)(build.block.size * 8) / 2.0f - 1.0f)));
                }
            }
            if (lastUpdateFrame != Vars.state.updateId) {
                lastUpdateFrame = Vars.state.updateId;
                for (IntFloatMap.Entry entry : mendMap.entries()) {
                    Building build;
                    build = Vars.world.build(entry.key);
                    if (build == null) continue;
                    build.heal(Math.max(entry.value, AdaptRegenProjector.this.baseHeal * this.edelta()));
                    build.recentlyHealed();
                }
                mendMap.clear();
            }
        }

        public boolean shouldConsume() {
            return this.anyTargets;
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashSquare((Color)AdaptRegenProjector.this.baseColor, (float)this.x, (float)this.y, (float)(AdaptRegenProjector.this.range * 8));
            for (Building target : this.targets) {
                Drawf.selected((Building)target, (Color)Tmp.c1.set(AdaptRegenProjector.this.baseColor).a(Mathf.absin((float)4.0f, (float)1.0f)));
            }
        }

        public float warmup() {
            return this.warmup;
        }

        public float totalProgress() {
            return this.totalTime;
        }

        public void draw() {
            AdaptRegenProjector.this.drawer.draw((Building)this);
        }

        public void drawLight() {
            super.drawLight();
            AdaptRegenProjector.this.drawer.drawLight((Building)this);
        }
    }
}

