/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.consumer;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.StatValues;
import newhorizon.expand.type.Recipe;

public class ConsumeRecipe
extends Consume {
    @Nullable
    public final Func<Building, Recipe> recipe;
    public final Func<Building, Recipe> display;

    public <T extends Building> ConsumeRecipe(Func<T, Recipe> recipe, Func<T, Recipe> display) {
        this.recipe = recipe;
        this.display = display;
    }

    public <T extends Building> ConsumeRecipe(Func<T, Recipe> recipe) {
        this.recipe = recipe;
        this.display = recipe;
    }

    public void apply(Block block) {
        block.hasItems = true;
        block.hasLiquids = true;
        block.acceptsItems = true;
        block.acceptsPayload = true;
    }

    public void update(Building build) {
        if (this.recipe.get((Object)build) == null) {
            return;
        }
        for (LiquidStack stack : ((Recipe)this.recipe.get((Object)build)).inputLiquid) {
            build.liquids.remove(stack.liquid, stack.amount * build.edelta() * this.multiplier.get((Object)build));
        }
    }

    public void trigger(Building build) {
        if (this.recipe.get((Object)build) == null) {
            return;
        }
        for (ItemStack stack : ((Recipe)this.recipe.get((Object)build)).inputItem) {
            build.items.remove(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)));
        }
        for (ItemStack stack : ((Recipe)this.recipe.get((Object)build)).inputPayload) {
            build.getPayloads().remove(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)));
        }
    }

    public float efficiency(Building build) {
        float ed = build.edelta() * build.efficiencyScale();
        if (ed <= 1.0E-8f) {
            return 0.0f;
        }
        if (this.recipe.get((Object)build) == null) {
            return 0.0f;
        }
        float min = 1.0f;
        for (PayloadStack stack : ((Recipe)this.recipe.get((Object)build)).inputPayload) {
            if (build.getPayloads().contains(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)))) continue;
            min = 0.0f;
            break;
        }
        for (PayloadStack stack : ((Recipe)this.recipe.get((Object)build)).inputItem) {
            if (build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)))) continue;
            min = 0.0f;
            break;
        }
        for (PayloadStack stack : ((Recipe)this.recipe.get((Object)build)).inputLiquid) {
            min = Math.min(build.liquids.get(stack.liquid) / (stack.amount * ed * this.multiplier.get((Object)build)), min);
        }
        return min;
    }

    public void build(Building build, Table table) {
        if (this.display.get((Object)build) == null) {
            return;
        }
        table.update(() -> {
            table.clear();
            table.left();
            ItemStack[] currentItem = (ItemStack[])((Recipe)this.display.get((Object)build)).inputItem.toArray(ItemStack.class);
            LiquidStack[] currentLiquid = (LiquidStack[])((Recipe)this.display.get((Object)build)).inputLiquid.toArray(LiquidStack.class);
            PayloadStack[] currentPayload = (PayloadStack[])((Recipe)this.display.get((Object)build)).inputPayload.toArray(PayloadStack.class);
            table.table(cont -> {
                int i = 0;
                if (currentItem != null) {
                    for (ItemStack itemStack : currentItem) {
                        cont.add((Element)new ReqImage((Element)StatValues.stack((UnlockableContent)itemStack.item, (int)Math.round((float)itemStack.amount * this.multiplier.get((Object)build))), () -> build.items != null && build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build))))).padRight(8.0f).left();
                        if (++i % 4 != 0) continue;
                        cont.row();
                    }
                }
                if (currentLiquid != null) {
                    for (ItemStack itemStack : currentLiquid) {
                        cont.add((Element)new ReqImage(itemStack.liquid.uiIcon, () -> ConsumeRecipe.lambda$build$1(build, (LiquidStack)itemStack))).size(32.0f).padRight(8.0f);
                        if (++i % 4 != 0) continue;
                        cont.row();
                    }
                }
                if (currentPayload != null) {
                    for (ItemStack itemStack : currentPayload) {
                        cont.add((Element)new ReqImage((Element)StatValues.stack((UnlockableContent)itemStack.item, (int)Math.round((float)itemStack.amount * this.multiplier.get((Object)build))), () -> this.lambda$build$2(build, (PayloadStack)itemStack))).padRight(8.0f);
                        if (++i % 4 != 0) continue;
                        cont.row();
                    }
                }
            });
        });
    }

    private /* synthetic */ boolean lambda$build$2(Building build, PayloadStack stack) {
        return build.getPayloads() != null && build.getPayloads().contains(stack.item, Math.round((float)stack.amount * this.multiplier.get((Object)build)));
    }

    private static /* synthetic */ boolean lambda$build$1(Building build, LiquidStack stack) {
        return build.liquids != null && build.liquids.get(stack.liquid) > 0.0f;
    }
}

