/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.commandable;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.core.World;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootPattern;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.ui.Bar;
import mindustry.ui.Styles;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import newhorizon.NHGroups;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.expand.block.commandable.CommandableBlock;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.ui.NHUIFunc;
import newhorizon.util.ui.TableFunc;

public abstract class CommandableAttackerBlock
extends CommandableBlock {
    public float spread = 120.0f;
    public float prepareDelay = 60.0f;
    public int storage = 1;
    public ShootPattern shoot = new ShootPattern();
    protected BulletType bullet;
    protected UnitTypes spawnUnit;

    public CommandableAttackerBlock(String name) {
        super(name);
        this.replaceable = true;
        this.canOverdrive = false;
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.accent);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.damage, StatValues.ammo((ObjectMap)ObjectMap.of((Object[])new Object[]{this, this.bullet})));
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", entity -> new Bar(() -> Core.bundle.get("bar.progress"), () -> Pal.power, () -> entity.reload % this.reloadTime / this.reloadTime));
        this.addBar("storage", entity -> new Bar(() -> Core.bundle.format("bar.capacity", new Object[]{UI.formatAmount((long)entity.ammo())}), () -> Pal.ammo, () -> (float)entity.ammo() / (float)this.storage));
    }

    public abstract class CommandableAttackerBlockBuild
    extends CommandableBlock.CommandableBlockBuild {
        public CommandableAttackerBlockBuild() {
            super(CommandableAttackerBlock.this);
        }

        @Override
        public boolean isCharging() {
            return this.efficiency > 0.0f && this.reload < CommandableAttackerBlock.this.reloadTime * (float)CommandableAttackerBlock.this.storage && !this.initiateConfigure;
        }

        @Override
        public boolean shouldCharge() {
            return this.reload < CommandableAttackerBlock.this.reloadTime * (float)CommandableAttackerBlock.this.storage;
        }

        public int ammo() {
            return (int)(this.reload / CommandableAttackerBlock.this.reloadTime);
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            super.control(type, p1, p2, p3, p4);
        }

        public BlockStatus status() {
            return this.canCommand(this.targetVec) ? BlockStatus.active : (this.isCharging() ? BlockStatus.noOutput : BlockStatus.noInput);
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.shouldChargeConfigure()) {
                this.configureChargeProgress += this.edelta() * this.warmup;
                if (this.configureChargeComplete()) {
                    this.shoot(this.lastConfirmedTarget);
                }
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.target = read.i();
            this.reload = read.f();
            this.initiateConfigure = read.bool();
            this.configureChargeProgress = read.f();
            TypeIO.readVec2((Reads)read, (Vec2)this.lastConfirmedTarget);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.target);
            write.f(this.reload);
            write.bool(this.initiateConfigure);
            write.f(this.configureChargeProgress);
            TypeIO.writeVec2((Writes)write, (Vec2)this.lastConfirmedTarget);
        }

        @Override
        public void command(Vec2 pos) {
            this.lastConfirmedTarget.set(pos);
            this.targetVec.set(pos);
            this.target = Point2.pack((int)World.toTile((float)pos.x), (int)World.toTile((float)pos.y));
            this.initiateConfigure = true;
            NHFx.attackWarningPos.at(this.lastConfirmedTarget.x, this.lastConfirmedTarget.y, CommandableAttackerBlock.this.configureChargeTime, this.team.color, (Object)this.tile);
        }

        public void shoot(Vec2 target) {
            this.configureChargeProgress = 0.0f;
            this.initiateConfigure = false;
            this.reload = Math.max(0.0f, this.reload - CommandableAttackerBlock.this.reloadTime);
            this.consume();
        }

        public void drawConfigure() {
            super.drawConfigure();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)CommandableAttackerBlock.this.range, (Color)this.team.color);
            Seq builds = new Seq();
            for (CommandableBlock.CommandableBlockBuild build : NHGroups.commandableBuilds) {
                if (build == this || build == null || build.team != this.team || !CommandableAttackerBlock.this.sameGroup(build.block) || !build.canCommand(this.targetVec)) continue;
                builds.add((Object)build);
                DrawFunc.posSquareLink(Pal.gray, 3.0f, 4.0f, false, build.x, build.y, this.targetVec.x, this.targetVec.y);
            }
            for (CommandableBlock.CommandableBlockBuild build : builds) {
                DrawFunc.posSquareLink(Pal.heal, 1.0f, 2.0f, false, build.x, build.y, this.targetVec.x, this.targetVec.y);
            }
            if (builds.any()) {
                DrawFunc.posSquareLink(Pal.accent, 1.0f, 2.0f, true, this.x, this.y, this.targetVec.x, this.targetVec.y);
                DrawFunc.drawConnected(this.targetVec.x, this.targetVec.y, 10.0f, Pal.accent);
            }
            if (this.canCommand(this.targetVec)) {
                builds.add((Object)this);
            }
            if (builds.any()) {
                DrawFunc.overlayText(Core.bundle.format("mod.ui.participants", new Object[]{builds.size}), this.targetVec.x, this.targetVec.y, 16.0f, Pal.accent, true);
            }
        }

        @Override
        public void commandAll(Vec2 pos) {
            CommandableBlock.participantsTmp.clear();
            for (CommandableBlock.CommandableBlockBuild build : NHGroups.commandableBuilds) {
                if (build.team != this.team || !CommandableAttackerBlock.this.sameGroup(build.block) || !build.canCommand(pos)) continue;
                build.command(pos);
                CommandableBlock.participantsTmp.add((Object)build);
                build.lastAccessed = "\ue865";
            }
            if (!Vars.headless && CommandableBlock.participantsTmp.any()) {
                if (this.team != Vars.player.team()) {
                    NHUIFunc.showToast((Drawable)Icon.warning, "[#ff7b69]Caution: []Attack " + (int)(pos.x / 8.0f) + ", " + (int)(pos.y / 8.0f), NHSounds.alert2);
                }
                NHFx.attackWarningRange.at(pos.x, pos.y, 80.0f, this.team.color);
            }
        }

        @Override
        public boolean canCommand(Vec2 target) {
            return this.ammo() > 0 && this.warmup > 0.25f && this.within((Position)target, this.range()) && !this.isChargingConfigure();
        }

        public void buildConfiguration(Table table) {
            Vars.control.input.selectedBlock();
            table.table(Tex.paneSolid, t -> {
                t.button((Drawable)Icon.modeAttack, Styles.cleari, () -> this.configure(this.targetVec)).size(60.0f).disabled(b -> this.targetVec.epsilonEquals(this.x, this.y, 0.1f));
                t.button("@mod.ui.select-target", (Drawable)Icon.move, Styles.cleart, 60.0f, () -> TableFunc.selectPos(t, (Cons<Point2>)((Cons)arg_0 -> ((CommandableAttackerBlockBuild)this).configure(arg_0)))).size(240.0f, 60.0f).row();
            }).fill();
        }
    }
}

