/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.bullets;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.bullets.DOTBulletType;
import newhorizon.expand.bullets.raid.BasicRaidBulletType;
import newhorizon.expand.bullets.raid.TracerRaidBulletType;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.OptionalMultiEffect;

@Deprecated
public class RaidBullets {
    public static final Rand rand = new Rand();
    public static BulletType raidBullet_1;
    public static BulletType raidBullet_2;
    public static BulletType raidBullet_3;
    public static BulletType raidBullet_4;
    public static BulletType raidBullet_5;
    public static BulletType raidBullet_6;
    public static BulletType raidBullet_7;
    public static BulletType raidBullet_8;

    public static void load() {
        raidBullet_1 = new BasicRaidBulletType(){
            {
                this.speed = 12.0f;
                this.lifetime = 120.0f;
                this.damage = 2000.0f;
                this.splashDamageRadius = 80.0f;
                this.splashDamage = 1000.0f;
                this.splashDamagePierce = true;
                this.scaledSplashDamage = true;
                this.collides = false;
                this.collidesGround = true;
                this.collideFloor = true;
                this.collidesAir = true;
                this.hittable = true;
                this.reflectable = false;
                this.absorbable = true;
                this.despawnHit = true;
                this.trailLength = 40;
                this.trailChance = 1.0f;
                this.trailParam = 6.0f;
                this.drawSize = 120.0f;
                this.despawnShake = 16.0f;
                this.hitShake = 16.0f;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.height = 65.0f;
                this.width = 40.0f;
                this.sprite = NHBullets.STRIKE;
                this.hitSound = Sounds.explosion;
                this.trailEffect = RaidBullets.spark(45.0f, 40.0f);
                this.despawnEffect = new OptionalMultiEffect(RaidBullets.spark(90.0f, 120.0f), RaidBullets.spark(40.0f, 150.0f), RaidBullets.spark(60.0f, 135.0f), RaidBullets.circle(35.0f, 45.0f), RaidBullets.circle(25.0f, 60.0f), RaidBullets.circle(25.0f, 75.0f), RaidBullets.circle(30.0f, 100.0f));
            }
        };
        raidBullet_2 = new TracerRaidBulletType(){
            {
                this.speed = 3.5f;
                this.lifetime = 120.0f;
                this.damage = 500.0f;
                this.splashDamageRadius = 60.0f;
                this.splashDamage = 500.0f;
                this.splashDamagePierce = true;
                this.scaledSplashDamage = true;
                this.collides = false;
                this.collidesGround = true;
                this.collideFloor = true;
                this.collidesAir = true;
                this.hittable = true;
                this.reflectable = false;
                this.absorbable = true;
                this.despawnHit = true;
                this.trailLength = 30;
                this.trailChance = 0.8f;
                this.trailParam = 3.0f;
                this.drawSize = 120.0f;
                this.despawnShake = 16.0f;
                this.hitShake = 16.0f;
                this.tracers = 2;
                this.tracerFadeOffset = 15;
                this.tracerStrokeOffset = 15;
                this.tracerStroke = 3.0f;
                this.tracerSpacing = 8.0f;
                this.tracerRandX = 6.0f;
                this.tracerUpdateSpacing = 2.0f;
                this.shrinkY = 0.0f;
                this.shrinkX = 0.0f;
                this.height = 22.0f;
                this.width = 22.0f;
                this.sprite = "large-orb";
                this.hitSound = Sounds.explosion;
                this.trailEffect = RaidBullets.triSpark(45.0f, 15.0f);
                this.despawnEffect = new OptionalMultiEffect(RaidBullets.spark(90.0f, 90.0f), RaidBullets.spark(40.0f, 60.0f), RaidBullets.spark(60.0f, 85.0f), RaidBullets.circle(35.0f, 25.0f), RaidBullets.circle(25.0f, 40.0f), RaidBullets.circle(25.0f, 65.0f), RaidBullets.crossBlast(45.0f, 80.0f, 0.0f));
            }
        };
        raidBullet_3 = NHBullets.railGun1;
        raidBullet_4 = NHBullets.railGun2;
        raidBullet_5 = NHBullets.railGun3;
        raidBullet_6 = new ArtilleryBulletType(){
            {
                this.damage = 75.0f;
                this.speed = 6.5f;
                this.lifetime = 150.0f;
                this.despawnShake = 2.0f;
                this.hitShake = 2.0f;
                this.status = NHStatusEffects.emp3;
                this.hitSound = Sounds.none;
                this.fragBullet = new DOTBulletType(){
                    {
                        this.damage = 75.0f;
                        this.DOTDamage = 75.0f;
                        this.DOTRadius = 16.0f;
                        this.radIncrease = 0.28f;
                        this.effect = NHStatusEffects.emp3;
                        this.fx = NHFx.triSpark2;
                        this.lightningColor = NHColor.ancient;
                    }
                };
                this.fragBullets = 1;
                this.homingRange = 22.0f;
                this.homingPower = 0.13f;
                this.trailChance = 0.8f;
                this.trailEffect = NHFx.triSpark2;
                this.trailColor = this.hitColor = NHColor.ancient;
                this.lightningColor = this.hitColor;
                this.lightColor = this.hitColor;
                this.backColor = this.hitColor;
                this.rangeChange = 45.0f;
                this.despawnEffect = Fx.none;
                this.hitEffect = new OptionalMultiEffect(NHFx.smoothColorCircle(NHColor.ancient, 100.0f, 125.0f, 0.3f), NHFx.circleOut(150.0f, 100.0f, 4.0f), NHFx.circleOut(78.0f, 75.0f, 2.0f), NHFx.subEffect(130.0f, 85.0f, 12, 30.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                    float fout = Interp.pow2Out.apply(1.0f - fin);
                    float finpow = Interp.pow3Out.apply(fin);
                    Tmp.v1.trns(rot, 25.0f * finpow);
                    Draw.color((Color)NHColor.ancient);
                    for (int s : Mathf.signs) {
                        Drawf.tri((float)x, (float)y, (float)(14.0f * fout), (float)(30.0f * Mathf.curve((float)finpow, (float)0.0f, (float)0.3f) * NHFx.fout(fin, 0.15f)), (float)(rot + (float)(s * 90)));
                    }
                }));
            }
        };
        raidBullet_7 = NHBullets.shieldDestroyer;
        raidBullet_8 = NHBullets.ancientArtilleryProjectile;
    }

    public static Effect circle(float lifetime, float radius) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
            Lines.stroke((float)(radius / 30.0f * e.fslope()));
            Lines.circle((float)e.x, (float)e.y, (float)(radius * e.fin()));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * radius * 1.25f), (Color)e.color, (float)0.7f);
        });
    }

    public static Effect spark(float lifetime, float radius) {
        return new Effect(lifetime, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.3f));
            Lines.stroke((float)(e.fout() * Mathf.sqrt((float)(radius / 6.0f)) * 1.5f));
            rand.setSeed((long)e.id);
            Angles.randLenVectors((long)e.id, (int)((int)(radius / 6.0f)), (float)(e.finpow() * radius), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fout() * rand.random(2.0f, 4.0f) * radius / 10.0f + 1.0f)));
        });
    }

    public static Effect triSpark(float lifetime, float radius) {
        return new Effect(lifetime, e -> {
            rand.setSeed((long)e.id);
            Draw.color((Color)e.color, (Color)Color.white, (float)e.fin());
            Angles.randLenVectors((long)e.id, (int)((int)(radius / 8.0f)), (float)(3.0f + radius * e.fin()), (float)5.0f, (x, y) -> {
                float randN = rand.random(120.0f);
                Fill.poly((float)(e.x + x), (float)(e.y + y), (int)3, (float)(e.fout() * (radius / 3.0f) * rand.random(0.8f, 1.2f)), (float)(e.rotation + randN * e.fin()));
            });
        });
    }

    public static Effect crossBlast(float lifetime, float size, float rotate) {
        return new Effect(lifetime, size * 2.0f, e -> {
            Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.55f));
            Drawf.light((float)e.x, (float)e.y, (float)(e.fout() * size), (Color)e.color, (float)0.7f);
            rand.setSeed((long)e.id);
            float sizeDiv = size / 1.5f;
            float randL = rand.random(sizeDiv);
            for (int i = 0; i < 4; ++i) {
                DrawFunc.tri(e.x, e.y, size / 20.0f * (e.fout() * 3.0f + 1.0f) / 4.0f * (e.fout((Interp)Interp.pow3In) + 0.5f) / 1.5f, (sizeDiv + randL) * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.05f) * e.fout((Interp)Interp.pow3), (float)(i * 90) + rotate);
            }
        });
    }
}

