/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.HaloPart;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootAlternate;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootHelix;
import mindustry.entities.pattern.ShootMulti;
import mindustry.entities.pattern.ShootPattern;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeCoolant;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.BuildVisibility;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.block.ancient.CaptureableTurret;
import newhorizon.expand.block.drawer.DrawArrowSequence;
import newhorizon.expand.block.drawer.FlipRegionPart;
import newhorizon.expand.block.turrets.AdaptItemTurret;
import newhorizon.expand.block.turrets.ContinuousOverheatTurret;
import newhorizon.expand.block.turrets.ShootMatchTurret;
import newhorizon.expand.block.turrets.SpeedupTurret;
import newhorizon.expand.bullets.DOTBulletType;
import newhorizon.expand.bullets.UpgradePointLaserBulletType;
import newhorizon.expand.bullets.adapt.AdaptBulletType;
import newhorizon.expand.bullets.adapt.AdaptLaserBulletType;
import newhorizon.expand.bullets.adapt.PosLightningType;
import newhorizon.expand.game.NHUnitSorts;
import newhorizon.util.graphic.OptionalMultiEffect;

public class TurretBlock {
    public static Block ancientArtillery;
    public static Block thermo;
    public static Block pulse;
    public static Block beam;
    public static Block argmot;
    public static Block synchro;
    public static Block slavio;
    public static Block bombard;
    public static Block vortex;
    public static Block electro;
    public static Block concentration;
    public static Block testShooter;

    public static void load() {
        ancientArtillery = new CaptureableTurret("ancient-artillery"){
            {
                this.size = 8;
                this.destructible = false;
                this.health = 45000;
                this.armor = 120.0f;
                this.lightColor = NHColor.ancientLightMid;
                this.clipSize = 192.0f;
                this.outlineColor = Pal.darkOutline;
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.ancimembrane, 1200, NHItems.seniorProcessor, 300}));
                this.warmupMaintainTime = 90.0f;
                this.shootWarmupSpeed /= 5.0f;
                this.minWarmup = 0.9f;
                this.shootCone = 15.0f;
                this.rotateSpeed = 0.325f;
                this.canOverdrive = false;
                this.ammo(new Object[]{NHItems.fusionEnergy, NHBullets.ancientArtilleryProjectile});
                this.shooter(NHItems.fusionEnergy, new ShootPattern());
                this.ammoPerShot = 12;
                this.maxAmmo = 180;
                this.range = 1200.0f;
                this.trackingRange = this.range * 1.2f;
                this.reload = 120.0f;
                this.unitSort = NHUnitSorts.slowest;
                this.shake = 7.0f;
                this.recoil = 3.0f;
                this.shootY = -13.5f;
                this.shootSound = NHSounds.flak;
                this.consumePowerCond(5.0f, Turret.TurretBuild::isActive);
                this.enableDrawStatus = false;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-additional"){
                            {
                                super(arg0);
                                this.drawRegion = false;
                                this.heatColor = Color.red;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatLightOpacity = 0.55f;
                            }
                        }, new FlipRegionPart("-armor"){
                            {
                                super(region);
                                this.mirror = true;
                                this.outline = true;
                                this.layerOffset = 0.2f;
                                this.x = 25.0f;
                                this.moveY = 16.0f;
                                this.moveX = 8.0f;
                                this.moveRot = -45.0f;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -6.0f, 0.0f));
                            }
                        }, new FlipRegionPart("-back"){
                            {
                                super(region);
                                this.mirror = true;
                                this.outline = true;
                                this.layerOffset = 0.3f;
                                this.x = 29.0f;
                                this.y = -24.5f;
                                this.moveY = -2.0f;
                                this.moveX = 5.0f;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -4.0f, 0.0f));
                            }
                        }, new FlipRegionPart("-cover"){
                            {
                                super(region);
                                this.outline = true;
                                this.layerOffset = 0.3f;
                                this.turretHeatLayer = 50.1f + this.layerOffset;
                                this.heatColor = Color.red;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatLightOpacity = 0.55f;
                            }
                        }, new FlipRegionPart("-barrel"){
                            {
                                super(region);
                                this.mirror = true;
                                this.outline = true;
                                this.layerOffset = 0.2f;
                                this.x = 2.0f;
                                this.turretHeatLayer = 50.1f + this.layerOffset;
                                this.heatColor = Color.red;
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatLightOpacity = 0.55f;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.recoil, -1.75f, -8.0f, -2.12f));
                                this.moveY = 6.0f;
                                this.moveX = 7.75f;
                                this.moveRot = 3.6f;
                            }
                        }, new FlipRegionPart("-tail"){
                            {
                                super(region);
                                this.mirror = true;
                                this.outline = true;
                                this.layerOffset = 0.2f;
                                this.x = 10.0f;
                                this.y = -27.5f;
                                this.moveY = -4.0f;
                                this.moveX = 2.0f;
                            }
                        }, new DrawArrowSequence(){
                            {
                                this.x = 0.0f;
                                this.y = 2.0f;
                                this.arrows = 9;
                                this.color = NHColor.ancientLightMid;
                                this.colorTo = Color.red;
                                this.colorToFinScl = 0.12f;
                            }
                        }, new HaloPart(){
                            {
                                this.y = -52.0f;
                                this.layer = 100.0f;
                                this.color = NHColor.ancient;
                                this.colorTo = NHColor.ancientLightMid;
                                this.hollow = true;
                                this.tri = false;
                                this.shapes = 1;
                                this.sides = 16;
                                this.stroke = -1.0f;
                                this.strokeTo = 3.4f;
                                this.radius = 8.0f;
                                this.radiusTo = 14.5f;
                                this.haloRadius = 0.0f;
                                this.haloRotateSpeed = 2.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.y = -52.0f;
                                this.layer = 100.0f;
                                this.color = NHColor.ancient;
                                this.colorTo = NHColor.ancientLightMid;
                                this.tri = true;
                                this.shapes = 2;
                                this.radius = -1.0f;
                                this.radiusTo = 4.2f;
                                this.triLength = 6.0f;
                                this.triLengthTo = 18.0f;
                                this.haloRadius = 14.0f;
                                this.haloRadiusTo = 25.0f;
                                this.haloRotateSpeed = 1.5f;
                            }
                        }, new HaloPart(){
                            {
                                this.y = -52.0f;
                                this.layer = 100.0f;
                                this.color = NHColor.ancient;
                                this.colorTo = NHColor.ancientLightMid;
                                this.tri = true;
                                this.shapes = 2;
                                this.radius = -1.0f;
                                this.radiusTo = 4.2f;
                                this.triLength = 0.0f;
                                this.triLengthTo = 4.0f;
                                this.haloRadius = 14.0f;
                                this.haloRadiusTo = 25.0f;
                                this.shapeRotation = 180.0f;
                                this.haloRotateSpeed = 1.5f;
                            }
                        }, new HaloPart(){
                            {
                                this.y = -52.0f;
                                this.layer = 100.0f;
                                this.color = NHColor.ancient;
                                this.colorTo = NHColor.ancientLightMid;
                                this.tri = true;
                                this.shapes = 2;
                                this.radius = -1.0f;
                                this.radiusTo = 5.0f;
                                this.triLength = 10.0f;
                                this.triLengthTo = 24.0f;
                                this.haloRadius = 15.0f;
                                this.haloRadiusTo = 28.0f;
                                this.haloRotateSpeed = -1.0f;
                            }
                        }, new HaloPart(){
                            {
                                this.y = -52.0f;
                                this.layer = 100.0f;
                                this.color = NHColor.ancient;
                                this.colorTo = NHColor.ancientLightMid;
                                this.tri = true;
                                this.shapes = 2;
                                this.radius = -1.0f;
                                this.radiusTo = 5.0f;
                                this.triLength = 0.0f;
                                this.triLengthTo = 6.0f;
                                this.haloRadius = 15.0f;
                                this.haloRadiusTo = 28.0f;
                                this.shapeRotation = 180.0f;
                                this.haloRotateSpeed = -1.0f;
                            }
                        }});
                    }
                };
            }
        };
        thermo = new PowerTurret("thermo-turret"){
            {
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.titanium, 20, NHItems.silicon, 25}));
                this.size = 1;
                this.health = 500;
                this.range = 160.0f;
                this.reload = 60.0f;
                this.inaccuracy = 3.0f;
                this.shootCone = 50.0f;
                this.rotateSpeed = 8.0f;
                this.velocityRnd = 0.15f;
                this.shootEffect = Fx.lightningShoot;
                this.smokeEffect = Fx.shootSmallSmoke;
                this.shootSound = NHSounds.shootBlaster3;
                this.shootType = new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 25.0f, 40.0f);
                        this.bundleName = "basic-thermo-bullet";
                        this.speed = 6.5f;
                        this.lifetime = 30.0f;
                        this.knockback = 0.5f;
                        this.width = 5.0f;
                        this.height = 22.0f;
                        this.drawSize = 120.0f;
                        this.trailWidth = 1.25f;
                        this.trailLength = 9;
                        this.trailColor = Pal.lancerLaser;
                        this.homingDelay = 1.0f;
                        this.homingPower = 0.2f;
                        this.homingRange = 120.0f;
                        this.backColor = this.hitColor = Pal.lancerLaser;
                        this.frontColor = Color.white;
                        this.hitEffect = new Effect(12.0f, e -> {
                            Draw.color((Color)Pal.lancerLaser, (Color)Color.white, (float)(e.fout() * 0.75f));
                            Lines.stroke((float)(e.fout() * 1.5f));
                            Angles.randLenVectors((long)e.id, (int)3, (float)(e.finpow() * 17.0f), (float)e.rotation, (float)360.0f, (x, y) -> {
                                float ang = Mathf.angle((float)x, (float)y);
                                Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 4.0f + 1.0f));
                            });
                        });
                    }
                };
                this.shoot = new ShootSpread(){
                    {
                        this.shots = 4;
                        this.shotDelay = 0.0f;
                    }
                };
                this.consumeLiquid(NHLiquids.xenFluid, 0.06666667f);
                this.consumePower(1.6666666f);
            }
        };
        pulse = new ItemTurret("pulse"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.titanium, 50, NHItems.silicon, 75}));
                this.size = 2;
                this.health = 1200;
                this.range = 160.0f;
                this.reload = 75.0f;
                this.recoil = 1.5f;
                this.shake = 3.0f;
                this.shootCone = 30.0f;
                this.inaccuracy = 4.0f;
                this.maxAmmo = 150;
                this.ammoPerShot = 10;
                this.minWarmup = 0.15f;
                this.outlineColor = Pal.darkOutline;
                this.smokeEffect = Fx.shootBigSmoke;
                this.shootSound = NHSounds.shootBlaster2;
                this.ammo(new Object[]{NHItems.titanium, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 45.0f, 20.0f);
                        this.bundleName = "pulse-bullet-titanium";
                        this.width = 8.0f;
                        this.height = 25.0f;
                        this.speed = 5.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lightColor = this.trailColor = Items.titanium.color.cpy().lerp(Color.white, 0.1f);
                        this.backColor = this.trailColor;
                        this.hitColor = this.trailColor;
                        this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                        this.hitEffect = NHFx.crossBlast(this.hitColor, this.height + this.width);
                        this.shootEffect = this.despawnEffect = NHFx.square(this.hitColor, 20.0f, 3, 12.0f, 2.0f);
                        this.trailLength = 5;
                    }
                }, NHItems.plastanium, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 20.0f, 30.0f, 45.0f, 15.0f);
                        this.bundleName = "pulse-bullet-plastanium";
                        this.width = 8.0f;
                        this.height = 25.0f;
                        this.speed = 5.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lightColor = this.trailColor = Items.plastanium.color.cpy().lerp(Color.white, 0.1f);
                        this.backColor = this.trailColor;
                        this.hitColor = this.trailColor;
                        this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                        this.hitEffect = NHFx.hitSpark(this.hitColor, 30.0f, 6, 32.0f, 1.4f, 7.0f);
                        this.shootEffect = this.despawnEffect = NHFx.square(this.hitColor, 20.0f, 3, 20.0f, 2.0f);
                        this.trailLength = 5;
                    }
                }, NHItems.zeta, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 32.0f, 80.0f, 60.0f);
                        this.bundleName = "pulse-bullet-zeta";
                        this.speed = 5.0f;
                        this.width = 8.0f;
                        this.height = 25.0f;
                        this.ammoMultiplier = 4.0f;
                        this.status = StatusEffects.shocked;
                        this.statusDuration = 60.0f;
                        this.lightColor = this.trailColor = Items.pyratite.color.cpy().lerp(Color.white, 0.1f);
                        this.backColor = this.trailColor;
                        this.hitColor = this.trailColor;
                        this.lightningColor = this.trailColor;
                        this.frontColor = this.backColor.cpy().lerp(Color.white, 0.35f);
                        this.hitEffect = NHFx.crossBlast(this.hitColor, this.height + this.width);
                        this.shootEffect = this.despawnEffect = NHFx.square(this.hitColor, 20.0f, 3, 20.0f, 2.0f);
                        this.trailLength = 5;
                    }
                }});
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 6;
                        this.shotDelay = 3.0f;
                    }
                };
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.under = true;
                                this.outline = true;
                                this.moveY = -3.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }
                };
                this.coolant = this.consumeCoolant(0.1f);
                this.limitRange();
            }
        };
        beam = new ItemTurret("beam"){
            {
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.titanium, 60, NHItems.juniorProcessor, 60}));
                this.size = 2;
                this.health = 1200;
                this.reload = 60.0f;
                this.range = 120.0f;
                this.recoil = 0.5f;
                this.rotateSpeed = 2.5f;
                this.cooldownTime = 40.0f;
                this.shootCone = 30.0f;
                this.inaccuracy = 6.0f;
                this.shootY = 5.0f;
                this.maxAmmo = 30;
                this.ammoPerShot = 3;
                this.smokeEffect = Fx.shootBigSmoke2;
                this.shootSound = NHSounds.laser5;
                this.outlineColor = Pal.darkOutline;
                this.heatColor = Pal.turretHeat.cpy().lerp(Pal.redderDust, 0.5f).mul(1.1f);
                this.ammo(new Object[]{Items.silicon, new AdaptLaserBulletType(){
                    {
                        this.setDamage((BulletType)this, 60.0f, 150.0f);
                        this.length = 150.0f;
                        this.lifetime = 30.0f;
                        this.width = 8.0f;
                        this.lengthFalloff = 0.8f;
                        this.sideLength = 25.0f;
                        this.sideWidth = 0.7f;
                        this.sideAngle = 30.0f;
                        this.pierceCap = 3;
                        this.drawLightning = true;
                        this.hitColor = Pal.bulletYellow;
                        this.shootEffect = NHFx.square(this.hitColor, 15.0f, 2, 8.0f, 2.0f);
                        this.colors = new Color[]{Pal.bulletYellowBack.cpy().mul(1.0f, 1.0f, 1.0f, 0.35f), Pal.bulletYellowBack, Color.white};
                    }
                }});
                this.shoot = new ShootPattern(){
                    {
                        this.shots = 3;
                        this.shotDelay = 3.0f;
                    }
                };
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.under = true;
                                this.outline = true;
                                this.moveY = -1.25f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }
                };
                this.consumePowerCond(2.5f, Turret.TurretBuild::isActive);
                this.coolant = this.consumeCoolant(0.2f);
                this.coolantMultiplier = 2.5f;
                this.buildType = () -> new ItemTurret.ItemTurretBuild(){

                    protected void turnToTarget(float targetRot) {
                        this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(rotateSpeed * this.delta() * this.potentialEfficiency * Interp.pow3Out.apply(Interp.reverse.apply(this.curRecoil))));
                    }
                };
            }
        };
        synchro = new AdaptItemTurret("synchro"){
            {
                this.requirements(Category.turret, BuildVisibility.shown, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 60, NHItems.presstanium, 80, Items.tungsten, 50}));
                this.size = 3;
                this.health = 240 * this.size * this.size;
                this.reload = 12.0f;
                this.inaccuracy = 0.75f;
                this.recoil = 0.5f;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-shooter"){
                            {
                                super(arg0);
                                this.under = true;
                                this.outline = true;
                                this.moveY = -3.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }
                };
                this.coolant = this.consumeCoolant(0.2f);
                this.coolantMultiplier = 2.5f;
                this.velocityRnd = 0.075f;
                this.unitSort = NHUnitSorts.noShield;
                this.range = 250.0f;
                this.shootSound = NHSounds.synchro;
                this.shoot = new ShootMulti(new ShootPattern(), new ShootPattern[]{new ShootBarrel(){
                    {
                        this.barrels = new float[]{-6.5f, 3.0f, 0.0f};
                    }
                }, new ShootBarrel(){
                    {
                        this.barrels = new float[]{6.5f, 3.0f, 0.0f};
                    }
                }});
                this.ammo(new Object[]{Items.titanium, NHBullets.synchroTitanium, Items.tungsten, NHBullets.synchroTungsten, NHItems.zeta, NHBullets.synchroZeta, NHItems.fusionEnergy, NHBullets.synchroFusionEnergy});
                this.ammoPerShot = 1;
                this.maxAmmo = 40;
            }
        };
        argmot = new SpeedupTurret("argmot"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 80, NHItems.presstanium, 120, Items.tungsten, 80}));
                this.shoot = new ShootAlternate(){
                    {
                        this.spread = 7.0f;
                    }
                };
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart(){
                            {
                                this.drawRegion = false;
                                this.mirror = true;
                                this.moveY = -2.75f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.children.add((Object)new RegionPart("-shooter"){
                                    {
                                        super(arg0);
                                        this.heatLayerOffset = 0.001f;
                                        this.heatColor = NHColor.thurmixRed.cpy().a(0.85f);
                                        this.progress = DrawPart.PartProgress.warmup;
                                        this.outline = true;
                                        this.mirror = true;
                                        this.moveX = 2.0f;
                                        this.moveY = 2.0f;
                                        this.moveRot = 11.25f;
                                    }
                                });
                            }
                        }, (Object)new RegionPart("-up"){
                            {
                                super(arg0);
                                this.layerOffset = 0.3f;
                                this.turretHeatLayer += this.layerOffset + 0.1f;
                                this.heatColor = NHColor.thurmixRed.cpy().a(0.85f);
                                this.outline = false;
                            }
                        });
                    }
                };
                this.warmupMaintainTime = 120.0f;
                this.rotateSpeed = 3.0f;
                this.health = 960;
                this.maxSpeedupScl = 4.0f;
                this.speedupPerShoot = 0.2f;
                this.overheatTime = 600.0f;
                this.overheatCoolAmount = 2.0f;
                this.hasLiquids = true;
                this.coolant = new ConsumeCoolant(0.15f){
                    {
                        super(arg0);
                        this.booster = false;
                        this.optional = false;
                    }
                };
                this.size = 3;
                this.range = 200.0f;
                this.reload = 60.0f;
                this.shootCone = 24.0f;
                this.shootSound = NHSounds.laser3;
                this.shootType = new PosLightningType(){
                    {
                        this.damage = 150.0f;
                        this.shieldDamageMultiplier = 0.2f;
                        this.lightningColor = this.hitColor = NHColor.lightSkyBack;
                        this.rangeOverride = 250.0f;
                        this.maxRange = 250.0f;
                        this.hitEffect = NHFx.hitSpark;
                        this.smokeEffect = Fx.shootBigSmoke2;
                    }
                };
                this.consumePowerCond(5.0f, Turret.TurretBuild::isActive);
            }
        };
        slavio = new ItemTurret("slavio"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 120, NHItems.presstanium, 150, Items.carbide, 150, NHItems.metalOxhydrigen, 80}));
                this.ammo(new Object[]{NHItems.zeta, new AdaptBulletType(){
                    {
                        this.damage = 10.0f;
                        this.splashDamage = 60.0f;
                        this.splashDamageRadius = 16.0f;
                        this.shieldDamageMultiplier = 0.6f;
                        this.backSprite = "missile-large-back";
                        this.sprite = "mine-bullet";
                        this.height = 9.0f;
                        this.width = 5.6f;
                        this.frontColor = NHItems.zeta.color;
                        this.trailColor = this.hitColor = Pal.bulletYellowBack;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.trailLength = 12;
                        this.trailWidth = 2.0f;
                        this.trailEffect = NHFx.triSpark;
                        this.trailRotation = true;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.hitEffect = this.despawnEffect = NHFx.hitSpark;
                        this.despawnShake = 7.0f;
                        this.speed = 5.2f;
                        this.shrinkY = 0.3f;
                        this.homingDelay = 0.0f;
                        this.homingRange = 40.0f;
                        this.homingPower = 0.05f;
                        this.ammoMultiplier = 3.0f;
                        this.lifetime = 80.0f;
                    }
                }, NHItems.metalOxhydrigen, new AdaptBulletType(){
                    {
                        this.damage = 10.0f;
                        this.splashDamage = 60.0f;
                        this.splashDamageRadius = 20.0f;
                        this.shieldDamageMultiplier = 0.5f;
                        this.backSprite = "missile-large-back";
                        this.sprite = "mine-bullet";
                        this.height = 11.0f;
                        this.width = 6.0f;
                        this.frontColor = NHColor.lightSky;
                        this.trailColor = this.hitColor = NHColor.lightSkyBack;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.trailLength = 12;
                        this.trailWidth = 2.0f;
                        this.trailEffect = NHFx.triSpark;
                        this.trailRotation = true;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.hitEffect = this.despawnEffect = NHFx.hitSpark;
                        this.despawnShake = 7.0f;
                        this.speed = 7.0f;
                        this.shrinkY = 0.3f;
                        this.homingDelay = 20.0f;
                        this.homingRange = 100.0f;
                        this.homingPower = 0.05f;
                        this.ammoMultiplier = 4.0f;
                        this.reloadMultiplier = 1.35f;
                        this.lifetime = 60.0f;
                    }
                }, Items.surgeAlloy, new AdaptBulletType(){
                    {
                        this.damage = 10.0f;
                        this.splashDamage = 120.0f;
                        this.splashDamageRadius = 20.0f;
                        this.shieldDamageMultiplier = 0.8f;
                        this.status = StatusEffects.shocked;
                        this.backSprite = "missile-large-back";
                        this.sprite = "mine-bullet";
                        this.height = 11.0f;
                        this.width = 6.0f;
                        this.lightningDamage = 25.0f;
                        this.lightning = 4;
                        this.lightningLength = 6;
                        this.frontColor = Pal.surgeAmmoBack;
                        this.trailColor = this.hitColor = Pal.surgeAmmoBack;
                        this.backColor = this.hitColor;
                        this.trailChance = 0.44f;
                        this.trailLength = 12;
                        this.trailWidth = 2.0f;
                        this.trailEffect = NHFx.triSpark;
                        this.trailRotation = true;
                        this.shootEffect = Fx.shootBig2;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.hitEffect = this.despawnEffect = NHFx.hitSpark;
                        this.despawnShake = 7.0f;
                        this.speed = 8.0f;
                        this.shrinkY = 0.3f;
                        this.homingDelay = 20.0f;
                        this.homingRange = 100.0f;
                        this.homingPower = 0.05f;
                        this.ammoMultiplier = 2.0f;
                        this.reloadMultiplier = 1.5f;
                        this.lifetime = 60.0f;
                    }
                }});
                this.shoot = new ShootAlternate(){
                    {
                        this.spread = 4.8f;
                        this.shotDelay = 4.0f;
                        this.shots = 4;
                        this.barrels = 4;
                    }
                };
                this.reload = 40.0f;
                this.shootY = 12.0f;
                this.rotateSpeed = 5.0f;
                this.shootCone = 15.0f;
                this.consumeAmmoOnce = true;
                this.shootSound = NHSounds.scatter;
                this.unitSort = NHUnitSorts.noShield;
                this.drawer = new DrawTurret(){
                    {
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.moveY = -2.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        }, new RegionPart("-bottom"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveX = -0.5f;
                                this.moveY = -2.0f;
                                this.moveRot = 45.0f;
                            }
                        }, new RegionPart("-bottom"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveX = -2.0f;
                                this.moveY = 0.5f;
                            }
                        }, new RegionPart("-front"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveY = -1.0f;
                                this.moveX = -1.0f;
                            }
                        }});
                    }
                };
                this.shootWarmupSpeed = 0.08f;
                this.minWarmup = 0.8f;
                this.scaledHealth = 300.0f;
                this.range = 320.0f;
                this.trackingRange = this.range * 1.4f;
                this.size = 3;
                this.limitRange(-5.0f);
                this.coolant = this.consumeCoolant(0.25f);
                this.coolantMultiplier = 2.5f;
            }
        };
        bombard = new ShootMatchTurret("bombard"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.surgeAlloy, 150, NHItems.phaseFabric, 120, NHItems.presstanium, 200, NHItems.metalOxhydrigen, 250, NHItems.juniorProcessor, 80}));
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-mid"){
                            {
                                super(arg0);
                                this.moveY = -3.0f;
                                this.layerOffset = 0.01f;
                                this.outline = true;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.moveX = 5.5f;
                                this.layerOffset = 0.01f;
                                this.outline = true;
                                this.mirror = true;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.recoil, 0.0f, -4.0f, 0.0f, 0.0f, 0.0f));
                            }
                        });
                    }
                };
                this.size = 4;
                this.shootY = 12.0f;
                this.maxAmmo = 80;
                this.reload = 90.0f;
                this.health = 2600;
                this.recoil = 0.74f;
                this.inaccuracy = 2.0f;
                this.range = 500.0f;
                this.minWarmup = 0.9f;
                this.liquidCapacity = 90.0f;
                this.rotateSpeed = 1.22f;
                this.velocityRnd = 0.088f;
                this.coolantMultiplier = 3.0f;
                this.trackingRange = 480.0f;
                this.shootWarmupSpeed = 0.05f;
                this.targetAir = false;
                this.squareSprite = false;
                this.unitSort = NHUnitSorts.slowest;
                this.shootSound = Sounds.shootArtillery;
                this.outlineColor = Pal.darkOutline;
                this.ammo(new Object[]{NHItems.metalOxhydrigen, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 48.0f, 150.0f, 180.0f);
                        this.sprite = "mine-bullet";
                        this.scaleLife = true;
                        this.collides = false;
                        this.artilleryTrail = true;
                        this.collidesAir = false;
                        this.collidesTiles = false;
                        this.scaledSplashDamage = true;
                        this.speed = 6.0f;
                        this.hitShake = 1.0f;
                        this.inaccuracy = 0.0f;
                        this.lifetime = 111.0f;
                        this.trailLength = 22;
                        this.trailWidth = 2.25f;
                        this.height = 15.0f;
                        this.width = 15.0f;
                        this.shrinkY = 0.3f;
                        this.shrinkX = 0.3f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.trailInterp = Interp.slope;
                        this.shrinkInterp = Interp.slope;
                        this.hitSound = Sounds.explosion;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.trailEffect = Fx.artilleryTrail;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.despawnEffect = NHFx.square45_6_45;
                        this.frontColor = NHItems.metalOxhydrigen.color.cpy().lerp(Color.white, 0.3f);
                        this.lightningColor = this.trailColor = NHItems.metalOxhydrigen.color;
                        this.lightColor = this.trailColor;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                        this.trailParam = 1.2f;
                    }
                }, NHItems.carbide, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 40.0f, 330.0f, 220.0f);
                        this.sprite = "mine-bullet";
                        this.scaleLife = true;
                        this.collides = false;
                        this.artilleryTrail = true;
                        this.collidesAir = false;
                        this.collidesTiles = false;
                        this.scaledSplashDamage = true;
                        this.speed = 5.0f;
                        this.hitShake = 1.0f;
                        this.inaccuracy = 0.0f;
                        this.lifetime = 134.0f;
                        this.trailLength = 25;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.height = 18.0f;
                        this.width = 18.0f;
                        this.reloadMultiplier = 0.8f;
                        this.shrinkY = 0.3f;
                        this.shrinkX = 0.3f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.trailInterp = Interp.slope;
                        this.shrinkInterp = Interp.slope;
                        this.hitSound = Sounds.explosion;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.trailEffect = Fx.artilleryTrail;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.despawnEffect = NHFx.square45_6_45;
                        this.frontColor = NHItems.carbide.color.cpy().lerp(Color.white, 0.1f);
                        this.lightningColor = this.trailColor = NHItems.carbide.color;
                        this.lightColor = this.trailColor;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                    }
                }, NHItems.fusionEnergy, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 96.0f, 350.0f, 500.0f);
                        this.sprite = "mine-bullet";
                        this.velocityDecay = true;
                        this.scaleLife = true;
                        this.collides = false;
                        this.artilleryTrail = true;
                        this.collidesAir = false;
                        this.collidesTiles = false;
                        this.scaledSplashDamage = true;
                        this.rangeChange = 30.0f;
                        this.speed = 6.0f;
                        this.hitShake = 1.0f;
                        this.inaccuracy = 4.0f;
                        this.lifetime = 120.0f;
                        this.trailLength = 25;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.height = 18.0f;
                        this.width = 18.0f;
                        this.reloadMultiplier = 0.4f;
                        this.shrinkY = 0.3f;
                        this.shrinkX = 0.3f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.frontColor = Color.white;
                        this.trailInterp = Interp.slope;
                        this.shrinkInterp = Interp.slope;
                        this.hitSound = Sounds.explosion;
                        this.hitEffect = NHFx.square45_8_45;
                        this.trailEffect = Fx.artilleryTrail;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.lightColor = this.trailColor = NHItems.fusionEnergy.color;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                        this.despawnEffect = NHFx.blast(NHItems.fusionEnergy.color, this.splashDamageRadius * 0.52f);
                    }
                }, NHItems.thermoCoreNegative, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 80.0f, 1000.0f, 900.0f);
                        this.sprite = "mine-bullet";
                        this.hasTracer = true;
                        this.velocityDecay = true;
                        this.scaleLife = true;
                        this.collides = false;
                        this.artilleryTrail = true;
                        this.collidesAir = false;
                        this.collidesTiles = false;
                        this.scaledSplashDamage = true;
                        this.rangeChange = 60.0f;
                        this.speed = 6.0f;
                        this.hitShake = 1.0f;
                        this.inaccuracy = 4.0f;
                        this.lifetime = 125.0f;
                        this.trailLength = 15;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.height = 22.0f;
                        this.width = 22.0f;
                        this.reloadMultiplier = 0.4f;
                        this.shrinkY = 0.3f;
                        this.shrinkX = 0.3f;
                        this.buildingDamageMultiplier = 0.2f;
                        this.lightning = 3;
                        this.lightningCone = 360.0f;
                        this.lightningLengthRand = 12;
                        this.lightningLength = 4;
                        this.lightningDamage = 50.0f;
                        this.frontColor = Color.white;
                        this.shrinkInterp = Interp.slope;
                        this.hitSound = Sounds.explosion;
                        this.hitEffect = NHFx.hitSparkHuge;
                        this.trailEffect = Fx.artilleryTrail;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.lightColor = this.trailColor = NHItems.thermoCoreNegative.color;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                        this.lightningColor = this.trailColor;
                        this.despawnEffect = new OptionalMultiEffect(NHFx.crossBlast_45, NHFx.blast(NHItems.thermoCoreNegative.color, this.splashDamageRadius * 0.65f));
                    }
                }});
                this.shooter(NHItems.metalOxhydrigen, new ShootMulti((ShootPattern)new ShootBarrel(){
                    {
                        this.barrels = new float[]{5.0f, -3.0f, 0.0f, -5.0f, -3.0f, 0.0f, 11.0f, -2.0f, 0.0f, -11.0f, -2.0f, 0.0f};
                        this.shots = 4;
                    }
                }, new ShootPattern[]{new ShootPattern(){
                    {
                        this.shots = 3;
                        this.shotDelay = 12.0f;
                    }
                }}), NHItems.carbide, new ShootMulti((ShootPattern)new ShootBarrel(){
                    {
                        this.barrels = new float[]{5.5f, -3.0f, 0.0f, -5.5f, -3.0f, 0.0f, 0.0f, -3.0f, 0.0f, 11.0f, -2.0f, 0.0f, -11.0f, -2.0f, 0.0f};
                        this.shots = 5;
                    }
                }, new ShootPattern[]{new ShootPattern(){
                    {
                        this.shots = 2;
                        this.shotDelay = 20.0f;
                    }
                }}), NHItems.fusionEnergy, new ShootBarrel(){
                    {
                        this.barrels = new float[]{-5.0f, -2.0f, 0.0f, 11.0f, -3.0f, 0.0f, -11.0f, -3.0f, 0.0f, 5.0f, -2.0f, 0.0f};
                        this.shots = 8;
                        this.shotDelay = 5.0f;
                    }
                }, NHItems.thermoCoreNegative, new ShootBarrel(){
                    {
                        this.barrels = new float[]{-5.0f, -2.0f, 0.0f, 11.0f, -3.0f, 0.0f, -11.0f, -3.0f, 0.0f, 5.0f, -2.0f, 0.0f};
                        this.shots = 4;
                        this.shotDelay = 9.0f;
                    }
                });
                this.shoot = new ShootBarrel(){
                    {
                        this.barrels = new float[]{5.0f, -3.0f, 0.0f, -5.0f, -3.0f, 0.0f, 11.0f, -2.0f, 0.0f, -11.0f, -2.0f, 0.0f};
                        this.shots = 4;
                    }
                };
                this.coolant = new ConsumeCoolant(0.6f);
            }
        };
        vortex = new ShootMatchTurret("vortex"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.multipleSteel, 120, NHItems.seniorProcessor, 80, NHItems.presstanium, 200, NHItems.phaseFabric, 100, NHItems.zeta, 320}));
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-side"){
                            {
                                super(arg0);
                                this.moveX = 2.0f;
                                this.under = true;
                                this.outline = true;
                                this.mirror = true;
                                this.progress = DrawPart.PartProgress.warmup;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.moveY = -1.75f;
                                this.progress = DrawPart.PartProgress.recoil;
                            }
                        });
                    }
                };
                this.size = 4;
                this.shootY = 12.0f;
                this.maxAmmo = 80;
                this.reload = 15.0f;
                this.health = 2600;
                this.recoil = 0.74f;
                this.shootCone = 30.0f;
                this.range = 360.0f;
                this.minWarmup = 0.9f;
                this.liquidCapacity = 90.0f;
                this.rotateSpeed = 1.22f;
                this.coolantMultiplier = 3.0f;
                this.shootWarmupSpeed = 0.07f;
                this.shootSound = NHSounds.laser4;
                this.outlineColor = Pal.darkOutline;
                this.ammo(new Object[]{NHItems.multipleSteel, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 40.0f, 160.0f, 100.0f);
                        this.collides = true;
                        this.artilleryTrail = true;
                        this.collidesAir = true;
                        this.width = 12.0f;
                        this.height = 20.0f;
                        this.speed = 7.5f;
                        this.hitShake = 1.0f;
                        this.pierceCap = 3;
                        this.shrinkX = 0.3f;
                        this.lifetime = 50.0f;
                        this.trailLength = 15;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.trailInterval = 4.0f;
                        this.buildingDamageMultiplier = 0.25f;
                        this.hitSound = Sounds.explosion;
                        this.trailEffect = NHFx.polyTrail;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.despawnEffect = NHFx.square45_6_45;
                        this.frontColor = NHColor.lightSkyFront;
                        this.lightColor = this.trailColor = NHItems.multipleSteel.color;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                    }
                }, NHItems.phaseFabric, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 24.0f, 80.0f, 150.0f);
                        this.collides = true;
                        this.artilleryTrail = true;
                        this.collidesAir = true;
                        this.width = 12.0f;
                        this.height = 20.0f;
                        this.speed = 8.0f;
                        this.hitShake = 1.0f;
                        this.pierceCap = 4;
                        this.shrinkX = 0.3f;
                        this.lifetime = 45.0f;
                        this.trailLength = 15;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.trailInterval = 4.0f;
                        this.buildingDamageMultiplier = 0.25f;
                        this.frontColor = Color.white;
                        this.hitSound = Sounds.explosion;
                        this.trailEffect = NHFx.polyTrail;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.despawnEffect = NHFx.square45_6_45;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.lightColor = this.trailColor = Items.phaseFabric.color;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                    }
                }, NHItems.irayrondPanel, new AdaptBulletType(){
                    {
                        this.setDamage((BulletType)this, 40.0f, 200.0f, 120.0f);
                        this.collides = true;
                        this.artilleryTrail = true;
                        this.collidesAir = true;
                        this.width = 15.0f;
                        this.height = 22.0f;
                        this.speed = 10.0f;
                        this.hitShake = 1.0f;
                        this.pierceCap = 4;
                        this.shrinkX = 0.3f;
                        this.lifetime = 40.0f;
                        this.trailLength = 15;
                        this.trailParam = 1.2f;
                        this.trailWidth = 2.5f;
                        this.trailInterval = 4.0f;
                        this.buildingDamageMultiplier = 0.25f;
                        this.frontColor = Color.white;
                        this.hitSound = Sounds.explosion;
                        this.trailEffect = NHFx.polyTrail;
                        this.hitEffect = NHFx.hitSparkLarge;
                        this.shootEffect = NHFx.shootCircle(32.0f);
                        this.despawnEffect = NHFx.square45_6_45;
                        this.smokeEffect = Fx.shootSmokeDisperse;
                        this.lightColor = this.trailColor = NHItems.irayrondPanel.color;
                        this.hitColor = this.trailColor;
                        this.backColor = this.trailColor;
                    }
                }});
                this.shooter(NHItems.multipleSteel, new ShootHelix(){
                    {
                        this.mag = 2.0f;
                        this.scl = 3.0f;
                        this.offset = 1.5707964f;
                    }

                    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
                        for (int i = 0; i < this.shots; ++i) {
                            for (int sign : Mathf.signs) {
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i);
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time + this.offset), (float)this.scl, (float)(this.mag * (float)sign))));
                            }
                        }
                    }
                }, NHItems.phaseFabric, new ShootHelix(){
                    {
                        this.mag = 2.0f;
                        this.scl = 3.0f;
                        this.offset = 1.5707964f;
                    }

                    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
                        for (int i = 0; i < this.shots; ++i) {
                            for (int sign : Mathf.signs) {
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time + this.offset), (float)this.scl, (float)(this.mag * (float)sign))));
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time * 1.5f + this.offset), (float)(this.scl / 1.5f), (float)(this.mag * (float)sign * 2.0f))));
                            }
                        }
                    }
                }, NHItems.irayrondPanel, new ShootHelix(){
                    {
                        this.mag = 2.0f;
                        this.scl = 2.0f;
                        this.offset = 2.3561945f;
                    }

                    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
                        for (int i = 0; i < this.shots; ++i) {
                            for (int sign : Mathf.signs) {
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i);
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time + this.offset), (float)this.scl, (float)(this.mag * (float)sign))));
                                handler.shoot(5.5f * (float)sign, 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time + this.offset), (float)(this.scl / 1.5f), (float)(this.mag * (float)sign * 2.0f))));
                            }
                        }
                    }
                });
                this.coolant = new ConsumeCoolant(0.6f);
            }
        };
        electro = new ItemTurret("electro"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.juniorProcessor, 200, Items.carbide, 150, Items.surgeAlloy, 100, NHItems.phaseFabric, 100}));
                this.canOverdrive = false;
                this.health = 3200;
                this.outlineColor = Pal.darkOutline;
                this.velocityRnd = 0.2f;
                this.ammo(new Object[]{NHItems.juniorProcessor, new ArtilleryBulletType(){
                    {
                        this.damage = 40.0f;
                        this.speed = 6.0f;
                        this.lifetime = 120.0f;
                        this.despawnShake = 1.2f;
                        this.hitShake = 1.2f;
                        this.status = NHStatusEffects.emp2;
                        this.hitSound = Sounds.none;
                        this.fragBullet = new DOTBulletType(){
                            {
                                this.damage = 40.0f;
                                this.DOTDamage = 40.0f;
                                this.DOTRadius = 12.0f;
                                this.radIncrease = 0.25f;
                                this.fx = NHFx.triSpark1;
                                this.lightningColor = Pal.techBlue;
                            }
                        };
                        this.fragBullets = 1;
                        this.homingRange = 20.0f;
                        this.homingPower = 0.12f;
                        this.trailChance = 0.8f;
                        this.trailEffect = NHFx.triSpark1;
                        this.trailColor = this.hitColor = Pal.techBlue;
                        this.lightningColor = this.hitColor;
                        this.lightColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.despawnEffect = Fx.none;
                        this.hitEffect = new OptionalMultiEffect(NHFx.smoothColorCircle(Pal.techBlue, 78.0f, 150.0f, 0.6f), NHFx.circleOut(70.0f, 60.0f, 2.0f));
                    }
                }, NHItems.seniorProcessor, new ArtilleryBulletType(){
                    {
                        this.damage = 75.0f;
                        this.speed = 6.5f;
                        this.lifetime = 150.0f;
                        this.despawnShake = 2.0f;
                        this.hitShake = 2.0f;
                        this.status = NHStatusEffects.emp3;
                        this.hitSound = Sounds.none;
                        this.fragBullet = new DOTBulletType(){
                            {
                                this.damage = 75.0f;
                                this.DOTDamage = 75.0f;
                                this.DOTRadius = 16.0f;
                                this.radIncrease = 0.28f;
                                this.effect = NHStatusEffects.emp3;
                                this.fx = NHFx.triSpark2;
                                this.lightningColor = NHItems.seniorProcessor.color;
                            }
                        };
                        this.fragBullets = 1;
                        this.homingRange = 22.0f;
                        this.homingPower = 0.13f;
                        this.trailChance = 0.8f;
                        this.trailEffect = NHFx.triSpark2;
                        this.trailColor = this.hitColor = NHItems.seniorProcessor.color;
                        this.lightningColor = this.hitColor;
                        this.lightColor = this.hitColor;
                        this.backColor = this.hitColor;
                        this.rangeChange = 45.0f;
                        this.despawnEffect = Fx.none;
                        this.hitEffect = new OptionalMultiEffect(NHFx.smoothColorCircle(NHItems.seniorProcessor.color, 100.0f, 125.0f, 0.3f), NHFx.circleOut(150.0f, 100.0f, 4.0f), NHFx.circleOut(78.0f, 75.0f, 2.0f), NHFx.subEffect(130.0f, 85.0f, 12, 30.0f, (Interp)Interp.pow2Out, (i, x, y, rot, fin) -> {
                            float fout = Interp.pow2Out.apply(1.0f - fin);
                            float finpow = Interp.pow3Out.apply(fin);
                            Tmp.v1.trns(rot, 25.0f * finpow);
                            Draw.color((Color)NHItems.seniorProcessor.color);
                            for (int s : Mathf.signs) {
                                Drawf.tri((float)x, (float)y, (float)(14.0f * fout), (float)(30.0f * Mathf.curve((float)finpow, (float)0.0f, (float)0.3f) * NHFx.fout(fin, 0.15f)), (float)(rot + (float)(s * 90)));
                            }
                        }));
                    }
                }});
                this.reload = 120.0f;
                this.shootY = 10.0f;
                this.rotateSpeed = 2.0f;
                this.shootCone = 15.0f;
                this.consumeAmmoOnce = true;
                this.shootSound = NHSounds.laser2;
                this.consumePower(16.666666f);
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(arg0);
                        this.parts.addAll((Object[])new DrawPart[]{new RegionPart("-blade"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.moveX = 1.0f;
                                this.moveY = -1.5f;
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatColor = Pal.techBlue;
                                this.heatLightOpacity = 0.2f;
                            }
                        }, new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.moveY = -3.0f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatColor = Pal.techBlue;
                                this.heatLightOpacity = 0.2f;
                            }
                        }, new RegionPart("-bottom"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveY = -0.8f;
                                this.moveX = 0.8f;
                                this.progress = DrawPart.PartProgress.recoil;
                                this.heatColor = Pal.techBlue;
                                this.heatLightOpacity = 0.2f;
                            }
                        }, new RegionPart("-upper"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                            }
                        }});
                    }
                };
                this.minWarmup = 0.8f;
                this.shootWarmupSpeed = 0.08f;
                this.scaledHealth = 300.0f;
                this.range = 350.0f;
                this.size = 4;
                this.shootEffect = NHFx.square(NHColor.ancient, 55.0f, 12, 60.0f, 6.0f);
                this.limitRange(-5.0f);
            }
        };
        concentration = new ContinuousOverheatTurret("concentration"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.carbide, 500, NHItems.setonAlloy, 300, NHItems.seniorProcessor, 200}));
                this.shootType = new UpgradePointLaserBulletType(){
                    {
                        this.damage = 500.0f;
                        this.shieldDamageMultiplier = 2.0f;
                        this.hitEffect = NHFx.hitSpark;
                        this.buildingDamageMultiplier = 0.5f;
                        this.damageInterval = 6.0f;
                        this.sprite = "laser-white";
                        this.status = NHStatusEffects.emp3;
                        this.statusDuration = 60.0f;
                        this.oscScl /= 1.77f;
                        this.oscMag /= 1.33f;
                        this.hitShake = 2.0f;
                        this.range = 600.0f;
                        this.trailLength = 8;
                    }
                };
                this.drawer = new DrawTurret(){
                    {
                        this.parts.add((Object)new RegionPart("-charger"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveRot = 10.0f;
                                this.moveX = 4.677f;
                                this.moveY = 6.8f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-side"){
                            {
                                super(arg0);
                                this.mirror = true;
                                this.under = true;
                                this.moveRot = 10.0f;
                                this.moveX = 2.75f;
                                this.moveY = 2.0f;
                            }
                        });
                        this.parts.add((Object)new RegionPart("-barrel"){
                            {
                                super(arg0);
                                this.moveY = -7.5f;
                                this.progress = this.progress.curve((Interp)Interp.pow2Out);
                            }
                        });
                    }
                };
                this.shootSound = Sounds.none;
                this.loopSoundVolume = 1.0f;
                this.loopSound = NHSounds.largeBeam;
                this.shootWarmupSpeed = 0.08f;
                this.shootCone = 360.0f;
                this.aimChangeSpeed = 1.75f;
                this.rotateSpeed = 1.45f;
                this.canOverdrive = false;
                this.shootY = 16.0f;
                this.minWarmup = 0.8f;
                this.warmupMaintainTime = 45.0f;
                this.shootWarmupSpeed /= 2.0f;
                this.outlineColor = Pal.darkOutline;
                this.size = 5;
                this.range = 600.0f;
                this.scaledHealth = 300.0f;
                this.armor = 10.0f;
                this.unitSort = NHUnitSorts.slowest;
                this.consumePower(16.0f);
                this.consumeLiquid(NHLiquids.xenFluid, 0.2f);
            }
        };
    }

    public static void loadTest() {
        testShooter = new PowerTurret("test-turret"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{NHItems.presstanium, 10}));
                this.size = 3;
                this.health = 3200;
                this.range = 200.0f;
                this.reload = 10.0f;
                this.shootSound = NHSounds.shootPulse3;
            }
        };
    }
}

