/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.content.blocks;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawCrucibleFlame;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BlockGroup;
import newhorizon.content.NHColor;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHItems;
import newhorizon.content.NHLiquids;
import newhorizon.expand.block.drawer.DrawRotator;
import newhorizon.expand.block.production.drill.AdaptDrill;
import newhorizon.expand.block.production.drill.DrillModule;
import newhorizon.expand.block.production.drill.OreCollector;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.util.graphic.OptionalMultiEffect;

public class ProductionBlock {
    public static Block sandCracker;
    public static Block tungstenReconstructor;
    public static Block titaniumReconstructor;
    public static Block liquidConvertor;
    public static Block xenExtractor;
    public static Block xenIterator;
    public static Block scanCollector;
    public static AdaptDrill resonanceMiningFacility;
    public static AdaptDrill beamMiningFacility;
    public static AdaptDrill implosionMiningFacility;
    public static DrillModule speedModule;
    public static DrillModule speedModuleMk2;
    public static DrillModule refineModule;
    public static DrillModule convertorModule;
    public static DrillModule deliveryModule;

    public static void load() {
        scanCollector = new OreCollector("scan-collector"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.silicon, 40, NHItems.graphite, 40}));
                this.size = 3;
                this.addLink(new int[]{0, 2, 2, 0, -3, 2});
                this.itemCapacity = 30;
                this.consumePower(2.5f);
                this.consumeLiquid(NHLiquids.ammonia, 0.083333336f).boost();
            }
        };
        sandCracker = new RecipeGenericCrafter("sand-cracker"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.silicon, 40, NHItems.graphite, 40}));
                this.size = 2;
                this.health = 300;
                this.armor = 2.0f;
                this.itemCapacity = 30;
                this.rotate = false;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-base"), new DrawRotator(), new DrawRegion("-top")});
                this.craftEffect = NHFx.hugeSmokeGray;
                this.updateEffect = new Effect(80.0f, e -> {
                    Fx.rand.setSeed((long)e.id);
                    Draw.color((Color)Color.lightGray, (Color)Color.gray, (float)e.fin());
                    Angles.randLenVectors((long)e.id, (int)4, (float)(2.0f + 12.0f * e.fin((Interp)Interp.pow3Out)), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(e.fout() * Fx.rand.random(1.0f, 2.5f))));
                }).layer(36.0f);
                this.consumePower(5.0f);
            }
        };
        tungstenReconstructor = new RecipeGenericCrafter("tungsten-reconstructor"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.silicon, 40, NHItems.graphite, 40}));
                this.size = 2;
                this.craftTime = 60.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 30.0f;
                this.rotate = false;
                this.craftEffect = this.updateEffect = NHFx.square(NHColor.thurmixRed, 60.0f, 6, 16.0f, 3.0f);
                this.consumePower(5.0f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault()});
            }
        };
        titaniumReconstructor = new RecipeGenericCrafter("titanium-reconstructor"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.silicon, 40, NHItems.graphite, 40}));
                this.size = 2;
                this.craftTime = 60.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 30.0f;
                this.rotate = false;
                this.craftEffect = this.updateEffect = NHFx.square(NHColor.xenGamma, 60.0f, 6, 16.0f, 3.0f);
                this.consumePower(5.0f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawDefault()});
            }
        };
        liquidConvertor = new RecipeGenericCrafter("liquid-convertor"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.silicon, 40, NHItems.graphite, 40}));
                this.size = 2;
                this.health = 300;
                this.armor = 2.0f;
                this.itemCapacity = 30;
                this.liquidCapacity = 90.0f;
                this.rotate = false;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-base"), new DrawCrucibleFlame(){
                    {
                        this.midColor = this.flameColor = Pal.accent;
                        this.flameRad /= 1.585f;
                        this.particleRad /= 1.5f;
                    }
                }, new DrawRegion("-top")});
                this.craftEffect = this.updateEffect = NHFx.square(Pal.accent, 60.0f, 6, 16.0f, 3.0f);
                this.consumePower(5.0f);
            }
        };
        xenExtractor = new ThermalGenerator("xen-extractor"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.titanium, 40, NHItems.silicon, 40}));
                this.attribute = NHContent.quantum;
                this.group = BlockGroup.liquids;
                this.displayEfficiencyScale = 0.11111111f;
                this.minEfficiency = 8.9999f;
                this.powerProduction = 1.4814817f;
                this.displayEfficiency = false;
                this.effectChance = 0.2f;
                this.generateEffect = new OptionalMultiEffect(NHFx.square(NHColor.lightSkyFront, 60.0f, 6, 32.0f, 3.0f), new Effect(40.0f, 80.0f, e -> {
                    Draw.color((Color)NHColor.lightSkyFront, (Color)NHColor.lightSkyBack, (float)(e.fin() * 0.8f));
                    Lines.stroke((float)(2.0f * e.fout()));
                    Lines.spikes((float)e.x, (float)e.y, (float)(12.0f * e.finpow()), (float)(1.5f * e.fout() + 4.0f * e.fslope()), (int)4, (float)45.0f);
                }));
                this.effectChance = 0.04f;
                this.size = 3;
                this.squareSprite = false;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-base"), new DrawLiquidTile(NHLiquids.xenFluid, 2.0f), new DrawRegion("-top")});
                this.hasLiquids = true;
                this.outputLiquid = new LiquidStack(NHLiquids.xenFluid, 0.055555556f);
                this.liquidCapacity = 300.0f;
                this.health = 1200;
                this.armor = 8.0f;
            }
        };
        xenIterator = new RecipeGenericCrafter("xen-iterator"){
            {
                this.requirements(Category.production, ItemStack.with((Object[])new Object[]{NHItems.metalOxhydrigen, 40, NHItems.juniorProcessor, 80, NHItems.zeta, 100}));
                this.size = 3;
                this.health = 1350;
                this.armor = 10.0f;
                this.itemCapacity = 30;
                this.rotate = false;
                this.liquidCapacity = 300.0f;
            }
        };
    }
}

